/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration;

import co.elastic.clients.elasticsearch.migration.post_feature_upgrade.MigrationFeature;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PostFeatureUpgradeResponse
implements JsonpSerializable {
    private final boolean accepted;
    private final List<MigrationFeature> features;
    @Nullable
    private final String reason;
    public static final JsonpDeserializer<PostFeatureUpgradeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostFeatureUpgradeResponse::setupPostFeatureUpgradeResponseDeserializer);

    private PostFeatureUpgradeResponse(Builder builder) {
        this.accepted = ApiTypeHelper.requireNonNull(builder.accepted, (Object)this, "accepted", false);
        this.features = ApiTypeHelper.unmodifiable(builder.features);
        this.reason = builder.reason;
    }

    public static PostFeatureUpgradeResponse of(Function<Builder, ObjectBuilder<PostFeatureUpgradeResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean accepted() {
        return this.accepted;
    }

    public final List<MigrationFeature> features() {
        return this.features;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("accepted");
        generator.write(this.accepted);
        if (ApiTypeHelper.isDefined(this.features)) {
            generator.writeKey("features");
            generator.writeStartArray();
            for (MigrationFeature item0 : this.features) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPostFeatureUpgradeResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accepted, JsonpDeserializer.booleanDeserializer(), "accepted");
        op.add(Builder::features, JsonpDeserializer.arrayDeserializer(MigrationFeature._DESERIALIZER), "features");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PostFeatureUpgradeResponse> {
        private Boolean accepted;
        @Nullable
        private List<MigrationFeature> features;
        @Nullable
        private String reason;

        public final Builder accepted(boolean value) {
            this.accepted = value;
            return this;
        }

        public final Builder features(List<MigrationFeature> list) {
            this.features = Builder._listAddAll(this.features, list);
            return this;
        }

        public final Builder features(MigrationFeature value, MigrationFeature ... values) {
            this.features = Builder._listAdd(this.features, value, values);
            return this;
        }

        public final Builder features(Function<MigrationFeature.Builder, ObjectBuilder<MigrationFeature>> fn) {
            return this.features(fn.apply(new MigrationFeature.Builder()).build(), new MigrationFeature[0]);
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostFeatureUpgradeResponse build() {
            this._checkSingleUse();
            return new PostFeatureUpgradeResponse(this);
        }
    }
}

