/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.data_streams_stats.DataStreamsStatsItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamsStatsResponse
implements JsonpSerializable {
    private final ShardStatistics shards;
    private final int backingIndices;
    private final int dataStreamCount;
    private final List<DataStreamsStatsItem> dataStreams;
    @Nullable
    private final String totalStoreSizes;
    private final long totalStoreSizeBytes;
    public static final JsonpDeserializer<DataStreamsStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamsStatsResponse::setupDataStreamsStatsResponseDeserializer);

    private DataStreamsStatsResponse(Builder builder) {
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.backingIndices = ApiTypeHelper.requireNonNull(builder.backingIndices, (Object)this, "backingIndices", 0);
        this.dataStreamCount = ApiTypeHelper.requireNonNull(builder.dataStreamCount, (Object)this, "dataStreamCount", 0);
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
        this.totalStoreSizes = builder.totalStoreSizes;
        this.totalStoreSizeBytes = ApiTypeHelper.requireNonNull(builder.totalStoreSizeBytes, (Object)this, "totalStoreSizeBytes", 0L);
    }

    public static DataStreamsStatsResponse of(Function<Builder, ObjectBuilder<DataStreamsStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final int backingIndices() {
        return this.backingIndices;
    }

    public final int dataStreamCount() {
        return this.dataStreamCount;
    }

    public final List<DataStreamsStatsItem> dataStreams() {
        return this.dataStreams;
    }

    @Nullable
    public final String totalStoreSizes() {
        return this.totalStoreSizes;
    }

    public final long totalStoreSizeBytes() {
        return this.totalStoreSizeBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("backing_indices");
        generator.write(this.backingIndices);
        generator.writeKey("data_stream_count");
        generator.write(this.dataStreamCount);
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartArray();
            for (DataStreamsStatsItem item0 : this.dataStreams) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalStoreSizes != null) {
            generator.writeKey("total_store_sizes");
            generator.write(this.totalStoreSizes);
        }
        generator.writeKey("total_store_size_bytes");
        generator.write(this.totalStoreSizeBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamsStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::backingIndices, JsonpDeserializer.integerDeserializer(), "backing_indices");
        op.add(Builder::dataStreamCount, JsonpDeserializer.integerDeserializer(), "data_stream_count");
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(DataStreamsStatsItem._DESERIALIZER), "data_streams");
        op.add(Builder::totalStoreSizes, JsonpDeserializer.stringDeserializer(), "total_store_sizes");
        op.add(Builder::totalStoreSizeBytes, JsonpDeserializer.longDeserializer(), "total_store_size_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamsStatsResponse> {
        private ShardStatistics shards;
        private Integer backingIndices;
        private Integer dataStreamCount;
        private List<DataStreamsStatsItem> dataStreams;
        @Nullable
        private String totalStoreSizes;
        private Long totalStoreSizeBytes;

        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder backingIndices(int value) {
            this.backingIndices = value;
            return this;
        }

        public final Builder dataStreamCount(int value) {
            this.dataStreamCount = value;
            return this;
        }

        public final Builder dataStreams(List<DataStreamsStatsItem> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        public final Builder dataStreams(DataStreamsStatsItem value, DataStreamsStatsItem ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        public final Builder dataStreams(Function<DataStreamsStatsItem.Builder, ObjectBuilder<DataStreamsStatsItem>> fn) {
            return this.dataStreams(fn.apply(new DataStreamsStatsItem.Builder()).build(), new DataStreamsStatsItem[0]);
        }

        public final Builder totalStoreSizes(@Nullable String value) {
            this.totalStoreSizes = value;
            return this;
        }

        public final Builder totalStoreSizeBytes(long value) {
            this.totalStoreSizeBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamsStatsResponse build() {
            this._checkSingleUse();
            return new DataStreamsStatsResponse(this);
        }
    }
}

