/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.FrequencyEncodingPreprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.OneHotEncodingPreprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.PreprocessorVariant;
import co.elastic.clients.elasticsearch.ml.put_trained_model.TargetMeanEncodingPreprocessor;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Preprocessor
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Preprocessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Preprocessor::setupPreprocessorDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Preprocessor(PreprocessorVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._preprocessorKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Preprocessor(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Preprocessor of(Function<Builder, ObjectBuilder<Preprocessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isFrequencyEncoding() {
        return this._kind == Kind.FrequencyEncoding;
    }

    public FrequencyEncodingPreprocessor frequencyEncoding() {
        return (FrequencyEncodingPreprocessor)TaggedUnionUtils.get(this, Kind.FrequencyEncoding);
    }

    public boolean isOneHotEncoding() {
        return this._kind == Kind.OneHotEncoding;
    }

    public OneHotEncodingPreprocessor oneHotEncoding() {
        return (OneHotEncodingPreprocessor)TaggedUnionUtils.get(this, Kind.OneHotEncoding);
    }

    public boolean isTargetMeanEncoding() {
        return this._kind == Kind.TargetMeanEncoding;
    }

    public TargetMeanEncodingPreprocessor targetMeanEncoding() {
        return (TargetMeanEncodingPreprocessor)TaggedUnionUtils.get(this, Kind.TargetMeanEncoding);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupPreprocessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::frequencyEncoding, FrequencyEncodingPreprocessor._DESERIALIZER, "frequency_encoding");
        op.add(Builder::oneHotEncoding, OneHotEncodingPreprocessor._DESERIALIZER, "one_hot_encoding");
        op.add(Builder::targetMeanEncoding, TargetMeanEncodingPreprocessor._DESERIALIZER, "target_mean_encoding");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Preprocessor> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Preprocessor> frequencyEncoding(FrequencyEncodingPreprocessor v) {
            this._kind = Kind.FrequencyEncoding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Preprocessor> frequencyEncoding(Function<FrequencyEncodingPreprocessor.Builder, ObjectBuilder<FrequencyEncodingPreprocessor>> fn) {
            return this.frequencyEncoding(fn.apply(new FrequencyEncodingPreprocessor.Builder()).build());
        }

        public ObjectBuilder<Preprocessor> oneHotEncoding(OneHotEncodingPreprocessor v) {
            this._kind = Kind.OneHotEncoding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Preprocessor> oneHotEncoding(Function<OneHotEncodingPreprocessor.Builder, ObjectBuilder<OneHotEncodingPreprocessor>> fn) {
            return this.oneHotEncoding(fn.apply(new OneHotEncodingPreprocessor.Builder()).build());
        }

        public ObjectBuilder<Preprocessor> targetMeanEncoding(TargetMeanEncodingPreprocessor v) {
            this._kind = Kind.TargetMeanEncoding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Preprocessor> targetMeanEncoding(Function<TargetMeanEncodingPreprocessor.Builder, ObjectBuilder<TargetMeanEncodingPreprocessor>> fn) {
            return this.targetMeanEncoding(fn.apply(new TargetMeanEncodingPreprocessor.Builder()).build());
        }

        @Override
        public Preprocessor build() {
            this._checkSingleUse();
            return new Preprocessor(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        FrequencyEncoding("frequency_encoding"),
        OneHotEncoding("one_hot_encoding"),
        TargetMeanEncoding("target_mean_encoding");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

