/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class QueryBase
implements JsonpSerializable {
    @Nullable
    private final Float boost;
    @Nullable
    private final String queryName;

    protected QueryBase(AbstractBuilder<?> builder) {
        this.boost = ((AbstractBuilder)builder).boost;
        this.queryName = ((AbstractBuilder)builder).queryName;
    }

    @Nullable
    public final Float boost() {
        return this.boost;
    }

    @Nullable
    public final String queryName() {
        return this.queryName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write((double)this.boost.floatValue());
        }
        if (this.queryName != null) {
            generator.writeKey("_name");
            generator.write(this.queryName);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupQueryBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::boost, JsonpDeserializer.floatDeserializer(), "boost");
        op.add(AbstractBuilder::queryName, JsonpDeserializer.stringDeserializer(), "_name");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Float boost;
        @Nullable
        private String queryName;

        protected AbstractBuilder() {
        }

        public final BuilderT boost(@Nullable Float value) {
            this.boost = value;
            return (BuilderT)this.self();
        }

        public final BuilderT queryName(@Nullable String value) {
            this.queryName = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

