/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.dangling_indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.dangling_indices.DeleteDanglingIndexResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteDanglingIndexRequest
extends RequestBase {
    private final boolean acceptDataLoss;
    private final String indexUuid;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time timeout;
    public static final Endpoint<DeleteDanglingIndexRequest, DeleteDanglingIndexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteDanglingIndexRequest, DeleteDanglingIndexResponse>("es/dangling_indices.delete_dangling_index", request -> "DELETE", request -> {
        boolean _indexUuid = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_dangling");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexUuid, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        params.put("accept_data_loss", String.valueOf(request.acceptDataLoss));
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteDanglingIndexResponse._DESERIALIZER);

    private DeleteDanglingIndexRequest(Builder builder) {
        this.acceptDataLoss = ApiTypeHelper.requireNonNull(builder.acceptDataLoss, this, "acceptDataLoss");
        this.indexUuid = ApiTypeHelper.requireNonNull(builder.indexUuid, this, "indexUuid");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public static DeleteDanglingIndexRequest of(Function<Builder, ObjectBuilder<DeleteDanglingIndexRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean acceptDataLoss() {
        return this.acceptDataLoss;
    }

    public final String indexUuid() {
        return this.indexUuid;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteDanglingIndexRequest> {
        private Boolean acceptDataLoss;
        private String indexUuid;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time timeout;

        public final Builder acceptDataLoss(boolean value) {
            this.acceptDataLoss = value;
            return this;
        }

        public final Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteDanglingIndexRequest build() {
            this._checkSingleUse();
            return new DeleteDanglingIndexRequest(this);
        }
    }
}

