/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsAllOf;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsAnyOf;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsFilter;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsFilterVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsFuzzy;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsMatch;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsPrefix;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsWildcard;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Intervals
implements TaggedUnion<Kind, Object>,
IntervalsFilterVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Intervals> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Intervals::setupIntervalsDeserializer, Builder::build);

    @Override
    public IntervalsFilter.Kind _intervalsFilterKind() {
        return IntervalsFilter.Kind.Overlapping;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Intervals(IntervalsVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._intervalsKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Intervals(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Intervals of(Function<Builder, ObjectBuilder<Intervals>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAllOf() {
        return this._kind == Kind.AllOf;
    }

    public IntervalsAllOf allOf() {
        return (IntervalsAllOf)TaggedUnionUtils.get(this, Kind.AllOf);
    }

    public boolean isAnyOf() {
        return this._kind == Kind.AnyOf;
    }

    public IntervalsAnyOf anyOf() {
        return (IntervalsAnyOf)TaggedUnionUtils.get(this, Kind.AnyOf);
    }

    public boolean isFuzzy() {
        return this._kind == Kind.Fuzzy;
    }

    public IntervalsFuzzy fuzzy() {
        return (IntervalsFuzzy)TaggedUnionUtils.get(this, Kind.Fuzzy);
    }

    public boolean isMatch() {
        return this._kind == Kind.Match;
    }

    public IntervalsMatch match() {
        return (IntervalsMatch)TaggedUnionUtils.get(this, Kind.Match);
    }

    public boolean isPrefix() {
        return this._kind == Kind.Prefix;
    }

    public IntervalsPrefix prefix() {
        return (IntervalsPrefix)TaggedUnionUtils.get(this, Kind.Prefix);
    }

    public boolean isWildcard() {
        return this._kind == Kind.Wildcard;
    }

    public IntervalsWildcard wildcard() {
        return (IntervalsWildcard)TaggedUnionUtils.get(this, Kind.Wildcard);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIntervalsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allOf, IntervalsAllOf._DESERIALIZER, "all_of");
        op.add(Builder::anyOf, IntervalsAnyOf._DESERIALIZER, "any_of");
        op.add(Builder::fuzzy, IntervalsFuzzy._DESERIALIZER, "fuzzy");
        op.add(Builder::match, IntervalsMatch._DESERIALIZER, "match");
        op.add(Builder::prefix, IntervalsPrefix._DESERIALIZER, "prefix");
        op.add(Builder::wildcard, IntervalsWildcard._DESERIALIZER, "wildcard");
    }

    public static enum Kind implements JsonEnum
    {
        AllOf("all_of"),
        AnyOf("any_of"),
        Fuzzy("fuzzy"),
        Match("match"),
        Prefix("prefix"),
        Wildcard("wildcard");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Intervals> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Intervals> allOf(IntervalsAllOf v) {
            this._kind = Kind.AllOf;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Intervals> allOf(Function<IntervalsAllOf.Builder, ObjectBuilder<IntervalsAllOf>> fn) {
            return this.allOf(fn.apply(new IntervalsAllOf.Builder()).build());
        }

        public ObjectBuilder<Intervals> anyOf(IntervalsAnyOf v) {
            this._kind = Kind.AnyOf;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Intervals> anyOf(Function<IntervalsAnyOf.Builder, ObjectBuilder<IntervalsAnyOf>> fn) {
            return this.anyOf(fn.apply(new IntervalsAnyOf.Builder()).build());
        }

        public ObjectBuilder<Intervals> fuzzy(IntervalsFuzzy v) {
            this._kind = Kind.Fuzzy;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Intervals> fuzzy(Function<IntervalsFuzzy.Builder, ObjectBuilder<IntervalsFuzzy>> fn) {
            return this.fuzzy(fn.apply(new IntervalsFuzzy.Builder()).build());
        }

        public ObjectBuilder<Intervals> match(IntervalsMatch v) {
            this._kind = Kind.Match;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Intervals> match(Function<IntervalsMatch.Builder, ObjectBuilder<IntervalsMatch>> fn) {
            return this.match(fn.apply(new IntervalsMatch.Builder()).build());
        }

        public ObjectBuilder<Intervals> prefix(IntervalsPrefix v) {
            this._kind = Kind.Prefix;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Intervals> prefix(Function<IntervalsPrefix.Builder, ObjectBuilder<IntervalsPrefix>> fn) {
            return this.prefix(fn.apply(new IntervalsPrefix.Builder()).build());
        }

        public ObjectBuilder<Intervals> wildcard(IntervalsWildcard v) {
            this._kind = Kind.Wildcard;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Intervals> wildcard(Function<IntervalsWildcard.Builder, ObjectBuilder<IntervalsWildcard>> fn) {
            return this.wildcard(fn.apply(new IntervalsWildcard.Builder()).build());
        }

        @Override
        public Intervals build() {
            this._checkSingleUse();
            return new Intervals(this);
        }
    }
}

