/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HitsMetadata<T>
implements JsonpSerializable {
    @Nullable
    private final TotalHits total;
    private final List<Hit<T>> hits;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final JsonpSerializer<T> tSerializer;
    public static final JsonpDeserializer<HitsMetadata<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> HitsMetadata.createHitsMetadataDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.search._types.HitsMetadata.T")));

    private HitsMetadata(Builder<T> builder) {
        this.total = builder.total;
        this.hits = ApiTypeHelper.unmodifiableRequired(builder.hits, (Object)this, "hits");
        this.maxScore = builder.maxScore;
        this.tSerializer = builder.tSerializer;
    }

    public static <T> HitsMetadata<T> of(Function<Builder<T>, ObjectBuilder<HitsMetadata<T>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TotalHits total() {
        return this.total;
    }

    public final List<Hit<T>> hits() {
        return this.hits;
    }

    @Nullable
    public final Double maxScore() {
        return this.maxScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.hits)) {
            generator.writeKey("hits");
            generator.writeStartArray();
            for (Hit<T> item0 : this.hits) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <T> JsonpDeserializer<HitsMetadata<T>> createHitsMetadataDeserializer(JsonpDeserializer<T> tDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> HitsMetadata.setupHitsMetadataDeserializer(op, tDeserializer));
    }

    protected static <T> void setupHitsMetadataDeserializer(ObjectDeserializer<Builder<T>> op, JsonpDeserializer<T> tDeserializer) {
        op.add(Builder::total, TotalHits._DESERIALIZER, "total");
        op.add(Builder::hits, JsonpDeserializer.arrayDeserializer(Hit.createHitDeserializer(tDeserializer)), "hits");
        op.add(Builder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score");
    }

    public static class Builder<T>
    extends WithJsonObjectBuilderBase<Builder<T>>
    implements ObjectBuilder<HitsMetadata<T>> {
        @Nullable
        private TotalHits total;
        private List<Hit<T>> hits;
        @Nullable
        private Double maxScore;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public final Builder<T> total(@Nullable TotalHits value) {
            this.total = value;
            return this;
        }

        public final Builder<T> total(Function<TotalHits.Builder, ObjectBuilder<TotalHits>> fn) {
            return this.total(fn.apply(new TotalHits.Builder()).build());
        }

        public final Builder<T> hits(List<Hit<T>> list) {
            this.hits = Builder._listAddAll(this.hits, list);
            return this;
        }

        public final Builder<T> hits(Hit<T> value, Hit<T> ... values) {
            this.hits = Builder._listAdd(this.hits, value, values);
            return this;
        }

        public final Builder<T> hits(Function<Hit.Builder<T>, ObjectBuilder<Hit<T>>> fn) {
            return this.hits(fn.apply(new Hit.Builder()).build(), new Hit[0]);
        }

        public final Builder<T> maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this;
        }

        public final Builder<T> tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return this;
        }

        @Override
        protected Builder<T> self() {
            return this;
        }

        @Override
        public HitsMetadata<T> build() {
            this._checkSingleUse();
            return new HitsMetadata(this);
        }
    }
}

