/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetRepositoryResponse
implements JsonpSerializable {
    private final Map<String, Repository> repositories;
    public static final JsonpDeserializer<GetRepositoryResponse> _DESERIALIZER = GetRepositoryResponse.createGetRepositoryResponseDeserializer();

    private GetRepositoryResponse(Builder builder) {
        this.repositories = ApiTypeHelper.unmodifiableRequired(builder.repositories, (Object)this, "repositories");
    }

    public static GetRepositoryResponse of(Function<Builder, ObjectBuilder<GetRepositoryResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Repository> repositories() {
        return this.repositories;
    }

    @Nullable
    public final Repository get(String key) {
        return this.repositories.get(key);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        for (Map.Entry<String, Repository> item0 : this.repositories.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<GetRepositoryResponse> createGetRepositoryResponseDeserializer() {
        JsonpDeserializer<Map<String, Repository>> valueDeserializer = JsonpDeserializer.stringMapDeserializer(Repository._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().repositories((Map)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetRepositoryResponse> {
        private Map<String, Repository> repositories = new HashMap<String, Repository>();

        public final Builder repositories(Map<String, Repository> map) {
            this.repositories = Builder._mapPutAll(this.repositories, map);
            return this;
        }

        public final Builder repositories(String key, Repository value) {
            this.repositories = Builder._mapPut(this.repositories, key, value);
            return this;
        }

        public final Builder repositories(String key, Function<Repository.Builder, ObjectBuilder<Repository>> fn) {
            return this.repositories(key, fn.apply(new Repository.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            Map<String, Repository> value = JsonpDeserializer.stringMapDeserializer(Repository._DESERIALIZER).deserialize(parser, mapper);
            return this.repositories(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetRepositoryResponse build() {
            this._checkSingleUse();
            return new GetRepositoryResponse(this);
        }
    }
}

