/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level;

import java.nio.ByteBuffer;
import org.apache.hc.core5.http.ContentTooLongException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;
import org.apache.hc.core5.util.ByteArrayBuffer;

class BufferedByteConsumer
extends AbstractBinAsyncEntityConsumer<ByteArrayEntity> {
    private volatile ByteArrayBuffer buffer;
    private final int limit;
    private ContentType contentType;

    BufferedByteConsumer(int bufferLimit) {
        if (bufferLimit <= 0) {
            throw new IllegalArgumentException("Buffer limit must be greater than 0");
        }
        this.limit = bufferLimit;
        this.buffer = new ByteArrayBuffer(8192);
    }

    protected void streamStart(ContentType contentType) {
        this.contentType = contentType;
    }

    protected int capacityIncrement() {
        return this.limit;
    }

    protected void data(ByteBuffer src, boolean endOfStream) throws ContentTooLongException {
        if (this.buffer.length() + src.limit() > this.limit) {
            throw new ContentTooLongException("entity content is too long [" + src.limit() + "] for the configured buffer limit [" + this.limit + "]");
        }
        this.buffer.append(src);
    }

    protected ByteArrayEntity generateContent() {
        return new ByteArrayEntity(this.buffer.toByteArray(), this.contentType);
    }

    public void releaseResources() {
        this.buffer.clear();
    }
}

