/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSource;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSourceVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CompositeHistogramAggregation
extends CompositeAggregationBase
implements CompositeAggregationSourceVariant {
    private final double interval;
    public static final JsonpDeserializer<CompositeHistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeHistogramAggregation::setupCompositeHistogramAggregationDeserializer);

    private CompositeHistogramAggregation(Builder builder) {
        super(builder);
        this.interval = ApiTypeHelper.requireNonNull(builder.interval, (Object)this, "interval", 0.0);
    }

    public static CompositeHistogramAggregation of(Function<Builder, ObjectBuilder<CompositeHistogramAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public CompositeAggregationSource.Kind _compositeAggregationSourceKind() {
        return CompositeAggregationSource.Kind.Histogram;
    }

    public final double interval() {
        return this.interval;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("interval");
        generator.write(this.interval);
    }

    protected static void setupCompositeHistogramAggregationDeserializer(ObjectDeserializer<Builder> op) {
        CompositeAggregationBase.setupCompositeAggregationBaseDeserializer(op);
        op.add(Builder::interval, JsonpDeserializer.doubleDeserializer(), "interval");
    }

    public static class Builder
    extends CompositeAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompositeHistogramAggregation> {
        private Double interval;

        public final Builder interval(double value) {
            this.interval = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeHistogramAggregation build() {
            this._checkSingleUse();
            return new CompositeHistogramAggregation(this);
        }
    }
}

