/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog;

import co.enear.maven.plugins.keepachangelog.maven.MavenUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;

public class InitMojo
extends AbstractMojo {
    public static final String UNRELEASED_VERSION = "Unreleased";
    private static final String CHANGELOG_FILENAME = "CHANGELOG.md";
    private static final String SERVER_ID_KEY = "project.scm.id";
    @Parameter(property="connectionUrl")
    protected String connectionUrl;
    @Parameter(property="repositoryUrl")
    protected URL repositoryUrl;
    @Parameter(property="rangeUrl")
    protected String rangeUrl;
    @Parameter(property="username")
    protected String username;
    @Parameter(property="password")
    protected String password;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="v${version}", readonly=true)
    protected String tagFormat;
    @Parameter(defaultValue="false", readonly=true)
    protected boolean skip;
    @Parameter(defaultValue="false", readonly=true)
    protected boolean skipModules;
    @Parameter(defaultValue="false", readonly=true)
    protected boolean skipRoot;
    @Component(role=SettingsDecrypter.class)
    protected SettingsDecrypter settingsDecrypter;

    private String getServerId() {
        return this.project.getProperties().getProperty(SERVER_ID_KEY);
    }

    private void initCredentialsFromSettings() {
        String serverId = this.getServerId();
        if (serverId != null) {
            MavenUtils.decrypt(this.settings, this.settingsDecrypter, serverId).ifPresent(decryptedServer -> {
                this.username = decryptedServer.getUsername();
                this.password = decryptedServer.getPassword();
            });
        }
    }

    private void initConnectionURLFromPom() {
        this.connectionUrl = MavenUtils.getScmConnectionUrl(this.project).map(c -> c.replaceFirst("scm:[^:]+:", "")).orElse(null);
    }

    private void initRepositoryURLFromPom() {
        this.repositoryUrl = MavenUtils.getScmUrl(this.project).map(c -> {
            try {
                return new URL((String)c);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).orElse(null);
    }

    Path getChangelogPath() {
        Path basedir = this.project.getBasedir().toPath();
        return basedir.resolve(CHANGELOG_FILENAME);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.username == null && this.password == null) {
            this.initCredentialsFromSettings();
        }
        if (this.connectionUrl == null) {
            this.initConnectionURLFromPom();
        }
        if (this.repositoryUrl == null) {
            this.initRepositoryURLFromPom();
        }
    }
}

