/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog;

import co.enear.maven.plugins.keepachangelog.InitMojo;
import co.enear.maven.plugins.keepachangelog.git.GitServerFactory;
import co.enear.maven.plugins.keepachangelog.git.RepoServer;
import co.enear.maven.plugins.keepachangelog.markdown.generic.RefLink;
import co.enear.maven.plugins.keepachangelog.markdown.specific.ChangelogReader;
import co.enear.maven.plugins.keepachangelog.markdown.specific.DiffRefLink;
import co.enear.maven.plugins.keepachangelog.markdown.specific.ReaderException;
import co.enear.maven.plugins.keepachangelog.markdown.specific.VersionHeading;
import co.enear.maven.plugins.keepachangelog.utils.Range;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="release")
public class ReleaseMojo
extends InitMojo {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseMojo.class);
    private static final String CHANGELOG_TMP_PREFIX = "changelog";
    private static final String CHANGELOG_TMP_SUFFIX = ".tmp";
    private List<String> parsedVersions = new ArrayList<String>();

    private void writeNewVersion(String currVersion, boolean refLink, BufferedWriter bw) throws IOException {
        VersionHeading unrelVerHeading = VersionHeading.unreleased(true);
        VersionHeading currVerHeading = new VersionHeading(currVersion, LocalDate.now(), refLink);
        bw.write(unrelVerHeading.toMarkdown());
        bw.newLine();
        bw.newLine();
        bw.write(currVerHeading.toMarkdown());
        bw.newLine();
    }

    private void writeDiffLink(RepoServer repoServer, Range<String> tagRange, BufferedWriter bw) throws IOException {
        DiffRefLink diffRefLink = new DiffRefLink(this.tagFormat, repoServer, tagRange);
        bw.write(diffRefLink.toMarkdown());
        bw.newLine();
    }

    private void writeDiffLinks(RepoServer repoServer, BufferedWriter bw) throws IOException {
        if (repoServer != null) {
            List<Range<String>> tagRanges = this.getTagRanges();
            for (Range<String> tagRange : tagRanges) {
                this.writeDiffLink(repoServer, tagRange, bw);
            }
        }
    }

    private void writeNewChangelog(final String currVersion, RepoServer gitServer, Path path) throws MojoFailureException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            logger.warn("Changelog file not found. Skipping release.");
            return;
        }
        Path temp = this.createTempChangelog();
        try (final BufferedWriter bw = Files.newBufferedWriter(temp, new OpenOption[0]);){
            ChangelogReader reader = new ChangelogReader(){

                @Override
                protected void onVersionHeading(VersionHeading versionHeading) {
                    try {
                        if (versionHeading.isUnreleased()) {
                            boolean refLink = versionHeading.isRefLink();
                            ReleaseMojo.this.writeNewVersion(currVersion, refLink, bw);
                            ReleaseMojo.this.parsedVersions.add("Unreleased");
                            ReleaseMojo.this.parsedVersions.add(currVersion);
                        } else {
                            bw.write(versionHeading.toMarkdown());
                            bw.newLine();
                            String version = versionHeading.getVersion();
                            ReleaseMojo.this.parsedVersions.add(version);
                        }
                    }
                    catch (Exception e) {
                        throw new ReaderException("Failed to read version heading", e);
                    }
                }

                @Override
                protected void onRefLink(RefLink refLink) {
                    try {
                        if (!ReleaseMojo.this.parsedVersions.contains(refLink.getRef())) {
                            bw.write(refLink.toMarkdown());
                            bw.newLine();
                        }
                    }
                    catch (IOException e) {
                        throw new ReaderException("Failed to write ref link", e);
                    }
                }

                @Override
                protected void onOther(String line) {
                    try {
                        bw.write(line);
                        bw.newLine();
                    }
                    catch (Exception e) {
                        throw new ReaderException("Failed to read line", e);
                    }
                }
            };
            reader.read(path);
            this.writeDiffLinks(gitServer, bw);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to replace the original changelog.", (Throwable)e);
        }
        try {
            Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to replace the original changelog.", (Throwable)e);
        }
    }

    private Path createTempChangelog() throws MojoFailureException {
        try {
            return Files.createTempFile(CHANGELOG_TMP_PREFIX, CHANGELOG_TMP_SUFFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to create temporary file.", (Throwable)e);
        }
    }

    private RepoServer getRepoServer(String rangeUrl) {
        return GitServerFactory.from(rangeUrl);
    }

    private RepoServer getOriginRepo(URL url) {
        return GitServerFactory.from(url);
    }

    private List<Range<String>> getTagRanges() {
        ArrayList<String> begins = new ArrayList<String>(this.parsedVersions);
        if (!begins.isEmpty()) {
            ArrayList<String> ends = new ArrayList<String>(begins);
            begins.remove(0);
            ends.remove(ends.size() - 1);
            return Range.zip(begins, ends);
        }
        return Collections.emptyList();
    }

    private String getAppVersion() {
        return this.project.getModel().getVersion();
    }

    private void writeNewChangelog() throws MojoFailureException {
        Path path = this.getChangelogPath();
        String version = this.getAppVersion();
        RepoServer origin = this.rangeUrl != null && !this.rangeUrl.isEmpty() ? this.getRepoServer(this.rangeUrl) : this.getOriginRepo(this.repositoryUrl);
        this.writeNewChangelog(version, origin, path);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.skip) {
            return;
        }
        if (this.skipModules && !this.project.isExecutionRoot()) {
            return;
        }
        if (this.skipRoot && this.project.isExecutionRoot()) {
            return;
        }
        this.writeNewChangelog();
    }
}

