/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog;

import co.enear.maven.plugins.keepachangelog.InitMojo;
import co.enear.maven.plugins.keepachangelog.git.TagUtils;
import co.enear.maven.plugins.keepachangelog.markdown.specific.ChangelogValidator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="validate")
public class ValidateMojo
extends InitMojo {
    private static final Logger logger = LoggerFactory.getLogger(ValidateMojo.class);

    private void warnTagsExceptVersions(ChangelogValidator validator) {
        Set<String> tagsWithoutVersions = validator.getTagsExceptVersions();
        if (!tagsWithoutVersions.isEmpty()) {
            logger.warn("Some tags in the repository do not have a matching version in the changelog");
        }
        for (String version : tagsWithoutVersions) {
            this.getLog().warn((CharSequence)("Missing version: " + version));
        }
    }

    private void warnVersionsExceptTags(ChangelogValidator validator) {
        Set<String> versionsWithoutTags = validator.getVersionsExceptTags();
        if (!versionsWithoutTags.isEmpty()) {
            logger.warn("Some versions in the changelog to not have a matching tag in the repository");
        }
        for (String version : versionsWithoutTags) {
            String tag = TagUtils.toTag(this.tagFormat, version);
            this.getLog().warn((CharSequence)("Missing tag: " + tag));
        }
    }

    private void validate(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            logger.warn("Changelog file not found. Skipping validation.");
            return;
        }
        ChangelogValidator validator = new ChangelogValidator(this.connectionUrl, this.username, this.password, this.tagFormat);
        validator.read(path);
        this.warnTagsExceptVersions(validator);
        this.warnVersionsExceptTags(validator);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.skip) {
            return;
        }
        if (this.skipModules && !this.project.isExecutionRoot()) {
            return;
        }
        if (this.skipRoot && this.project.isExecutionRoot()) {
            return;
        }
        Path path = this.getChangelogPath();
        this.validate(path);
    }
}

