/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.git;

import co.enear.maven.plugins.keepachangelog.git.BaseGitServer;
import co.enear.maven.plugins.keepachangelog.git.GitServerException;
import co.enear.maven.plugins.keepachangelog.git.RepoServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BitBucketServer
extends BaseGitServer
implements RepoServer {
    private static final String PROJECT_ID = "project";
    private static final String REPO_ID = "repository";
    private static final String PATH_REGEX = String.format("/scm/(?<%s>[^/]+)/(?<%s>[^/]+)(?:/.*)?", "project", "repository");
    public static final Pattern pathPattern = Pattern.compile(PATH_REGEX);
    private URL originUrl;
    private URL diffUrl;
    private String project;
    private String repository;

    public BitBucketServer(URL originUrl) {
        this.originUrl = originUrl;
        String path = this.originUrl.getPath();
        Matcher matcher = pathPattern.matcher(path);
        if (!matcher.matches()) {
            throw new GitServerException("Unknown path format.");
        }
        this.project = matcher.group(PROJECT_ID);
        this.repository = matcher.group(REPO_ID);
    }

    private String getProtocol() {
        return this.originUrl.getProtocol();
    }

    private String getHost() {
        return this.originUrl.getHost();
    }

    private String getProject() {
        return this.project;
    }

    private String getRepository() {
        return this.repository;
    }

    private void initDiffUrl() throws MalformedURLException {
        if (this.diffUrl == null) {
            String protocol = this.getProtocol();
            String host = this.getHost();
            String project = this.getProject();
            String repo = this.getRepository();
            String spec = String.format("%s://%s/projects/%s/repos/%s/branches/compare", protocol, host, project, repo);
            this.diffUrl = new URL(spec);
        }
    }

    @Override
    public URL diff(String a, String b) {
        try {
            this.initDiffUrl();
            String spec = String.format("%s/%s%%0D%s", this.diffUrl, a, b);
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new GitServerException("Failed to create a diff link.", e);
        }
    }
}

