/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.git;

import co.enear.maven.plugins.keepachangelog.git.BaseGitServer;
import co.enear.maven.plugins.keepachangelog.git.GitServerException;
import co.enear.maven.plugins.keepachangelog.git.RepoServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitHubServer
extends BaseGitServer
implements RepoServer {
    private static final String USER_ID = "username";
    private static final String REPO_ID = "repository";
    private static final String PATH_REGEX = String.format("/(?<%s>[^/]+)/(?<%s>[^/]+)(?:/.*)?", "username", "repository");
    public static final Pattern pathPattern = Pattern.compile(PATH_REGEX);
    private URL originUrl;
    private URL diffUrl;
    private String username;
    private String repository;

    public GitHubServer(URL originUrl) {
        this.originUrl = originUrl;
        String path = this.originUrl.getPath();
        Matcher matcher = pathPattern.matcher(path);
        if (!matcher.matches()) {
            throw new GitServerException("Unknown path format.");
        }
        this.username = matcher.group(USER_ID);
        this.repository = matcher.group(REPO_ID);
    }

    private String getProtocol() {
        return this.originUrl.getProtocol();
    }

    private String getHost() {
        return this.originUrl.getHost();
    }

    private String getUsername() {
        return this.username;
    }

    private String getRepository() {
        return this.repository;
    }

    private void initDiffUrl() throws MalformedURLException {
        if (this.diffUrl == null) {
            String protocol = this.getProtocol();
            String host = this.getHost();
            String username = this.getUsername();
            String repo = this.getRepository();
            String spec = String.format("%s://%s/%s/%s/compare", protocol, host, username, repo);
            this.diffUrl = new URL(spec);
        }
    }

    @Override
    public URL diff(String a, String b) {
        try {
            this.initDiffUrl();
            String spec = String.format("%s/%s...%s", this.diffUrl, a, b);
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new GitServerException("Failed to create a diff link.", e);
        }
    }
}

