/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.git;

import co.enear.maven.plugins.keepachangelog.git.BitBucketServer;
import co.enear.maven.plugins.keepachangelog.git.CustomGitServer;
import co.enear.maven.plugins.keepachangelog.git.GitHubServer;
import co.enear.maven.plugins.keepachangelog.git.RepoServer;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitServerFactory {
    public static final Logger logger = LoggerFactory.getLogger(GitServerFactory.class);
    private static final String BITBUCKET_HOST_PREFIX = "bitbucket";
    private static final String GITHUB_HOST_PREFIX = "github";

    public static RepoServer from(String rangeUrl) {
        if (rangeUrl == null) {
            return null;
        }
        logger.info("Using range URL {}", (Object)rangeUrl);
        return new CustomGitServer(rangeUrl);
    }

    public static RepoServer from(URL originUrl) {
        if (originUrl == null) {
            return null;
        }
        String host = originUrl.getHost();
        if (host.startsWith(BITBUCKET_HOST_PREFIX)) {
            return new BitBucketServer(originUrl);
        }
        if (host.startsWith(GITHUB_HOST_PREFIX)) {
            return new GitHubServer(originUrl);
        }
        return null;
    }
}

