/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.git;

import co.enear.maven.plugins.keepachangelog.utils.Range;
import co.enear.maven.plugins.keepachangelog.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class TagUtils {
    private static final String VERSION_ID = "version";
    public static final String DEFAULT_TAG_FORMAT = "v${version}";
    private static final String HEAD = "HEAD";
    private static final String REFS_TAGS = "refs/tags/";

    private static String getTagName(Ref tagRef) {
        return tagRef.getName().replaceFirst(REFS_TAGS, "");
    }

    public static List<String> getTags(String url, String username, String password) throws GitAPIException {
        if (url == null) {
            return Collections.emptyList();
        }
        LsRemoteCommand cmd = Git.lsRemoteRepository();
        cmd.setRemote(url);
        if (username != null && password != null) {
            cmd.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password));
        }
        Collection refs = cmd.call();
        return refs.stream().filter(ref -> ref.getName().startsWith(REFS_TAGS)).map(TagUtils::getTagName).collect(Collectors.toList());
    }

    public static String toTag(String tagFormat, String version) {
        if (version.equals("Unreleased")) {
            return HEAD;
        }
        return StringUtils.replace(tagFormat, VERSION_ID, version);
    }

    public static Range<String> toTagRange(String tagFormat, Range<String> versionRange) {
        String b = TagUtils.toTag(tagFormat, versionRange.getBegin());
        String e = TagUtils.toTag(tagFormat, versionRange.getEnd());
        return new Range<String>(b, e);
    }

    public static Optional<String> toVersion(String tagFormat, String tag) {
        return StringUtils.extract(tag, VERSION_ID, tagFormat);
    }
}

