/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.markdown.generic;

import co.enear.maven.plugins.keepachangelog.markdown.Markdown;
import co.enear.maven.plugins.keepachangelog.utils.StringUtils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Heading
implements Markdown {
    private static final String MARKERS_ID = "markers";
    private static final String TEXT_ID = "text";
    private static final char OPENING_MARKER = '#';
    private static final String REGEX = String.format("^(?<%s>%s+) (?<%s>.*+)$", "markers", Character.valueOf('#'), "text");
    private static final Pattern pattern = Pattern.compile(REGEX);
    private int level;
    private String text;

    public Heading(int level, String text) {
        this.level = level;
        this.text = text;
    }

    private String getOpeningMarker() {
        return StringUtils.repeat('#', this.level);
    }

    public static Optional<Heading> fromMarkdown(String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            String markers = matcher.group(MARKERS_ID);
            int level = markers.length();
            String text = matcher.group(TEXT_ID);
            return Optional.of(new Heading(level, text));
        }
        return Optional.empty();
    }

    public int getLevel() {
        return this.level;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "Heading(" + this.level + ", " + this.text + ")";
    }

    @Override
    public String toMarkdown() {
        return this.getOpeningMarker() + " " + this.text;
    }
}

