/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.markdown.generic;

import co.enear.maven.plugins.keepachangelog.markdown.Markdown;
import co.enear.maven.plugins.keepachangelog.markdown.ParseException;
import java.net.URL;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RefLink
implements Markdown {
    private static final String REF_ID = "ref";
    private static final String LINK_ID = "link";
    private static final String REGEX = String.format("^\\[(?<%s>.+)\\]: (?<%s>.+)$", "ref", "link");
    private static final Pattern pattern = Pattern.compile(REGEX);
    private String ref;
    private URL link;

    public RefLink(String ref, URL link) {
        this.ref = ref;
        this.link = link;
    }

    public String getRef() {
        return this.ref;
    }

    public URL getLink() {
        return this.link;
    }

    public static Optional<RefLink> fromMarkdown(String line) {
        try {
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                String ref = matcher.group(REF_ID);
                URL link = new URL(matcher.group(LINK_ID));
                return Optional.of(new RefLink(ref, link));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new ParseException("Failed to fromMarkdown reference link.", e);
        }
    }

    public String toString() {
        return "RefLink(" + this.ref + ", " + this.link + ")";
    }

    @Override
    public String toMarkdown() {
        return String.format("[%s]: %s", this.ref, this.link);
    }
}

