/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.markdown.specific;

import co.enear.maven.plugins.keepachangelog.markdown.Markdown;
import co.enear.maven.plugins.keepachangelog.markdown.generic.RefLink;
import co.enear.maven.plugins.keepachangelog.markdown.specific.ReaderException;
import co.enear.maven.plugins.keepachangelog.markdown.specific.VersionHeading;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class ChangelogReader {
    protected abstract void onVersionHeading(VersionHeading var1);

    protected abstract void onRefLink(RefLink var1);

    protected abstract void onOther(String var1);

    private void readLine(String line) {
        boolean parsedLine = false;
        Optional<Markdown> opt = VersionHeading.parse(line);
        if (opt.isPresent()) {
            VersionHeading versionHeading = opt.get();
            this.onVersionHeading(versionHeading);
            parsedLine = true;
        }
        if (!parsedLine && (opt = RefLink.fromMarkdown(line)).isPresent()) {
            RefLink refLink = (RefLink)opt.get();
            this.onRefLink(refLink);
            parsedLine = true;
        }
        if (!parsedLine) {
            this.onOther(line);
        }
    }

    public void read(Path path) {
        try {
            try (Stream<String> stream = Files.lines(path);){
                stream.forEach(this::readLine);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new ReaderException("Failed to read file.", e);
        }
    }
}

