/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.markdown.specific;

import co.enear.maven.plugins.keepachangelog.git.TagUtils;
import co.enear.maven.plugins.keepachangelog.markdown.generic.RefLink;
import co.enear.maven.plugins.keepachangelog.markdown.specific.ChangelogReader;
import co.enear.maven.plugins.keepachangelog.markdown.specific.ReaderException;
import co.enear.maven.plugins.keepachangelog.markdown.specific.VersionHeading;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.errors.GitAPIException;

public class ChangelogValidator
extends ChangelogReader {
    private Set<String> parsedVersions = new HashSet<String>();
    private Set<String> versionsExceptTags = Collections.emptySet();
    private Set<String> tagsExceptVersions = Collections.emptySet();
    private String url;
    private String username;
    private String password;
    private String tagFormat;

    public ChangelogValidator(String url, String username, String password, String tagFormat) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.tagFormat = tagFormat;
    }

    @Override
    protected void onVersionHeading(VersionHeading versionHeading) {
        String version = versionHeading.getVersion();
        this.parsedVersions.add(version);
    }

    @Override
    protected void onRefLink(RefLink refLink) {
    }

    @Override
    protected void onOther(String line) {
    }

    @Override
    public void read(Path path) {
        super.read(path);
        try {
            Set<String> gitVersions = this.getTagsAsVersions();
            this.initVersionsExceptTags(gitVersions);
            this.initTagsExceptVersions(gitVersions);
        }
        catch (GitAPIException e) {
            throw new ReaderException("Failed to get tags as versions.", e);
        }
    }

    private Set<String> getTagsAsVersions() throws GitAPIException {
        List<String> tags = TagUtils.getTags(this.url, this.username, this.password);
        tags.remove("Unreleased");
        return tags.stream().map(tag -> TagUtils.toVersion(this.tagFormat, tag)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private void initTagsExceptVersions(Set<String> gitVersions) {
        this.tagsExceptVersions = new HashSet<String>(gitVersions);
        this.tagsExceptVersions.removeAll(this.parsedVersions);
    }

    private void initVersionsExceptTags(Set<String> gitVersions) {
        this.versionsExceptTags = new HashSet<String>(this.parsedVersions);
        this.versionsExceptTags.remove("Unreleased");
        this.versionsExceptTags.removeAll(gitVersions);
    }

    public Set<String> getVersionsExceptTags() {
        return this.versionsExceptTags;
    }

    public Set<String> getTagsExceptVersions() {
        return this.tagsExceptVersions;
    }
}

