/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.markdown.specific;

import co.enear.maven.plugins.keepachangelog.git.RepoServer;
import co.enear.maven.plugins.keepachangelog.git.TagUtils;
import co.enear.maven.plugins.keepachangelog.markdown.Markdown;
import co.enear.maven.plugins.keepachangelog.markdown.generic.RefLink;
import co.enear.maven.plugins.keepachangelog.utils.Range;
import java.net.URL;

public class DiffRefLink
implements Markdown {
    private String tagFormat;
    private RepoServer repoServer;
    private Range<String> versionRange;

    public DiffRefLink(String tagFormat, RepoServer repoServer, Range<String> versionRange) {
        this.tagFormat = tagFormat;
        this.repoServer = repoServer;
        this.versionRange = versionRange;
    }

    public String toString() {
        return "DiffRefLink(" + this.versionRange + ")";
    }

    @Override
    public String toMarkdown() {
        String end = this.versionRange.getEnd();
        Range<String> tagRange = TagUtils.toTagRange(this.tagFormat, this.versionRange);
        URL diff = this.repoServer.diff(tagRange);
        RefLink refLink = new RefLink(end, diff);
        return refLink.toMarkdown();
    }
}

