/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.markdown.specific;

import co.enear.maven.plugins.keepachangelog.markdown.Markdown;
import co.enear.maven.plugins.keepachangelog.markdown.generic.Heading;
import java.time.LocalDate;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionHeading
implements Markdown {
    private static final String VERSION_ID = "version";
    private static final String DATE_ID = "date";
    private static final int HEADING_LEVEL = 2;
    private static final String VERSION_REGEX = "(?<version>[\\w\\.-]+)";
    private static final String VERSION_LINK_REGEX = "\\[(?<version>[\\w\\.-]+)\\]";
    private static final String DATE_REGEX = "(?: - (?<date>.+))?";
    private static final String TEXT_REGEX = "^(?<version>[\\w\\.-]+)(?: - (?<date>.+))?$";
    private static final String TEXT_LINK_REGEX = "^\\[(?<version>[\\w\\.-]+)\\](?: - (?<date>.+))?$";
    private static final Pattern textPattern = Pattern.compile("^(?<version>[\\w\\.-]+)(?: - (?<date>.+))?$");
    private static final Pattern textLinkPattern = Pattern.compile("^\\[(?<version>[\\w\\.-]+)\\](?: - (?<date>.+))?$");
    private String version;
    private LocalDate date;
    private boolean refLink;

    public VersionHeading(String version, LocalDate date, boolean refLink) {
        this.version = version;
        this.date = date;
        this.refLink = refLink;
    }

    public VersionHeading(String version, boolean refLink) {
        this(version, null, refLink);
    }

    public static VersionHeading unreleased(boolean refLink) {
        return new VersionHeading("Unreleased", refLink);
    }

    private static Optional<VersionHeading> parse(String text, Pattern pattern, boolean refLink) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            String version = matcher.group(VERSION_ID);
            LocalDate date = VersionHeading.parseDate(matcher.group(DATE_ID));
            return Optional.of(new VersionHeading(version, date, refLink));
        }
        return Optional.empty();
    }

    private static Optional<VersionHeading> parseNoLink(String text) {
        return VersionHeading.parse(text, textPattern, false);
    }

    private static Optional<VersionHeading> parseLink(String text) {
        return VersionHeading.parse(text, textLinkPattern, true);
    }

    public static Optional<VersionHeading> parse(Heading heading) {
        if (heading.getLevel() != 2) {
            return Optional.empty();
        }
        String text = heading.getText();
        Optional<VersionHeading> opt = VersionHeading.parseLink(text);
        if (!opt.isPresent()) {
            opt = VersionHeading.parseNoLink(text);
        }
        return opt;
    }

    public static Optional<VersionHeading> parse(String line) {
        return Heading.fromMarkdown(line).flatMap(heading -> VersionHeading.parse(heading));
    }

    private static LocalDate parseDate(String date) {
        if (date != null) {
            return LocalDate.parse(date);
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public boolean isRefLink() {
        return this.refLink;
    }

    public boolean isUnreleased() {
        return this.version.equals("Unreleased");
    }

    public String toString() {
        return "VersionHeading(" + this.version + ", " + this.date + ", " + this.refLink + ")";
    }

    @Override
    public String toMarkdown() {
        StringBuilder sb = new StringBuilder();
        sb.append("## ");
        if (this.refLink) {
            sb.append("[");
        }
        sb.append(this.version);
        if (this.refLink) {
            sb.append("]");
        }
        if (this.date != null) {
            sb.append(" - ").append(this.date);
        }
        return sb.toString();
    }
}

