/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.maven;

import java.util.Optional;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

public class MavenUtils {
    private static Optional<String> getScmConnectionUrl(Model model) {
        return MavenUtils.getScm(model).map(Scm::getConnection);
    }

    private static Optional<String> getScmUrl(Model model) {
        return MavenUtils.getScm(model).map(Scm::getUrl);
    }

    private static Optional<Scm> getScm(Model model) {
        return Optional.ofNullable(model.getScm());
    }

    public static Optional<String> getScmConnectionUrl(MavenProject project) {
        Model model = project.getModel();
        return MavenUtils.getScmConnectionUrl(model);
    }

    public static Optional<String> getScmUrl(MavenProject project) {
        Model model = project.getModel();
        return MavenUtils.getScmUrl(model);
    }

    public static Optional<Server> decrypt(Settings settings, SettingsDecrypter settingsDecrypter, String serverId) {
        Server server = settings.getServer(serverId);
        if (server != null) {
            DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
            SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
            return Optional.of(result.getServer());
        }
        return Optional.empty();
    }
}

