/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Range<N> {
    private N begin;
    private N end;

    public Range(N begin, N end) {
        this.begin = begin;
        this.end = end;
    }

    public N getBegin() {
        return this.begin;
    }

    public N getEnd() {
        return this.end;
    }

    public String toString() {
        return String.format("Range(%s,%s)", this.begin, this.end);
    }

    public static <N> List<Range<N>> zip(List<N> xs, List<N> ys) {
        ArrayList<Range<N>> list = new ArrayList<Range<N>>(xs.size());
        Iterator<N> itXs = ys.iterator();
        for (N x : xs) {
            if (!itXs.hasNext()) break;
            N y = itXs.next();
            Range<N> range = new Range<N>(x, y);
            list.add(range);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.begin, range.begin) && Objects.equals(this.end, range.end);
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end);
    }
}

