/*
 * Decompiled with CFR 0.152.
 */
package co.enear.maven.plugins.keepachangelog.utils;

import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String VAR_REGEX = "\\$\\{%s\\}";

    public static String repeat(char c, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The number of repetition cannot be negative");
        }
        char[] cs = new char[n];
        Arrays.fill(cs, c);
        return new String(cs);
    }

    public static String replace(String str, String id, String value) {
        String regex = String.format(VAR_REGEX, id);
        return str.replaceAll(regex, value);
    }

    public static Optional<String> extract(String str, String id, String format) {
        String regex = StringUtils.replace(format, id, "(?<" + id + ">.*)");
        Pattern pattern = Pattern.compile("^" + regex + "$");
        Matcher matcher = pattern.matcher(str);
        if (matcher.matches()) {
            return Optional.of(matcher.group(id));
        }
        return Optional.empty();
    }
}

