package com.flexa.core.data.db;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressWarnings({"unchecked", "deprecation"})
public final class Database_Impl extends Database {
  private volatile AssetDao _assetDao;

  private volatile BrandDao _brandDao;

  private volatile BrandSessionDao _brandSessionDao;

  private volatile ExchangeRateDao _exchangeRateDao;

  private volatile OneTimeKeyDao _oneTimeKeyDao;

  private volatile TransactionFeeDao _transactionFeeDao;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(11) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `asset` (`id` TEXT NOT NULL, `icon_url` TEXT, `symbol` TEXT, `color` TEXT, `display_name` TEXT, PRIMARY KEY(`id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `brand` (`id` TEXT NOT NULL, `category_name` TEXT, `color` TEXT, `legacy_flexcodes` TEXT, `promotions` TEXT, `logo_url` TEXT, `name` TEXT, `slug` TEXT, `status` TEXT, PRIMARY KEY(`id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `brand_session` (`session_id` TEXT NOT NULL, `transaction_id` TEXT NOT NULL, `date` INTEGER NOT NULL, `legacy` INTEGER NOT NULL, PRIMARY KEY(`session_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `exchange_rate` (`asset` TEXT NOT NULL, `expires_at` INTEGER, `label` TEXT, `precision` INTEGER, `price` TEXT, `unit_of_account` TEXT, PRIMARY KEY(`asset`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `one_time_key` (`id` TEXT NOT NULL, `asset` TEXT, `expires_at` INTEGER, `length` INTEGER, `livemode` INTEGER, `prefix` TEXT, `secret` TEXT, PRIMARY KEY(`id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `transaction_fee` (`amount` TEXT, `asset` TEXT NOT NULL, `expires_at` INTEGER, `label` TEXT, `price` TEXT, `transaction_asset` TEXT NOT NULL, `zone` TEXT, PRIMARY KEY(`transaction_asset`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '9e57f3e7d72e862338620ef77090ccd9')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `asset`");
        db.execSQL("DROP TABLE IF EXISTS `brand`");
        db.execSQL("DROP TABLE IF EXISTS `brand_session`");
        db.execSQL("DROP TABLE IF EXISTS `exchange_rate`");
        db.execSQL("DROP TABLE IF EXISTS `one_time_key`");
        db.execSQL("DROP TABLE IF EXISTS `transaction_fee`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsAsset = new HashMap<String, TableInfo.Column>(5);
        _columnsAsset.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAsset.put("icon_url", new TableInfo.Column("icon_url", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAsset.put("symbol", new TableInfo.Column("symbol", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAsset.put("color", new TableInfo.Column("color", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAsset.put("display_name", new TableInfo.Column("display_name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAsset = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAsset = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAsset = new TableInfo("asset", _columnsAsset, _foreignKeysAsset, _indicesAsset);
        final TableInfo _existingAsset = TableInfo.read(db, "asset");
        if (!_infoAsset.equals(_existingAsset)) {
          return new RoomOpenHelper.ValidationResult(false, "asset(com.flexa.core.data.db.Asset).\n"
                  + " Expected:\n" + _infoAsset + "\n"
                  + " Found:\n" + _existingAsset);
        }
        final HashMap<String, TableInfo.Column> _columnsBrand = new HashMap<String, TableInfo.Column>(9);
        _columnsBrand.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrand.put("category_name", new TableInfo.Column("category_name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrand.put("color", new TableInfo.Column("color", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrand.put("legacy_flexcodes", new TableInfo.Column("legacy_flexcodes", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrand.put("promotions", new TableInfo.Column("promotions", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrand.put("logo_url", new TableInfo.Column("logo_url", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrand.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrand.put("slug", new TableInfo.Column("slug", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrand.put("status", new TableInfo.Column("status", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysBrand = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesBrand = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoBrand = new TableInfo("brand", _columnsBrand, _foreignKeysBrand, _indicesBrand);
        final TableInfo _existingBrand = TableInfo.read(db, "brand");
        if (!_infoBrand.equals(_existingBrand)) {
          return new RoomOpenHelper.ValidationResult(false, "brand(com.flexa.core.data.db.Brand).\n"
                  + " Expected:\n" + _infoBrand + "\n"
                  + " Found:\n" + _existingBrand);
        }
        final HashMap<String, TableInfo.Column> _columnsBrandSession = new HashMap<String, TableInfo.Column>(4);
        _columnsBrandSession.put("session_id", new TableInfo.Column("session_id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrandSession.put("transaction_id", new TableInfo.Column("transaction_id", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrandSession.put("date", new TableInfo.Column("date", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsBrandSession.put("legacy", new TableInfo.Column("legacy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysBrandSession = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesBrandSession = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoBrandSession = new TableInfo("brand_session", _columnsBrandSession, _foreignKeysBrandSession, _indicesBrandSession);
        final TableInfo _existingBrandSession = TableInfo.read(db, "brand_session");
        if (!_infoBrandSession.equals(_existingBrandSession)) {
          return new RoomOpenHelper.ValidationResult(false, "brand_session(com.flexa.core.data.db.BrandSession).\n"
                  + " Expected:\n" + _infoBrandSession + "\n"
                  + " Found:\n" + _existingBrandSession);
        }
        final HashMap<String, TableInfo.Column> _columnsExchangeRate = new HashMap<String, TableInfo.Column>(6);
        _columnsExchangeRate.put("asset", new TableInfo.Column("asset", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsExchangeRate.put("expires_at", new TableInfo.Column("expires_at", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsExchangeRate.put("label", new TableInfo.Column("label", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsExchangeRate.put("precision", new TableInfo.Column("precision", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsExchangeRate.put("price", new TableInfo.Column("price", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsExchangeRate.put("unit_of_account", new TableInfo.Column("unit_of_account", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysExchangeRate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesExchangeRate = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoExchangeRate = new TableInfo("exchange_rate", _columnsExchangeRate, _foreignKeysExchangeRate, _indicesExchangeRate);
        final TableInfo _existingExchangeRate = TableInfo.read(db, "exchange_rate");
        if (!_infoExchangeRate.equals(_existingExchangeRate)) {
          return new RoomOpenHelper.ValidationResult(false, "exchange_rate(com.flexa.core.data.db.ExchangeRate).\n"
                  + " Expected:\n" + _infoExchangeRate + "\n"
                  + " Found:\n" + _existingExchangeRate);
        }
        final HashMap<String, TableInfo.Column> _columnsOneTimeKey = new HashMap<String, TableInfo.Column>(7);
        _columnsOneTimeKey.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOneTimeKey.put("asset", new TableInfo.Column("asset", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOneTimeKey.put("expires_at", new TableInfo.Column("expires_at", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOneTimeKey.put("length", new TableInfo.Column("length", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOneTimeKey.put("livemode", new TableInfo.Column("livemode", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOneTimeKey.put("prefix", new TableInfo.Column("prefix", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOneTimeKey.put("secret", new TableInfo.Column("secret", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysOneTimeKey = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesOneTimeKey = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoOneTimeKey = new TableInfo("one_time_key", _columnsOneTimeKey, _foreignKeysOneTimeKey, _indicesOneTimeKey);
        final TableInfo _existingOneTimeKey = TableInfo.read(db, "one_time_key");
        if (!_infoOneTimeKey.equals(_existingOneTimeKey)) {
          return new RoomOpenHelper.ValidationResult(false, "one_time_key(com.flexa.core.data.db.OneTimeKey).\n"
                  + " Expected:\n" + _infoOneTimeKey + "\n"
                  + " Found:\n" + _existingOneTimeKey);
        }
        final HashMap<String, TableInfo.Column> _columnsTransactionFee = new HashMap<String, TableInfo.Column>(7);
        _columnsTransactionFee.put("amount", new TableInfo.Column("amount", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTransactionFee.put("asset", new TableInfo.Column("asset", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTransactionFee.put("expires_at", new TableInfo.Column("expires_at", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTransactionFee.put("label", new TableInfo.Column("label", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTransactionFee.put("price", new TableInfo.Column("price", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTransactionFee.put("transaction_asset", new TableInfo.Column("transaction_asset", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTransactionFee.put("zone", new TableInfo.Column("zone", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysTransactionFee = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesTransactionFee = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoTransactionFee = new TableInfo("transaction_fee", _columnsTransactionFee, _foreignKeysTransactionFee, _indicesTransactionFee);
        final TableInfo _existingTransactionFee = TableInfo.read(db, "transaction_fee");
        if (!_infoTransactionFee.equals(_existingTransactionFee)) {
          return new RoomOpenHelper.ValidationResult(false, "transaction_fee(com.flexa.core.data.db.TransactionFee).\n"
                  + " Expected:\n" + _infoTransactionFee + "\n"
                  + " Found:\n" + _existingTransactionFee);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "9e57f3e7d72e862338620ef77090ccd9", "115974c61a8c3bb74b33bed61ee8d1ba");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "asset","brand","brand_session","exchange_rate","one_time_key","transaction_fee");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `asset`");
      _db.execSQL("DELETE FROM `brand`");
      _db.execSQL("DELETE FROM `brand_session`");
      _db.execSQL("DELETE FROM `exchange_rate`");
      _db.execSQL("DELETE FROM `one_time_key`");
      _db.execSQL("DELETE FROM `transaction_fee`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(AssetDao.class, AssetDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(BrandDao.class, BrandDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(BrandSessionDao.class, BrandSessionDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ExchangeRateDao.class, ExchangeRateDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(OneTimeKeyDao.class, OneTimeKeyDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(TransactionFeeDao.class, TransactionFeeDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public AssetDao assetsDao() {
    if (_assetDao != null) {
      return _assetDao;
    } else {
      synchronized(this) {
        if(_assetDao == null) {
          _assetDao = new AssetDao_Impl(this);
        }
        return _assetDao;
      }
    }
  }

  @Override
  public BrandDao brandsDao() {
    if (_brandDao != null) {
      return _brandDao;
    } else {
      synchronized(this) {
        if(_brandDao == null) {
          _brandDao = new BrandDao_Impl(this);
        }
        return _brandDao;
      }
    }
  }

  @Override
  public BrandSessionDao brandSessionDao() {
    if (_brandSessionDao != null) {
      return _brandSessionDao;
    } else {
      synchronized(this) {
        if(_brandSessionDao == null) {
          _brandSessionDao = new BrandSessionDao_Impl(this);
        }
        return _brandSessionDao;
      }
    }
  }

  @Override
  public ExchangeRateDao exchangeRateDao() {
    if (_exchangeRateDao != null) {
      return _exchangeRateDao;
    } else {
      synchronized(this) {
        if(_exchangeRateDao == null) {
          _exchangeRateDao = new ExchangeRateDao_Impl(this);
        }
        return _exchangeRateDao;
      }
    }
  }

  @Override
  public OneTimeKeyDao oneTimeKeyDao() {
    if (_oneTimeKeyDao != null) {
      return _oneTimeKeyDao;
    } else {
      synchronized(this) {
        if(_oneTimeKeyDao == null) {
          _oneTimeKeyDao = new OneTimeKeyDao_Impl(this);
        }
        return _oneTimeKeyDao;
      }
    }
  }

  @Override
  public TransactionFeeDao transactionFeeDao() {
    if (_transactionFeeDao != null) {
      return _transactionFeeDao;
    } else {
      synchronized(this) {
        if(_transactionFeeDao == null) {
          _transactionFeeDao = new TransactionFeeDao_Impl(this);
        }
        return _transactionFeeDao;
      }
    }
  }
}
