package com.flexa.core.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SuppressWarnings({"unchecked", "deprecation"})
public final class OneTimeKeyDao_Impl implements OneTimeKeyDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<OneTimeKey> __insertionAdapterOfOneTimeKey;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public OneTimeKeyDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfOneTimeKey = new EntityInsertionAdapter<OneTimeKey>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `one_time_key` (`id`,`asset`,`expires_at`,`length`,`livemode`,`prefix`,`secret`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final OneTimeKey entity) {
        if (entity.getId() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getId());
        }
        if (entity.getAsset() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getAsset());
        }
        if (entity.getExpiresAt() == null) {
          statement.bindNull(3);
        } else {
          statement.bindLong(3, entity.getExpiresAt());
        }
        if (entity.getLength() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getLength());
        }
        final Integer _tmp = entity.getLivemode() == null ? null : (entity.getLivemode() ? 1 : 0);
        if (_tmp == null) {
          statement.bindNull(5);
        } else {
          statement.bindLong(5, _tmp);
        }
        if (entity.getPrefix() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPrefix());
        }
        if (entity.getSecret() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getSecret());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM one_time_key";
        return _query;
      }
    };
  }

  @Override
  public void insertAll(final List<OneTimeKey> items) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfOneTimeKey.insert(items);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public List<OneTimeKey> getAll() {
    final String _sql = "SELECT * FROM one_time_key";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "asset");
      final int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow(_cursor, "expires_at");
      final int _cursorIndexOfLength = CursorUtil.getColumnIndexOrThrow(_cursor, "length");
      final int _cursorIndexOfLivemode = CursorUtil.getColumnIndexOrThrow(_cursor, "livemode");
      final int _cursorIndexOfPrefix = CursorUtil.getColumnIndexOrThrow(_cursor, "prefix");
      final int _cursorIndexOfSecret = CursorUtil.getColumnIndexOrThrow(_cursor, "secret");
      final List<OneTimeKey> _result = new ArrayList<OneTimeKey>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final OneTimeKey _item;
        final String _tmpId;
        if (_cursor.isNull(_cursorIndexOfId)) {
          _tmpId = null;
        } else {
          _tmpId = _cursor.getString(_cursorIndexOfId);
        }
        final String _tmpAsset;
        if (_cursor.isNull(_cursorIndexOfAsset)) {
          _tmpAsset = null;
        } else {
          _tmpAsset = _cursor.getString(_cursorIndexOfAsset);
        }
        final Long _tmpExpiresAt;
        if (_cursor.isNull(_cursorIndexOfExpiresAt)) {
          _tmpExpiresAt = null;
        } else {
          _tmpExpiresAt = _cursor.getLong(_cursorIndexOfExpiresAt);
        }
        final Integer _tmpLength;
        if (_cursor.isNull(_cursorIndexOfLength)) {
          _tmpLength = null;
        } else {
          _tmpLength = _cursor.getInt(_cursorIndexOfLength);
        }
        final Boolean _tmpLivemode;
        final Integer _tmp;
        if (_cursor.isNull(_cursorIndexOfLivemode)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getInt(_cursorIndexOfLivemode);
        }
        _tmpLivemode = _tmp == null ? null : _tmp != 0;
        final String _tmpPrefix;
        if (_cursor.isNull(_cursorIndexOfPrefix)) {
          _tmpPrefix = null;
        } else {
          _tmpPrefix = _cursor.getString(_cursorIndexOfPrefix);
        }
        final String _tmpSecret;
        if (_cursor.isNull(_cursorIndexOfSecret)) {
          _tmpSecret = null;
        } else {
          _tmpSecret = _cursor.getString(_cursorIndexOfSecret);
        }
        _item = new OneTimeKey(_tmpId,_tmpAsset,_tmpExpiresAt,_tmpLength,_tmpLivemode,_tmpPrefix,_tmpSecret);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public int countIds(final List<String> ids) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT COUNT(asset) FROM one_time_key WHERE asset IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : ids) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _result;
      if (_cursor.moveToFirst()) {
        _result = _cursor.getInt(0);
      } else {
        _result = 0;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public OneTimeKey getByAssetId(final String id) {
    final String _sql = "SELECT * FROM one_time_key WHERE asset = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "asset");
      final int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow(_cursor, "expires_at");
      final int _cursorIndexOfLength = CursorUtil.getColumnIndexOrThrow(_cursor, "length");
      final int _cursorIndexOfLivemode = CursorUtil.getColumnIndexOrThrow(_cursor, "livemode");
      final int _cursorIndexOfPrefix = CursorUtil.getColumnIndexOrThrow(_cursor, "prefix");
      final int _cursorIndexOfSecret = CursorUtil.getColumnIndexOrThrow(_cursor, "secret");
      final OneTimeKey _result;
      if (_cursor.moveToFirst()) {
        final String _tmpId;
        if (_cursor.isNull(_cursorIndexOfId)) {
          _tmpId = null;
        } else {
          _tmpId = _cursor.getString(_cursorIndexOfId);
        }
        final String _tmpAsset;
        if (_cursor.isNull(_cursorIndexOfAsset)) {
          _tmpAsset = null;
        } else {
          _tmpAsset = _cursor.getString(_cursorIndexOfAsset);
        }
        final Long _tmpExpiresAt;
        if (_cursor.isNull(_cursorIndexOfExpiresAt)) {
          _tmpExpiresAt = null;
        } else {
          _tmpExpiresAt = _cursor.getLong(_cursorIndexOfExpiresAt);
        }
        final Integer _tmpLength;
        if (_cursor.isNull(_cursorIndexOfLength)) {
          _tmpLength = null;
        } else {
          _tmpLength = _cursor.getInt(_cursorIndexOfLength);
        }
        final Boolean _tmpLivemode;
        final Integer _tmp;
        if (_cursor.isNull(_cursorIndexOfLivemode)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getInt(_cursorIndexOfLivemode);
        }
        _tmpLivemode = _tmp == null ? null : _tmp != 0;
        final String _tmpPrefix;
        if (_cursor.isNull(_cursorIndexOfPrefix)) {
          _tmpPrefix = null;
        } else {
          _tmpPrefix = _cursor.getString(_cursorIndexOfPrefix);
        }
        final String _tmpSecret;
        if (_cursor.isNull(_cursorIndexOfSecret)) {
          _tmpSecret = null;
        } else {
          _tmpSecret = _cursor.getString(_cursorIndexOfSecret);
        }
        _result = new OneTimeKey(_tmpId,_tmpAsset,_tmpExpiresAt,_tmpLength,_tmpLivemode,_tmpPrefix,_tmpSecret);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public OneTimeKey getByLiveMode(final boolean livemode) {
    final String _sql = "SELECT * FROM one_time_key WHERE livemode = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp = livemode ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "asset");
      final int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow(_cursor, "expires_at");
      final int _cursorIndexOfLength = CursorUtil.getColumnIndexOrThrow(_cursor, "length");
      final int _cursorIndexOfLivemode = CursorUtil.getColumnIndexOrThrow(_cursor, "livemode");
      final int _cursorIndexOfPrefix = CursorUtil.getColumnIndexOrThrow(_cursor, "prefix");
      final int _cursorIndexOfSecret = CursorUtil.getColumnIndexOrThrow(_cursor, "secret");
      final OneTimeKey _result;
      if (_cursor.moveToFirst()) {
        final String _tmpId;
        if (_cursor.isNull(_cursorIndexOfId)) {
          _tmpId = null;
        } else {
          _tmpId = _cursor.getString(_cursorIndexOfId);
        }
        final String _tmpAsset;
        if (_cursor.isNull(_cursorIndexOfAsset)) {
          _tmpAsset = null;
        } else {
          _tmpAsset = _cursor.getString(_cursorIndexOfAsset);
        }
        final Long _tmpExpiresAt;
        if (_cursor.isNull(_cursorIndexOfExpiresAt)) {
          _tmpExpiresAt = null;
        } else {
          _tmpExpiresAt = _cursor.getLong(_cursorIndexOfExpiresAt);
        }
        final Integer _tmpLength;
        if (_cursor.isNull(_cursorIndexOfLength)) {
          _tmpLength = null;
        } else {
          _tmpLength = _cursor.getInt(_cursorIndexOfLength);
        }
        final Boolean _tmpLivemode;
        final Integer _tmp_1;
        if (_cursor.isNull(_cursorIndexOfLivemode)) {
          _tmp_1 = null;
        } else {
          _tmp_1 = _cursor.getInt(_cursorIndexOfLivemode);
        }
        _tmpLivemode = _tmp_1 == null ? null : _tmp_1 != 0;
        final String _tmpPrefix;
        if (_cursor.isNull(_cursorIndexOfPrefix)) {
          _tmpPrefix = null;
        } else {
          _tmpPrefix = _cursor.getString(_cursorIndexOfPrefix);
        }
        final String _tmpSecret;
        if (_cursor.isNull(_cursorIndexOfSecret)) {
          _tmpSecret = null;
        } else {
          _tmpSecret = _cursor.getString(_cursorIndexOfSecret);
        }
        _result = new OneTimeKey(_tmpId,_tmpAsset,_tmpExpiresAt,_tmpLength,_tmpLivemode,_tmpPrefix,_tmpSecret);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public boolean hasOutdatedItems() {
    final String _sql = "SELECT EXISTS(SELECT 1 FROM one_time_key WHERE expires_at < strftime('%s', 'now'))";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final boolean _result;
      if (_cursor.moveToFirst()) {
        final int _tmp;
        _tmp = _cursor.getInt(0);
        _result = _tmp != 0;
      } else {
        _result = false;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
