/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.db;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.flexa.core.data.db.AssetDao;
import com.flexa.core.data.db.AssetDao_Impl;
import com.flexa.core.data.db.BrandDao;
import com.flexa.core.data.db.BrandDao_Impl;
import com.flexa.core.data.db.BrandSessionDao;
import com.flexa.core.data.db.BrandSessionDao_Impl;
import com.flexa.core.data.db.Database;
import com.flexa.core.data.db.ExchangeRateDao;
import com.flexa.core.data.db.ExchangeRateDao_Impl;
import com.flexa.core.data.db.OneTimeKeyDao;
import com.flexa.core.data.db.OneTimeKeyDao_Impl;
import com.flexa.core.data.db.TransactionFeeDao;
import com.flexa.core.data.db.TransactionFeeDao_Impl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Database_Impl
extends Database {
    private volatile AssetDao _assetDao;
    private volatile BrandDao _brandDao;
    private volatile BrandSessionDao _brandSessionDao;
    private volatile ExchangeRateDao _exchangeRateDao;
    private volatile OneTimeKeyDao _oneTimeKeyDao;
    private volatile TransactionFeeDao _transactionFeeDao;

    @NonNull
    protected SupportSQLiteOpenHelper createOpenHelper(@NonNull DatabaseConfiguration config) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(11){

            public void createAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("CREATE TABLE IF NOT EXISTS `asset` (`id` TEXT NOT NULL, `icon_url` TEXT, `symbol` TEXT, `color` TEXT, `display_name` TEXT, PRIMARY KEY(`id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `brand` (`id` TEXT NOT NULL, `category_name` TEXT, `color` TEXT, `legacy_flexcodes` TEXT, `promotions` TEXT, `logo_url` TEXT, `name` TEXT, `slug` TEXT, `status` TEXT, PRIMARY KEY(`id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `brand_session` (`session_id` TEXT NOT NULL, `transaction_id` TEXT NOT NULL, `date` INTEGER NOT NULL, `legacy` INTEGER NOT NULL, PRIMARY KEY(`session_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `exchange_rate` (`asset` TEXT NOT NULL, `expires_at` INTEGER, `label` TEXT, `precision` INTEGER, `price` TEXT, `unit_of_account` TEXT, PRIMARY KEY(`asset`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `one_time_key` (`id` TEXT NOT NULL, `asset` TEXT, `expires_at` INTEGER, `length` INTEGER, `livemode` INTEGER, `prefix` TEXT, `secret` TEXT, PRIMARY KEY(`id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `transaction_fee` (`amount` TEXT, `asset` TEXT NOT NULL, `expires_at` INTEGER, `label` TEXT, `price` TEXT, `transaction_asset` TEXT NOT NULL, `zone` TEXT, PRIMARY KEY(`transaction_asset`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '9e57f3e7d72e862338620ef77090ccd9')");
            }

            public void dropAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("DROP TABLE IF EXISTS `asset`");
                db.execSQL("DROP TABLE IF EXISTS `brand`");
                db.execSQL("DROP TABLE IF EXISTS `brand_session`");
                db.execSQL("DROP TABLE IF EXISTS `exchange_rate`");
                db.execSQL("DROP TABLE IF EXISTS `one_time_key`");
                db.execSQL("DROP TABLE IF EXISTS `transaction_fee`");
                List _callbacks = Database_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onDestructiveMigration(db);
                    }
                }
            }

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                List _callbacks = Database_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onCreate(db);
                    }
                }
            }

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                Database_Impl.this.mDatabase = db;
                Database_Impl.this.internalInitInvalidationTracker(db);
                List _callbacks = Database_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onOpen(db);
                    }
                }
            }

            public void onPreMigrate(@NonNull SupportSQLiteDatabase db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)db);
            }

            public void onPostMigrate(@NonNull SupportSQLiteDatabase db) {
            }

            @NonNull
            public RoomOpenHelper.ValidationResult onValidateSchema(@NonNull SupportSQLiteDatabase db) {
                HashMap<String, TableInfo.Column> _columnsAsset = new HashMap<String, TableInfo.Column>(5);
                _columnsAsset.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsAsset.put("icon_url", new TableInfo.Column("icon_url", "TEXT", false, 0, null, 1));
                _columnsAsset.put("symbol", new TableInfo.Column("symbol", "TEXT", false, 0, null, 1));
                _columnsAsset.put("color", new TableInfo.Column("color", "TEXT", false, 0, null, 1));
                _columnsAsset.put("display_name", new TableInfo.Column("display_name", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysAsset = new HashSet(0);
                HashSet _indicesAsset = new HashSet(0);
                TableInfo _infoAsset = new TableInfo("asset", _columnsAsset, _foreignKeysAsset, _indicesAsset);
                TableInfo _existingAsset = TableInfo.read((SupportSQLiteDatabase)db, (String)"asset");
                if (!_infoAsset.equals((Object)_existingAsset)) {
                    return new RoomOpenHelper.ValidationResult(false, "asset(com.flexa.core.data.db.Asset).\n Expected:\n" + _infoAsset + "\n Found:\n" + _existingAsset);
                }
                HashMap<String, TableInfo.Column> _columnsBrand = new HashMap<String, TableInfo.Column>(9);
                _columnsBrand.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsBrand.put("category_name", new TableInfo.Column("category_name", "TEXT", false, 0, null, 1));
                _columnsBrand.put("color", new TableInfo.Column("color", "TEXT", false, 0, null, 1));
                _columnsBrand.put("legacy_flexcodes", new TableInfo.Column("legacy_flexcodes", "TEXT", false, 0, null, 1));
                _columnsBrand.put("promotions", new TableInfo.Column("promotions", "TEXT", false, 0, null, 1));
                _columnsBrand.put("logo_url", new TableInfo.Column("logo_url", "TEXT", false, 0, null, 1));
                _columnsBrand.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsBrand.put("slug", new TableInfo.Column("slug", "TEXT", false, 0, null, 1));
                _columnsBrand.put("status", new TableInfo.Column("status", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysBrand = new HashSet(0);
                HashSet _indicesBrand = new HashSet(0);
                TableInfo _infoBrand = new TableInfo("brand", _columnsBrand, _foreignKeysBrand, _indicesBrand);
                TableInfo _existingBrand = TableInfo.read((SupportSQLiteDatabase)db, (String)"brand");
                if (!_infoBrand.equals((Object)_existingBrand)) {
                    return new RoomOpenHelper.ValidationResult(false, "brand(com.flexa.core.data.db.Brand).\n Expected:\n" + _infoBrand + "\n Found:\n" + _existingBrand);
                }
                HashMap<String, TableInfo.Column> _columnsBrandSession = new HashMap<String, TableInfo.Column>(4);
                _columnsBrandSession.put("session_id", new TableInfo.Column("session_id", "TEXT", true, 1, null, 1));
                _columnsBrandSession.put("transaction_id", new TableInfo.Column("transaction_id", "TEXT", true, 0, null, 1));
                _columnsBrandSession.put("date", new TableInfo.Column("date", "INTEGER", true, 0, null, 1));
                _columnsBrandSession.put("legacy", new TableInfo.Column("legacy", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysBrandSession = new HashSet(0);
                HashSet _indicesBrandSession = new HashSet(0);
                TableInfo _infoBrandSession = new TableInfo("brand_session", _columnsBrandSession, _foreignKeysBrandSession, _indicesBrandSession);
                TableInfo _existingBrandSession = TableInfo.read((SupportSQLiteDatabase)db, (String)"brand_session");
                if (!_infoBrandSession.equals((Object)_existingBrandSession)) {
                    return new RoomOpenHelper.ValidationResult(false, "brand_session(com.flexa.core.data.db.BrandSession).\n Expected:\n" + _infoBrandSession + "\n Found:\n" + _existingBrandSession);
                }
                HashMap<String, TableInfo.Column> _columnsExchangeRate = new HashMap<String, TableInfo.Column>(6);
                _columnsExchangeRate.put("asset", new TableInfo.Column("asset", "TEXT", true, 1, null, 1));
                _columnsExchangeRate.put("expires_at", new TableInfo.Column("expires_at", "INTEGER", false, 0, null, 1));
                _columnsExchangeRate.put("label", new TableInfo.Column("label", "TEXT", false, 0, null, 1));
                _columnsExchangeRate.put("precision", new TableInfo.Column("precision", "INTEGER", false, 0, null, 1));
                _columnsExchangeRate.put("price", new TableInfo.Column("price", "TEXT", false, 0, null, 1));
                _columnsExchangeRate.put("unit_of_account", new TableInfo.Column("unit_of_account", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysExchangeRate = new HashSet(0);
                HashSet _indicesExchangeRate = new HashSet(0);
                TableInfo _infoExchangeRate = new TableInfo("exchange_rate", _columnsExchangeRate, _foreignKeysExchangeRate, _indicesExchangeRate);
                TableInfo _existingExchangeRate = TableInfo.read((SupportSQLiteDatabase)db, (String)"exchange_rate");
                if (!_infoExchangeRate.equals((Object)_existingExchangeRate)) {
                    return new RoomOpenHelper.ValidationResult(false, "exchange_rate(com.flexa.core.data.db.ExchangeRate).\n Expected:\n" + _infoExchangeRate + "\n Found:\n" + _existingExchangeRate);
                }
                HashMap<String, TableInfo.Column> _columnsOneTimeKey = new HashMap<String, TableInfo.Column>(7);
                _columnsOneTimeKey.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsOneTimeKey.put("asset", new TableInfo.Column("asset", "TEXT", false, 0, null, 1));
                _columnsOneTimeKey.put("expires_at", new TableInfo.Column("expires_at", "INTEGER", false, 0, null, 1));
                _columnsOneTimeKey.put("length", new TableInfo.Column("length", "INTEGER", false, 0, null, 1));
                _columnsOneTimeKey.put("livemode", new TableInfo.Column("livemode", "INTEGER", false, 0, null, 1));
                _columnsOneTimeKey.put("prefix", new TableInfo.Column("prefix", "TEXT", false, 0, null, 1));
                _columnsOneTimeKey.put("secret", new TableInfo.Column("secret", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysOneTimeKey = new HashSet(0);
                HashSet _indicesOneTimeKey = new HashSet(0);
                TableInfo _infoOneTimeKey = new TableInfo("one_time_key", _columnsOneTimeKey, _foreignKeysOneTimeKey, _indicesOneTimeKey);
                TableInfo _existingOneTimeKey = TableInfo.read((SupportSQLiteDatabase)db, (String)"one_time_key");
                if (!_infoOneTimeKey.equals((Object)_existingOneTimeKey)) {
                    return new RoomOpenHelper.ValidationResult(false, "one_time_key(com.flexa.core.data.db.OneTimeKey).\n Expected:\n" + _infoOneTimeKey + "\n Found:\n" + _existingOneTimeKey);
                }
                HashMap<String, TableInfo.Column> _columnsTransactionFee = new HashMap<String, TableInfo.Column>(7);
                _columnsTransactionFee.put("amount", new TableInfo.Column("amount", "TEXT", false, 0, null, 1));
                _columnsTransactionFee.put("asset", new TableInfo.Column("asset", "TEXT", true, 0, null, 1));
                _columnsTransactionFee.put("expires_at", new TableInfo.Column("expires_at", "INTEGER", false, 0, null, 1));
                _columnsTransactionFee.put("label", new TableInfo.Column("label", "TEXT", false, 0, null, 1));
                _columnsTransactionFee.put("price", new TableInfo.Column("price", "TEXT", false, 0, null, 1));
                _columnsTransactionFee.put("transaction_asset", new TableInfo.Column("transaction_asset", "TEXT", true, 1, null, 1));
                _columnsTransactionFee.put("zone", new TableInfo.Column("zone", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysTransactionFee = new HashSet(0);
                HashSet _indicesTransactionFee = new HashSet(0);
                TableInfo _infoTransactionFee = new TableInfo("transaction_fee", _columnsTransactionFee, _foreignKeysTransactionFee, _indicesTransactionFee);
                TableInfo _existingTransactionFee = TableInfo.read((SupportSQLiteDatabase)db, (String)"transaction_fee");
                if (!_infoTransactionFee.equals((Object)_existingTransactionFee)) {
                    return new RoomOpenHelper.ValidationResult(false, "transaction_fee(com.flexa.core.data.db.TransactionFee).\n Expected:\n" + _infoTransactionFee + "\n Found:\n" + _existingTransactionFee);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "9e57f3e7d72e862338620ef77090ccd9", "115974c61a8c3bb74b33bed61ee8d1ba");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)config.context).name(config.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    @NonNull
    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"asset", "brand", "brand_session", "exchange_rate", "one_time_key", "transaction_fee"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `asset`");
            _db.execSQL("DELETE FROM `brand`");
            _db.execSQL("DELETE FROM `brand_session`");
            _db.execSQL("DELETE FROM `exchange_rate`");
            _db.execSQL("DELETE FROM `one_time_key`");
            _db.execSQL("DELETE FROM `transaction_fee`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    @NonNull
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(AssetDao.class, AssetDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(BrandDao.class, BrandDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(BrandSessionDao.class, BrandSessionDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ExchangeRateDao.class, ExchangeRateDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(OneTimeKeyDao.class, OneTimeKeyDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(TransactionFeeDao.class, TransactionFeeDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    @NonNull
    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    @NonNull
    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
        ArrayList<Migration> _autoMigrations = new ArrayList<Migration>();
        return _autoMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssetDao assetsDao() {
        if (this._assetDao != null) {
            return this._assetDao;
        }
        Database_Impl database_Impl = this;
        synchronized (database_Impl) {
            if (this._assetDao == null) {
                this._assetDao = new AssetDao_Impl(this);
            }
            return this._assetDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrandDao brandsDao() {
        if (this._brandDao != null) {
            return this._brandDao;
        }
        Database_Impl database_Impl = this;
        synchronized (database_Impl) {
            if (this._brandDao == null) {
                this._brandDao = new BrandDao_Impl(this);
            }
            return this._brandDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrandSessionDao brandSessionDao() {
        if (this._brandSessionDao != null) {
            return this._brandSessionDao;
        }
        Database_Impl database_Impl = this;
        synchronized (database_Impl) {
            if (this._brandSessionDao == null) {
                this._brandSessionDao = new BrandSessionDao_Impl(this);
            }
            return this._brandSessionDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeRateDao exchangeRateDao() {
        if (this._exchangeRateDao != null) {
            return this._exchangeRateDao;
        }
        Database_Impl database_Impl = this;
        synchronized (database_Impl) {
            if (this._exchangeRateDao == null) {
                this._exchangeRateDao = new ExchangeRateDao_Impl(this);
            }
            return this._exchangeRateDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OneTimeKeyDao oneTimeKeyDao() {
        if (this._oneTimeKeyDao != null) {
            return this._oneTimeKeyDao;
        }
        Database_Impl database_Impl = this;
        synchronized (database_Impl) {
            if (this._oneTimeKeyDao == null) {
                this._oneTimeKeyDao = new OneTimeKeyDao_Impl(this);
            }
            return this._oneTimeKeyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionFeeDao transactionFeeDao() {
        if (this._transactionFeeDao != null) {
            return this._transactionFeeDao;
        }
        Database_Impl database_Impl = this;
        synchronized (database_Impl) {
            if (this._transactionFeeDao == null) {
                this._transactionFeeDao = new TransactionFeeDao_Impl(this);
            }
            return this._transactionFeeDao;
        }
    }
}

