/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flexa.core.data.db.ExchangeRate;
import com.flexa.core.data.db.ExchangeRateDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ExchangeRateDao_Impl
implements ExchangeRateDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ExchangeRate> __insertionAdapterOfExchangeRate;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public ExchangeRateDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfExchangeRate = new EntityInsertionAdapter<ExchangeRate>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `exchange_rate` (`asset`,`expires_at`,`label`,`precision`,`price`,`unit_of_account`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ExchangeRate entity) {
                if (entity.getAsset() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindString(1, entity.getAsset());
                }
                if (entity.getExpiresAt() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindLong(2, entity.getExpiresAt().longValue());
                }
                if (entity.getLabel() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getLabel());
                }
                if (entity.getPrecision() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, (long)entity.getPrecision().intValue());
                }
                if (entity.getPrice() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getPrice());
                }
                if (entity.getUnitOfAccount() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getUnitOfAccount());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM exchange_rate";
                return "DELETE FROM exchange_rate";
            }
        };
    }

    @Override
    public void insertAll(List<ExchangeRate> items) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfExchangeRate.insert(items);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExchangeRate> getAll() {
        String _sql = "SELECT * FROM exchange_rate";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM exchange_rate", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"asset");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expires_at");
            int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"label");
            int _cursorIndexOfPrecision = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"precision");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfUnitOfAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unit_of_account");
            ArrayList<ExchangeRate> _result = new ArrayList<ExchangeRate>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpAsset = _cursor.isNull(_cursorIndexOfAsset) ? null : _cursor.getString(_cursorIndexOfAsset);
                Long _tmpExpiresAt = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpiresAt));
                String _tmpLabel = _cursor.isNull(_cursorIndexOfLabel) ? null : _cursor.getString(_cursorIndexOfLabel);
                Integer _tmpPrecision = _cursor.isNull(_cursorIndexOfPrecision) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPrecision));
                String _tmpPrice = _cursor.isNull(_cursorIndexOfPrice) ? null : _cursor.getString(_cursorIndexOfPrice);
                String _tmpUnitOfAccount = _cursor.isNull(_cursorIndexOfUnitOfAccount) ? null : _cursor.getString(_cursorIndexOfUnitOfAccount);
                ExchangeRate _item = new ExchangeRate(_tmpAsset, _tmpExpiresAt, _tmpLabel, _tmpPrecision, _tmpPrice, _tmpUnitOfAccount);
                _result.add(_item);
            }
            ArrayList<ExchangeRate> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT COUNT(asset) FROM exchange_rate WHERE asset IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeRate getByIdl(String id) {
        String _sql = "SELECT * FROM exchange_rate WHERE asset = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM exchange_rate WHERE asset = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ExchangeRate _result;
            int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"asset");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expires_at");
            int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"label");
            int _cursorIndexOfPrecision = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"precision");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfUnitOfAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unit_of_account");
            if (_cursor.moveToFirst()) {
                String _tmpAsset = _cursor.isNull(_cursorIndexOfAsset) ? null : _cursor.getString(_cursorIndexOfAsset);
                Long _tmpExpiresAt = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpiresAt));
                String _tmpLabel = _cursor.isNull(_cursorIndexOfLabel) ? null : _cursor.getString(_cursorIndexOfLabel);
                Integer _tmpPrecision = _cursor.isNull(_cursorIndexOfPrecision) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPrecision));
                String _tmpPrice = _cursor.isNull(_cursorIndexOfPrice) ? null : _cursor.getString(_cursorIndexOfPrice);
                String _tmpUnitOfAccount = _cursor.isNull(_cursorIndexOfUnitOfAccount) ? null : _cursor.getString(_cursorIndexOfUnitOfAccount);
                _result = new ExchangeRate(_tmpAsset, _tmpExpiresAt, _tmpLabel, _tmpPrecision, _tmpPrice, _tmpUnitOfAccount);
            } else {
                _result = null;
            }
            ExchangeRate exchangeRate = _result;
            return exchangeRate;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasOutdatedItems() {
        String _sql = "SELECT EXISTS(SELECT 1 FROM exchange_rate WHERE expires_at < strftime('%s', 'now'))";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT 1 FROM exchange_rate WHERE expires_at < strftime('%s', 'now'))", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

