package com.flexa.core.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flexa.core.shared.LegacyFlexcode;
import com.flexa.core.shared.Promotion;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SuppressWarnings({"unchecked", "deprecation"})
public final class BrandDao_Impl implements BrandDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Brand> __insertionAdapterOfBrand;

  private final ObjectListsConverter __objectListsConverter = new ObjectListsConverter();

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public BrandDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfBrand = new EntityInsertionAdapter<Brand>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `brand` (`id`,`category_name`,`color`,`legacy_flexcodes`,`promotions`,`logo_url`,`name`,`slug`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Brand entity) {
        if (entity.getId() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getId());
        }
        if (entity.getCategoryName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCategoryName());
        }
        if (entity.getColor() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getColor());
        }
        final String _tmp = __objectListsConverter.fromLegacyFlexcode(entity.getLegacyFlexcodes());
        if (_tmp == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, _tmp);
        }
        final String _tmp_1 = __objectListsConverter.fromPromotion(entity.getPromotions());
        if (_tmp_1 == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp_1);
        }
        if (entity.getLogoUrl() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getLogoUrl());
        }
        if (entity.getName() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getName());
        }
        if (entity.getSlug() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getSlug());
        }
        if (entity.getStatus() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getStatus());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM brand";
        return _query;
      }
    };
  }

  @Override
  public void insertAll(final List<Brand> items) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfBrand.insert(items);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public List<Brand> getAll() {
    final String _sql = "SELECT * FROM brand";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfCategoryName = CursorUtil.getColumnIndexOrThrow(_cursor, "category_name");
      final int _cursorIndexOfColor = CursorUtil.getColumnIndexOrThrow(_cursor, "color");
      final int _cursorIndexOfLegacyFlexcodes = CursorUtil.getColumnIndexOrThrow(_cursor, "legacy_flexcodes");
      final int _cursorIndexOfPromotions = CursorUtil.getColumnIndexOrThrow(_cursor, "promotions");
      final int _cursorIndexOfLogoUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "logo_url");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfSlug = CursorUtil.getColumnIndexOrThrow(_cursor, "slug");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
      final List<Brand> _result = new ArrayList<Brand>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Brand _item;
        final String _tmpId;
        if (_cursor.isNull(_cursorIndexOfId)) {
          _tmpId = null;
        } else {
          _tmpId = _cursor.getString(_cursorIndexOfId);
        }
        final String _tmpCategoryName;
        if (_cursor.isNull(_cursorIndexOfCategoryName)) {
          _tmpCategoryName = null;
        } else {
          _tmpCategoryName = _cursor.getString(_cursorIndexOfCategoryName);
        }
        final String _tmpColor;
        if (_cursor.isNull(_cursorIndexOfColor)) {
          _tmpColor = null;
        } else {
          _tmpColor = _cursor.getString(_cursorIndexOfColor);
        }
        final List<LegacyFlexcode> _tmpLegacyFlexcodes;
        final String _tmp;
        if (_cursor.isNull(_cursorIndexOfLegacyFlexcodes)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getString(_cursorIndexOfLegacyFlexcodes);
        }
        _tmpLegacyFlexcodes = __objectListsConverter.toLegacyFlexcode(_tmp);
        final List<Promotion> _tmpPromotions;
        final String _tmp_1;
        if (_cursor.isNull(_cursorIndexOfPromotions)) {
          _tmp_1 = null;
        } else {
          _tmp_1 = _cursor.getString(_cursorIndexOfPromotions);
        }
        _tmpPromotions = __objectListsConverter.toPromotion(_tmp_1);
        final String _tmpLogoUrl;
        if (_cursor.isNull(_cursorIndexOfLogoUrl)) {
          _tmpLogoUrl = null;
        } else {
          _tmpLogoUrl = _cursor.getString(_cursorIndexOfLogoUrl);
        }
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        final String _tmpSlug;
        if (_cursor.isNull(_cursorIndexOfSlug)) {
          _tmpSlug = null;
        } else {
          _tmpSlug = _cursor.getString(_cursorIndexOfSlug);
        }
        final String _tmpStatus;
        if (_cursor.isNull(_cursorIndexOfStatus)) {
          _tmpStatus = null;
        } else {
          _tmpStatus = _cursor.getString(_cursorIndexOfStatus);
        }
        _item = new Brand(_tmpId,_tmpCategoryName,_tmpColor,_tmpLegacyFlexcodes,_tmpPromotions,_tmpLogoUrl,_tmpName,_tmpSlug,_tmpStatus);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
