package com.flexa.core.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ExchangeRateDao_Impl implements ExchangeRateDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ExchangeRate> __insertionAdapterOfExchangeRate;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public ExchangeRateDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfExchangeRate = new EntityInsertionAdapter<ExchangeRate>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `exchange_rate` (`asset`,`expires_at`,`label`,`precision`,`price`,`unit_of_account`) VALUES (?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ExchangeRate entity) {
        if (entity.getAsset() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getAsset());
        }
        if (entity.getExpiresAt() == null) {
          statement.bindNull(2);
        } else {
          statement.bindLong(2, entity.getExpiresAt());
        }
        if (entity.getLabel() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getLabel());
        }
        if (entity.getPrecision() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getPrecision());
        }
        if (entity.getPrice() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getPrice());
        }
        if (entity.getUnitOfAccount() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getUnitOfAccount());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM exchange_rate";
        return _query;
      }
    };
  }

  @Override
  public void insertAll(final List<ExchangeRate> items) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfExchangeRate.insert(items);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public List<ExchangeRate> getAll() {
    final String _sql = "SELECT * FROM exchange_rate";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "asset");
      final int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow(_cursor, "expires_at");
      final int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow(_cursor, "label");
      final int _cursorIndexOfPrecision = CursorUtil.getColumnIndexOrThrow(_cursor, "precision");
      final int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow(_cursor, "price");
      final int _cursorIndexOfUnitOfAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "unit_of_account");
      final List<ExchangeRate> _result = new ArrayList<ExchangeRate>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final ExchangeRate _item;
        final String _tmpAsset;
        if (_cursor.isNull(_cursorIndexOfAsset)) {
          _tmpAsset = null;
        } else {
          _tmpAsset = _cursor.getString(_cursorIndexOfAsset);
        }
        final Long _tmpExpiresAt;
        if (_cursor.isNull(_cursorIndexOfExpiresAt)) {
          _tmpExpiresAt = null;
        } else {
          _tmpExpiresAt = _cursor.getLong(_cursorIndexOfExpiresAt);
        }
        final String _tmpLabel;
        if (_cursor.isNull(_cursorIndexOfLabel)) {
          _tmpLabel = null;
        } else {
          _tmpLabel = _cursor.getString(_cursorIndexOfLabel);
        }
        final Integer _tmpPrecision;
        if (_cursor.isNull(_cursorIndexOfPrecision)) {
          _tmpPrecision = null;
        } else {
          _tmpPrecision = _cursor.getInt(_cursorIndexOfPrecision);
        }
        final String _tmpPrice;
        if (_cursor.isNull(_cursorIndexOfPrice)) {
          _tmpPrice = null;
        } else {
          _tmpPrice = _cursor.getString(_cursorIndexOfPrice);
        }
        final String _tmpUnitOfAccount;
        if (_cursor.isNull(_cursorIndexOfUnitOfAccount)) {
          _tmpUnitOfAccount = null;
        } else {
          _tmpUnitOfAccount = _cursor.getString(_cursorIndexOfUnitOfAccount);
        }
        _item = new ExchangeRate(_tmpAsset,_tmpExpiresAt,_tmpLabel,_tmpPrecision,_tmpPrice,_tmpUnitOfAccount);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public int countIds(final List<String> ids) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT COUNT(asset) FROM exchange_rate WHERE asset IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : ids) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _result;
      if (_cursor.moveToFirst()) {
        _result = _cursor.getInt(0);
      } else {
        _result = 0;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ExchangeRate getByIdl(final String id) {
    final String _sql = "SELECT * FROM exchange_rate WHERE asset = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "asset");
      final int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow(_cursor, "expires_at");
      final int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow(_cursor, "label");
      final int _cursorIndexOfPrecision = CursorUtil.getColumnIndexOrThrow(_cursor, "precision");
      final int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow(_cursor, "price");
      final int _cursorIndexOfUnitOfAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "unit_of_account");
      final ExchangeRate _result;
      if (_cursor.moveToFirst()) {
        final String _tmpAsset;
        if (_cursor.isNull(_cursorIndexOfAsset)) {
          _tmpAsset = null;
        } else {
          _tmpAsset = _cursor.getString(_cursorIndexOfAsset);
        }
        final Long _tmpExpiresAt;
        if (_cursor.isNull(_cursorIndexOfExpiresAt)) {
          _tmpExpiresAt = null;
        } else {
          _tmpExpiresAt = _cursor.getLong(_cursorIndexOfExpiresAt);
        }
        final String _tmpLabel;
        if (_cursor.isNull(_cursorIndexOfLabel)) {
          _tmpLabel = null;
        } else {
          _tmpLabel = _cursor.getString(_cursorIndexOfLabel);
        }
        final Integer _tmpPrecision;
        if (_cursor.isNull(_cursorIndexOfPrecision)) {
          _tmpPrecision = null;
        } else {
          _tmpPrecision = _cursor.getInt(_cursorIndexOfPrecision);
        }
        final String _tmpPrice;
        if (_cursor.isNull(_cursorIndexOfPrice)) {
          _tmpPrice = null;
        } else {
          _tmpPrice = _cursor.getString(_cursorIndexOfPrice);
        }
        final String _tmpUnitOfAccount;
        if (_cursor.isNull(_cursorIndexOfUnitOfAccount)) {
          _tmpUnitOfAccount = null;
        } else {
          _tmpUnitOfAccount = _cursor.getString(_cursorIndexOfUnitOfAccount);
        }
        _result = new ExchangeRate(_tmpAsset,_tmpExpiresAt,_tmpLabel,_tmpPrecision,_tmpPrice,_tmpUnitOfAccount);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public boolean hasOutdatedItems() {
    final String _sql = "SELECT EXISTS(SELECT 1 FROM exchange_rate WHERE expires_at < strftime('%s', 'now'))";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final boolean _result;
      if (_cursor.moveToFirst()) {
        final int _tmp;
        _tmp = _cursor.getInt(0);
        _result = _tmp != 0;
      } else {
        _result = false;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
