/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.flexa.R;
import com.flexa.core.data.rest.RestRepository;
import com.flexa.core.entity.Account;
import com.flexa.core.entity.AppAccount;
import com.flexa.core.entity.AssetKey;
import com.flexa.core.entity.AvailableAsset;
import com.flexa.core.entity.BalanceBundle;
import com.flexa.core.entity.ExchangeRate;
import com.flexa.core.entity.Limit;
import com.flexa.core.entity.OneTimeKey;
import com.flexa.core.entity.error.ApiException;
import com.flexa.core.shared.AssetAccount;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0002*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\b\u001a\u00020\u0002*\u00020\u0005\u001a\n\u0010\t\u001a\u00020\u0002*\u00020\u0005\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u0002*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0005\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001*\u00020\u0003\u001a\u0018\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0002\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0000\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!\u001a\f\u0010\"\u001a\u00020\u0002*\u0004\u0018\u00010\u0002\u001a\u0014\u0010#\u001a\u00020$*\u00020\u00022\b\b\u0002\u0010%\u001a\u00020\u0002\u001a\n\u0010&\u001a\u00020'*\u00020(\u001a\u0010\u0010&\u001a\u00020'*\b\u0012\u0004\u0012\u00020(0\u0001\u001a\n\u0010)\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010*\u001a\u00020\f*\u00020\u0012\u00a8\u0006+"}, d2={"getAssetIds", "", "", "Lcom/flexa/core/entity/AppAccount;", "getJoinedYear", "Lcom/flexa/core/entity/Account;", "getLimitsPercentage", "", "getResetDay", "getResetHour", "getUnitOfAccount", "hasLimits", "", "minutesBetween", "", "Ljava/time/Instant;", "timestamp", "nonZeroAssets", "Lcom/flexa/core/entity/AvailableAsset;", "sendFlexaReport", "", "Landroid/app/Activity;", "data", "toApiException", "Lcom/flexa/core/entity/error/ApiException;", "Lokhttp3/Response;", "toAssetKey", "Lcom/flexa/core/entity/AssetKey;", "Lcom/flexa/core/entity/OneTimeKey;", "toBalanceBundle", "Lcom/flexa/core/entity/BalanceBundle;", "Lcom/flexa/core/entity/ExchangeRate;", "asset", "Lcom/flexa/core/shared/AvailableAsset;", "toCurrencySign", "toDate", "Ljava/util/Date;", "dateFormat", "toJsonObject", "Lkotlinx/serialization/json/JsonObject;", "Lcom/flexa/core/shared/AssetAccount;", "toNavArgument", "zeroValue", "core_release"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ncom/flexa/core/ExtensionsKt\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n28#2,4:264\n28#2,3:280\n31#2:284\n295#3,2:268\n1368#3:270\n1454#3,5:271\n1557#3:276\n1628#3,3:277\n774#3:285\n865#3,2:286\n1#4:283\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ncom/flexa/core/ExtensionsKt\n*L\n68#1:264,4\n86#1:280,3\n86#1:284\n77#1:268,2\n81#1:270\n81#1:271,5\n82#1:276\n82#1:277,3\n170#1:285\n170#1:286,2\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final String toNavArgument(@NotNull String $this$toNavArgument) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$toNavArgument, (String)"<this>");
        try {
            string2 = URLEncoder.encode($this$toNavArgument, StandardCharsets.UTF_8.name());
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (Exception e) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public static final String toCurrencySign(@Nullable String $this$toCurrencySign) {
        String string2 = $this$toCurrencySign;
        return Intrinsics.areEqual((Object)string2, (Object)"iso4217/USD") ? "$" : (Intrinsics.areEqual((Object)string2, (Object)"iso4217/EUR") ? "\u20ac" : "\u00a4");
    }

    public static final long minutesBetween(@NotNull Instant $this$minutesBetween, long timestamp) {
        Serializable it;
        Object $this$minutesBetween_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)$this$minutesBetween, (String)"<this>");
        Object object = $this$minutesBetween;
        try {
            $this$minutesBetween_u24lambda_u240 = object;
            boolean bl = false;
            $this$minutesBetween_u24lambda_u240 = Result.constructor-impl((Object)Duration.between((Temporal)$this$minutesBetween_u24lambda_u240, Instant.ofEpochMilli(timestamp * 1000L)));
        }
        catch (Throwable bl) {
            $this$minutesBetween_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$minutesBetween_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            it = (Duration)object;
            boolean bl = false;
            return ((Duration)it).toMinutes();
        }
        it = throwable;
        boolean bl = false;
        return 0L;
    }

    @NotNull
    public static final JsonObject toJsonObject(@NotNull List<AssetAccount> $this$toJsonObject) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter($this$toJsonObject, (String)"<this>");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$toJsonObject_u24lambda_u243 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$toJsonObject_u24lambda_u243, (String)"data", (Function1)((Function1)new Function1<JsonArrayBuilder, Unit>($this$toJsonObject){
            final /* synthetic */ List<AssetAccount> $this_toJsonObject;
            {
                this.$this_toJsonObject = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JsonArrayBuilder $this$putJsonArray) {
                Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
                Iterable $this$forEach$iv = this.$this_toJsonObject;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AssetAccount acc = (AssetAccount)element$iv;
                    boolean bl = false;
                    $this$putJsonArray.add((JsonElement)ExtensionsKt.toJsonObject(acc));
                }
            }
        }));
        return builder$iv.build();
    }

    @Nullable
    public static final String getUnitOfAccount(@NotNull List<AppAccount> $this$getUnitOfAccount) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter($this$getUnitOfAccount, (String)"<this>");
            Iterable $this$firstOrNull$iv = $this$getUnitOfAccount;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AppAccount it = (AppAccount)element$iv;
                boolean bl = false;
                CharSequence charSequence = it.getUnitOfAccount();
                boolean bl2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
                if (!bl2) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        AppAccount appAccount = v1;
        return appAccount != null ? appAccount.getUnitOfAccount() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getAssetIds(@NotNull List<AppAccount> $this$getAssetIds) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        AppAccount it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getAssetIds, (String)"<this>");
        Iterable $this$flatMap$iv = $this$getAssetIds;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (AppAccount)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getAvailableAssets();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (AvailableAsset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((AvailableAsset)((Object)it)).getAssetId());
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    public static final JsonObject toJsonObject(@NotNull AssetAccount $this$toJsonObject) {
        String it;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toJsonObject, (String)"<this>");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$toJsonObject_u24lambda_u249 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$toJsonObject_u24lambda_u249, (String)"account_id", (String)$this$toJsonObject.getAssetAccountHash());
        String string2 = $this$toJsonObject.getDisplayName();
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$toJsonObject_u24lambda_u249, (String)"display_name", (String)it);
        }
        String string3 = $this$toJsonObject.getIcon();
        if (string3 != null) {
            it = string3;
            boolean bl3 = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$toJsonObject_u24lambda_u249, (String)"icon", (String)it);
        }
        if (!((Collection)$this$toJsonObject.getAvailableAssets()).isEmpty()) {
            JsonElementBuildersKt.putJsonArray((JsonObjectBuilder)$this$toJsonObject_u24lambda_u249, (String)"assets", (Function1)((Function1)new Function1<JsonArrayBuilder, Unit>($this$toJsonObject){
                final /* synthetic */ AssetAccount $this_toJsonObject;
                {
                    this.$this_toJsonObject = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull JsonArrayBuilder $this$putJsonArray) {
                    Intrinsics.checkNotNullParameter((Object)$this$putJsonArray, (String)"$this$putJsonArray");
                    Iterable $this$forEach$iv = this.$this_toJsonObject.getAvailableAssets();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        com.flexa.core.shared.AvailableAsset asset = (com.flexa.core.shared.AvailableAsset)element$iv;
                        boolean bl = false;
                        JsonElementBuildersKt.addJsonObject((JsonArrayBuilder)$this$putJsonArray, (Function1)((Function1)new Function1<JsonObjectBuilder, Unit>(asset){
                            final /* synthetic */ com.flexa.core.shared.AvailableAsset $asset;
                            {
                                this.$asset = $asset;
                                super(1);
                            }

                            public final void invoke(@NotNull JsonObjectBuilder $this$addJsonObject) {
                                block2: {
                                    String it;
                                    Intrinsics.checkNotNullParameter((Object)$this$addJsonObject, (String)"$this$addJsonObject");
                                    JsonElementBuildersKt.put((JsonObjectBuilder)$this$addJsonObject, (String)"asset", (String)this.$asset.getAssetId());
                                    JsonElementBuildersKt.put((JsonObjectBuilder)$this$addJsonObject, (String)"balance", (String)String.valueOf(this.$asset.getBalance()));
                                    String string2 = this.$asset.getIcon();
                                    if (string2 != null) {
                                        it = string2;
                                        boolean bl = false;
                                        JsonElementBuildersKt.put((JsonObjectBuilder)$this$addJsonObject, (String)"icon", (String)it);
                                    }
                                    String string3 = this.$asset.getDisplayName();
                                    if (string3 != null) {
                                        it = string3;
                                        boolean bl = false;
                                        JsonElementBuildersKt.put((JsonObjectBuilder)$this$addJsonObject, (String)"display_name", (String)it);
                                    }
                                    String string4 = this.$asset.getSymbol();
                                    if (string4 == null) break block2;
                                    it = string4;
                                    boolean bl = false;
                                    JsonElementBuildersKt.put((JsonObjectBuilder)$this$addJsonObject, (String)"symbol", (String)it);
                                }
                            }
                        }));
                    }
                }
            }));
        }
        return builder$iv.build();
    }

    @NotNull
    public static final Date toDate(@NotNull String $this$toDate, @NotNull String dateFormat) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        try {
            Date date2 = new SimpleDateFormat(dateFormat, Locale.US).parse($this$toDate);
            if (date2 == null) {
                date2 = new Date();
            }
            date = date2;
        }
        catch (ParseException e) {
            Log.e(null, (String)"String.toDate:", (Throwable)e);
            date = new Date();
        }
        return date;
    }

    public static /* synthetic */ Date toDate$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "EEE, dd MMM yyyy HH:mm:ss z";
        }
        return ExtensionsKt.toDate(string2, string3);
    }

    @NotNull
    public static final ApiException toApiException(@NotNull Response $this$toApiException) throws SerializationException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)$this$toApiException, (String)"<this>");
        ResponseBody responseBody = $this$toApiException.body();
        String raw = String.valueOf(responseBody != null ? responseBody.string() : null);
        String string2 = $this$toApiException.header("client-trace-id", null);
        if (string2 == null) {
            string2 = "";
        }
        String traceId = string2;
        JsonElement jsonResponse = RestRepository.Companion.getJson().parseToJsonElement(raw);
        JsonElement errorObject = (JsonElement)JsonElementKt.getJsonObject((JsonElement)jsonResponse).get((Object)"error");
        Object object = errorObject;
        Integer code = object != null && (object = JsonElementKt.getJsonObject((JsonElement)object)) != null && (object = (JsonElement)object.get((Object)"code")) != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) != null ? StringsKt.toIntOrNull((String)object) : null;
        JsonElement jsonElement = errorObject;
        String message = jsonElement != null && (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) != null && (jsonElement = (JsonElement)jsonElement.get((Object)"message")) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement) : null;
        JsonElement jsonElement2 = errorObject;
        String type = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonObject((JsonElement)jsonElement2)) != null && (jsonElement2 = (JsonElement)jsonElement2.get((Object)"type")) != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
        return new ApiException(code, message, type, traceId);
    }

    public static final boolean zeroValue(@NotNull AvailableAsset $this$zeroValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$zeroValue, (String)"<this>");
        Object object = $this$zeroValue.getBalanceBundle();
        if (object != null && (object = ((BalanceBundle)object).getTotal()) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)BigDecimal.ZERO);
        } else {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public static final BalanceBundle toBalanceBundle(@Nullable ExchangeRate $this$toBalanceBundle, @Nullable com.flexa.core.shared.AvailableAsset asset) {
        BalanceBundle balanceBundle;
        ExchangeRate exchangeRate = $this$toBalanceBundle;
        if (exchangeRate != null) {
            String string2;
            BigDecimal bigDecimal;
            Object object;
            BigDecimal balanceAvailable;
            BigDecimal bigDecimal2;
            ExchangeRate $this$toBalanceBundle_u24lambda_u2414 = exchangeRate;
            boolean bl = false;
            int scale = 2;
            RoundingMode roundingMode = RoundingMode.DOWN;
            com.flexa.core.shared.AvailableAsset availableAsset = asset;
            BigDecimal balance = BigDecimal.valueOf(availableAsset != null ? availableAsset.getBalance() : 0.0);
            Object object2 = asset;
            if (object2 != null && (object2 = ((com.flexa.core.shared.AvailableAsset)object2).getBalanceAvailable()) != null) {
                double $this$toBalanceBundle_u24lambda_u2414_u24lambda_u2411 = ((Number)object2).doubleValue();
                boolean bl2 = false;
                bigDecimal2 = BigDecimal.valueOf($this$toBalanceBundle_u24lambda_u2414_u24lambda_u2411);
            } else {
                bigDecimal2 = balanceAvailable = null;
            }
            if ((object = $this$toBalanceBundle_u24lambda_u2414.getPrice()) == null || (object = StringsKt.toBigDecimalOrNull((String)object)) == null) {
                object = BigDecimal.ZERO;
            }
            Object ratePrice = object;
            BigDecimal total = ((BigDecimal)ratePrice).multiply(balance).setScale(scale, roundingMode);
            BigDecimal bigDecimal3 = balanceAvailable;
            if (bigDecimal3 != null) {
                BigDecimal $this$toBalanceBundle_u24lambda_u2414_u24lambda_u2412 = bigDecimal3;
                boolean bl3 = false;
                Object object3 = $this$toBalanceBundle_u24lambda_u2414.getPrice();
                if (object3 == null || (object3 = StringsKt.toBigDecimalOrNull((String)object3)) == null) {
                    object3 = BigDecimal.ZERO;
                }
                bigDecimal = ((BigDecimal)object3).multiply($this$toBalanceBundle_u24lambda_u2414_u24lambda_u2412).setScale(scale, roundingMode);
            } else {
                bigDecimal = null;
            }
            BigDecimal available = bigDecimal;
            String string3 = $this$toBalanceBundle_u24lambda_u2414.getUnitOfAccount();
            String currencySign = string3 != null ? ExtensionsKt.toCurrencySign(string3) : null;
            String totalLabel = currencySign + total;
            BigDecimal bigDecimal4 = available;
            if (bigDecimal4 != null) {
                BigDecimal $this$toBalanceBundle_u24lambda_u2414_u24lambda_u2413 = bigDecimal4;
                boolean bl4 = false;
                string2 = currencySign + $this$toBalanceBundle_u24lambda_u2414_u24lambda_u2413;
            } else {
                string2 = null;
            }
            String availableLabel = string2;
            Intrinsics.checkNotNull((Object)total);
            balanceBundle = new BalanceBundle(total, totalLabel, available, availableLabel);
        } else {
            balanceBundle = null;
        }
        return balanceBundle;
    }

    @NotNull
    public static final AssetKey toAssetKey(@NotNull OneTimeKey $this$toAssetKey) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$toAssetKey, (String)"<this>");
        String string3 = $this$toAssetKey.getPrefix();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = $this$toAssetKey.getSecret()) == null) {
            string2 = "";
        }
        Integer n = $this$toAssetKey.getLength();
        return new AssetKey(string3, string2, n != null ? n : 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AvailableAsset> nonZeroAssets(@NotNull AppAccount $this$nonZeroAssets) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$nonZeroAssets, (String)"<this>");
        Iterable $this$filter$iv = $this$nonZeroAssets.getAvailableAssets();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AvailableAsset it = (AvailableAsset)element$iv$iv;
            boolean bl = false;
            if (!(!ExtensionsKt.zeroValue(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final void sendFlexaReport(@Nullable Activity $this$sendFlexaReport, @Nullable String data) {
        block5: {
            Integer n;
            Activity activity = $this$sendFlexaReport;
            if (activity == null) break block5;
            Activity $this$sendFlexaReport_u24lambda_u2417 = activity;
            boolean bl = false;
            StringBuilder messageBody = new StringBuilder();
            messageBody.append($this$sendFlexaReport_u24lambda_u2417.getString(R.string.report_email_message_body));
            try {
                PackageInfo packageInfo = Build.VERSION.SDK_INT < 33 ? $this$sendFlexaReport_u24lambda_u2417.getApplication().getPackageManager().getPackageInfo($this$sendFlexaReport_u24lambda_u2417.getApplication().getPackageName(), 0) : $this$sendFlexaReport_u24lambda_u2417.getApplication().getPackageManager().getPackageInfo($this$sendFlexaReport_u24lambda_u2417.getApplication().getPackageName(), PackageManager.PackageInfoFlags.of((long)0L));
                String string2 = $this$sendFlexaReport_u24lambda_u2417.getString(packageInfo.applicationInfo.labelRes);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                String appName = string2;
                Number appCode = Build.VERSION.SDK_INT < 28 ? (Number)packageInfo.versionCode : (Number)packageInfo.getLongVersionCode();
                String appVersionName = packageInfo.versionName;
                String deviceModel = Build.MODEL;
                String deviceManufacturer = Build.MANUFACTURER;
                messageBody.append("\n\u2022 Application: " + appName + " code: " + appCode + " version name: " + appVersionName);
                messageBody.append("\n\u2022 Device: " + deviceManufacturer + ' ' + deviceModel + " Android: " + Build.VERSION.RELEASE + " API: " + Build.VERSION.SDK_INT);
                messageBody.append("\n\u2022 Flexa SDK: 1.0.11 2025-02-03");
                messageBody.append("\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String string3 = data;
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                messageBody.append(it);
            }
            String uriText = "mailto:" + $this$sendFlexaReport_u24lambda_u2417.getString(R.string.flexa_report_email) + "?subject=" + Uri.encode((String)$this$sendFlexaReport_u24lambda_u2417.getString(R.string.report_an_issue)) + "&body=" + Uri.encode((String)messageBody.toString());
            Uri uri = Uri.parse((String)uriText);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
            Uri uri2 = uri;
            Intent sendIntent = new Intent("android.intent.action.SENDTO");
            sendIntent.setData(uri2);
            try {
                $this$sendFlexaReport_u24lambda_u2417.startActivity(Intent.createChooser((Intent)sendIntent, (CharSequence)$this$sendFlexaReport_u24lambda_u2417.getString(R.string.send_email)));
                n = Unit.INSTANCE;
            }
            catch (ActivityNotFoundException ex) {
                n = Log.e(null, (String)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static /* synthetic */ void sendFlexaReport$default(Activity activity, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        ExtensionsKt.sendFlexaReport(activity, string2);
    }

    public static final boolean hasLimits(@NotNull Account $this$hasLimits) {
        Intrinsics.checkNotNullParameter((Object)$this$hasLimits, (String)"<this>");
        Collection collection = $this$hasLimits.getLimits();
        return !(collection == null || collection.isEmpty());
    }

    public static final float getLimitsPercentage(@NotNull Account $this$getLimitsPercentage) {
        Intrinsics.checkNotNullParameter((Object)$this$getLimitsPercentage, (String)"<this>");
        Collection collection = $this$getLimitsPercentage.getLimits();
        if (collection == null || collection.isEmpty()) {
            return 0.0f;
        }
        Limit limit = (Limit)CollectionsKt.firstOrNull($this$getLimitsPercentage.getLimits());
        Object object = limit;
        float overall = object != null && (object = ((Limit)object).getAmount()) != null && (object = StringsKt.toFloatOrNull((String)object)) != null ? ((Float)object).floatValue() : 0.0f;
        Object object2 = limit;
        float remaining = object2 != null && (object2 = ((Limit)object2).getRemaining()) != null && (object2 = StringsKt.toFloatOrNull((String)object2)) != null ? ((Float)object2).floatValue() : 0.0f;
        return remaining / overall;
    }

    @Nullable
    public static final String getJoinedYear(@NotNull Account $this$getJoinedYear) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getJoinedYear, (String)"<this>");
        if ($this$getJoinedYear.getCreated() != null) {
            Long timestamp = $this$getJoinedYear.getCreated();
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.systemDefault());
            int year = dateTime.getYear();
            string2 = String.valueOf(year);
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public static final String getResetDay(@NotNull Account $this$getResetDay) {
        Intrinsics.checkNotNullParameter((Object)$this$getResetDay, (String)"<this>");
        List<Limit> list = $this$getResetDay.getLimits();
        long timestamp = list != null && (list = (Limit)CollectionsKt.firstOrNull(list)) != null && (list = ((Limit)((Object)list)).getResetsAt()) != null ? ((Long)((Object)list)).longValue() : Instant.now().toEpochMilli();
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE");
        String formattedDateTime = dateTime.format(formatter);
        Intrinsics.checkNotNull((Object)formattedDateTime);
        return formattedDateTime;
    }

    @NotNull
    public static final String getResetHour(@NotNull Account $this$getResetHour) {
        Intrinsics.checkNotNullParameter((Object)$this$getResetHour, (String)"<this>");
        List<Limit> list = $this$getResetHour.getLimits();
        long timestamp = list != null && (list = (Limit)CollectionsKt.firstOrNull(list)) != null && (list = ((Limit)((Object)list)).getResetsAt()) != null ? ((Long)((Object)list)).longValue() : Instant.now().toEpochMilli();
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("h:mm a");
        String formattedDateTime = dateTime.format(formatter);
        Intrinsics.checkNotNull((Object)formattedDateTime);
        return formattedDateTime;
    }
}

