/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flexa.core.data.db.BrandSession;
import com.flexa.core.data.db.BrandSessionDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BrandSessionDao_Impl
implements BrandSessionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<BrandSession> __insertionAdapterOfBrandSession;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteOutdated;

    public BrandSessionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfBrandSession = new EntityInsertionAdapter<BrandSession>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `brand_session` (`session_id`,`transaction_id`,`date`,`legacy`) VALUES (?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull BrandSession entity) {
                if (entity.getSessionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindString(1, entity.getSessionId());
                }
                if (entity.getTransactionId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getTransactionId());
                }
                statement.bindLong(3, entity.getDate());
                int _tmp = entity.getLegacy() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM brand_session";
                return "DELETE FROM brand_session";
            }
        };
        this.__preparedStmtOfDeleteOutdated = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM brand_session WHERE date < strftime('%s', 'now')";
                return "DELETE FROM brand_session WHERE date < strftime('%s', 'now')";
            }
        };
    }

    @Override
    public void insert(BrandSession item) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBrandSession.insert((Object)item);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public void deleteOutdated() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteOutdated.acquire();
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfDeleteOutdated.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BrandSession> getBySessionId(String sessionId) {
        String _sql = "SELECT * FROM brand_session WHERE session_id IN (?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM brand_session WHERE session_id IN (?)", (int)1);
        int _argIndex = 1;
        if (sessionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, sessionId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"session_id");
            int _cursorIndexOfTransactionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transaction_id");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfLegacy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"legacy");
            ArrayList<BrandSession> _result = new ArrayList<BrandSession>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpSessionId = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                String _tmpTransactionId = _cursor.isNull(_cursorIndexOfTransactionId) ? null : _cursor.getString(_cursorIndexOfTransactionId);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                int _tmp = _cursor.getInt(_cursorIndexOfLegacy);
                boolean _tmpLegacy = _tmp != 0;
                BrandSession _item = new BrandSession(_tmpSessionId, _tmpTransactionId, _tmpDate, _tmpLegacy);
                _result.add(_item);
            }
            ArrayList<BrandSession> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String ... sessionId) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM brand_session WHERE session_id IN (");
        int _inputSize = sessionId.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : sessionId) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

