/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.storage;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKeys;
import com.flexa.core.data.storage.SecuredPreferences;
import com.flexa.core.domain.data.IDataRepository;
import com.flexa.core.shared.SerializerProvider;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u001c\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0007H\u0002J\r\u0010!\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\"J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$2\u0006\u0010\u0016\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010%J\u001d\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010$2\u0006\u0010\u0016\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b(J\u0012\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u000f\u0010*\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b+J\u0016\u0010,\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010%J,\u0010-\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010.\u001a\u0002H\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u001fH\u0096@\u00a2\u0006\u0002\u00102J\u0017\u00103\u001a\u00020\u00102\b\u0010.\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b7J$\u00108\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00070$H\u0096@\u00a2\u0006\u0002\u00109J\u001e\u0010:\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010;J\u0018\u0010<\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0007H\u0016J\u0015\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b?R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/flexa/core/data/storage/SecuredPreferences;", "Lcom/flexa/core/domain/data/IDataRepository;", "application", "Landroid/app/Application;", "serializerProvider", "Lcom/flexa/core/shared/SerializerProvider;", "fileName", "", "(Landroid/app/Application;Lcom/flexa/core/shared/SerializerProvider;Ljava/lang/String;)V", "preferences", "Landroid/content/SharedPreferences;", "getPreferences", "()Landroid/content/SharedPreferences;", "preferences$delegate", "Lkotlin/Lazy;", "clearPreferences", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "edit", "Landroid/content/SharedPreferences$Editor;", "get", "T", "key", "type", "Ljava/lang/reflect/Type;", "(Ljava/lang/String;Ljava/lang/reflect/Type;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEncryptedSharedPreferences", "context", "Landroid/content/Context;", "masterKeyAlias", "getLongSynchronously", "", "getMasterKey", "getPublishableKey", "getPublishableKey$core_release", "getSet", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getString", "getStringSet", "getStringSet$core_release", "getStringSynchronously", "getUniqueIdentifier", "getUniqueIdentifier$core_release", "remove", "save", "data", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/reflect/Type;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveLong", "value", "(Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "savePlacesToPayTheme", "savePlacesToPayTheme$core_release", "savePublishableKey", "publishableKey", "savePublishableKey$core_release", "saveSet", "(Ljava/lang/String;Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveString", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveStringSynchronous", "saveUniqueIdentifier", "uniqueIdentifier", "saveUniqueIdentifier$core_release", "core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSecuredPreferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecuredPreferences.kt\ncom/flexa/core/data/storage/SecuredPreferences\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class SecuredPreferences
implements IDataRepository {
    @NotNull
    private final Application application;
    @NotNull
    private final SerializerProvider serializerProvider;
    @NotNull
    private final String fileName;
    @NotNull
    private final Lazy preferences$delegate;
    public static final int $stable = 8;

    public SecuredPreferences(@NotNull Application application, @NotNull SerializerProvider serializerProvider, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.application = application;
        this.serializerProvider = serializerProvider;
        this.fileName = fileName;
        this.preferences$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ SecuredPreferences this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SharedPreferences invoke() {
                SharedPreferences sharedPreferences;
                try {
                    String masterKey = SecuredPreferences.access$getMasterKey(this.this$0);
                    Context context = SecuredPreferences.access$getApplication$p(this.this$0).getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                    sharedPreferences = SecuredPreferences.access$getEncryptedSharedPreferences(this.this$0, context, SecuredPreferences.access$getFileName$p(this.this$0), masterKey);
                }
                catch (Exception ex) {
                    Object $this$invoke_u24lambda_u240;
                    Log.e(null, (String)ex.getMessage(), (Throwable)ex);
                    Object object = this.this$0;
                    try {
                        $this$invoke_u24lambda_u240 = object;
                        boolean bl = false;
                        SecuredPreferences.access$getApplication$p((SecuredPreferences)$this$invoke_u24lambda_u240).deleteSharedPreferences(SecuredPreferences.access$getFileName$p((SecuredPreferences)$this$invoke_u24lambda_u240));
                        String masterKey = SecuredPreferences.access$getMasterKey((SecuredPreferences)$this$invoke_u24lambda_u240);
                        Context context = SecuredPreferences.access$getApplication$p((SecuredPreferences)$this$invoke_u24lambda_u240).getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                        $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)SecuredPreferences.access$getEncryptedSharedPreferences((SecuredPreferences)$this$invoke_u24lambda_u240, context, SecuredPreferences.access$getFileName$p((SecuredPreferences)$this$invoke_u24lambda_u240), masterKey));
                    }
                    catch (Throwable bl) {
                        $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object = $this$invoke_u24lambda_u240;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        Throwable it = throwable;
                        boolean bl = false;
                        Log.e(null, (String)it.getMessage(), (Throwable)it);
                        throw new Error("EncryptedSharedPreferences error");
                    }
                    sharedPreferences = (SharedPreferences)object;
                }
                return sharedPreferences;
            }
        }));
    }

    private final SharedPreferences getPreferences() {
        Lazy lazy = this.preferences$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    public final void savePlacesToPayTheme$core_release(@Nullable String data) {
        if (data != null) {
            this.getPreferences().edit().putString("places.to.pay.theme", data).apply();
        } else {
            this.getPreferences().edit().remove("places.to.pay.theme").apply();
        }
    }

    public final void savePublishableKey$core_release(@NotNull String publishableKey) {
        Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
        this.getPreferences().edit().putString("publishable.key", publishableKey).commit();
    }

    @NotNull
    public final String getPublishableKey$core_release() {
        String string2 = this.getPreferences().getString("publishable.key", "");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public final void saveUniqueIdentifier$core_release(@NotNull String uniqueIdentifier) {
        Intrinsics.checkNotNullParameter((Object)uniqueIdentifier, (String)"uniqueIdentifier");
        this.getPreferences().edit().putString("unique.identifier", uniqueIdentifier).commit();
    }

    @Nullable
    public final String getUniqueIdentifier$core_release() {
        return this.getPreferences().getString("unique.identifier", null);
    }

    @Nullable
    public final Set<String> getStringSet$core_release(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getPreferences().getStringSet(key, null);
    }

    @Override
    @Nullable
    public <T> Object save(@NotNull String key, T data, @NotNull Type type, @NotNull Continuation<? super Unit> $completion) {
        block0: {
            String raw;
            String string2 = raw = this.serializerProvider.getJson().toJson(data, type);
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            Boxing.boxBoolean((boolean)this.getPreferences().edit().putString(key, it).commit());
        }
        return Unit.INSTANCE;
    }

    @Override
    public void saveStringSynchronous(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getPreferences().edit().putString(key, value).commit();
    }

    @Override
    @Nullable
    public String getStringSynchronously(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getPreferences().getString(key, null);
    }

    @Override
    @Nullable
    public Object getString(@NotNull String key, @NotNull Continuation<? super String> $completion) {
        return this.getStringSynchronously(key);
    }

    @Override
    @Nullable
    public Object saveString(@NotNull String key, @NotNull String value, @NotNull Continuation<? super Unit> $completion) {
        this.saveStringSynchronous(key, value);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object saveLong(@NotNull String key, long value, @NotNull Continuation<? super Unit> $completion) {
        this.getPreferences().edit().putLong(key, value).commit();
        return Unit.INSTANCE;
    }

    @Override
    public long getLongSynchronously(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getPreferences().getLong(key, Long.MIN_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public <T> Object get(@NotNull String var1_1, @NotNull Type var2_2, @NotNull Continuation<? super T> var3_3) {
        if (!(var3_3 instanceof get.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SecuredPreferences this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.get(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = type;
                $continuation.label = 1;
                v0 = this.getString((String)key, (Continuation<? super String>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                type = (Type)$continuation.L$1;
                this = (SecuredPreferences)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                raw = (String)v0;
                try {
                    var5_8 = this.serializerProvider.getJson().fromJson(raw, type);
                }
                catch (JsonSyntaxException e) {
                    Log.w((String)SecuredPreferences.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
                    var5_8 = null;
                }
                return var5_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object remove(@NotNull String key, @NotNull Continuation<? super Unit> $completion) {
        this.getPreferences().edit().remove(key).commit();
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object clearPreferences(@NotNull Continuation<? super Unit> $completion) {
        this.application.getSharedPreferences(this.fileName, 0).edit().clear().commit();
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object saveSet(@NotNull String key, @NotNull Set<String> value, @NotNull Continuation<? super Unit> $completion) {
        this.getPreferences().edit().putStringSet(key, value).commit();
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getSet(@NotNull String key, @NotNull Continuation<? super Set<String>> $completion) {
        Set set = this.getPreferences().getStringSet(key, SetsKt.emptySet());
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    @NotNull
    public SharedPreferences.Editor edit() {
        SharedPreferences.Editor editor = this.getPreferences().edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"edit(...)");
        return editor;
    }

    private final String getMasterKey() {
        String string2 = MasterKeys.getOrCreate((KeyGenParameterSpec)MasterKeys.AES256_GCM_SPEC);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOrCreate(...)");
        return string2;
    }

    private final SharedPreferences getEncryptedSharedPreferences(Context context, String fileName, String masterKeyAlias) {
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((String)fileName, (String)masterKeyAlias, (Context)context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(...)");
        return sharedPreferences;
    }

    public static final /* synthetic */ String access$getMasterKey(SecuredPreferences $this) {
        return $this.getMasterKey();
    }

    public static final /* synthetic */ SharedPreferences access$getEncryptedSharedPreferences(SecuredPreferences $this, Context context, String fileName, String masterKeyAlias) {
        return $this.getEncryptedSharedPreferences(context, fileName, masterKeyAlias);
    }

    public static final /* synthetic */ Application access$getApplication$p(SecuredPreferences $this) {
        return $this.application;
    }

    public static final /* synthetic */ String access$getFileName$p(SecuredPreferences $this) {
        return $this.fileName;
    }
}

