/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.data;

import android.content.Context;
import android.content.Intent;
import android.util.Base64;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.flexa.core.Flexa;
import com.flexa.core.data.data.PikSeeProvider;
import com.flexa.core.data.rest.HeadersBundle;
import com.flexa.core.data.rest.RestRepository;
import com.flexa.core.data.storage.SecuredPreferences;
import com.flexa.core.domain.data.ITokenProvider;
import com.flexa.core.entity.TokenPatch;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001fH\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00050\u00050\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/flexa/core/data/data/TokenProvider;", "Lcom/flexa/core/domain/data/ITokenProvider;", "preferences", "Lcom/flexa/core/data/storage/SecuredPreferences;", "tokenKey", "", "(Lcom/flexa/core/data/storage/SecuredPreferences;Ljava/lang/String;)V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "errorCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "getMutex", "()Lkotlinx/coroutines/sync/Mutex;", "getPreferences$core_release", "()Lcom/flexa/core/data/storage/SecuredPreferences;", "token", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "tokenExpiration", "Ljava/util/concurrent/atomic/AtomicLong;", "dropCache", "", "getRefreshToken", "headersBundle", "Lcom/flexa/core/data/rest/HeadersBundle;", "getToken", "getTokenExpiration", "", "saveToken", "setTokenExpiration", "timestamp", "core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTokenProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenProvider.kt\ncom/flexa/core/data/data/TokenProvider\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,155:1\n28#2,4:156\n1#3:160\n96#4:161\n*S KotlinDebug\n*F\n+ 1 TokenProvider.kt\ncom/flexa/core/data/data/TokenProvider\n*L\n88#1:156,4\n111#1:161\n*E\n"})
public final class TokenProvider
implements ITokenProvider {
    @NotNull
    private final SecuredPreferences preferences;
    @NotNull
    private final String tokenKey;
    @NotNull
    private final Mutex mutex;
    @NotNull
    private final AtomicInteger errorCounter;
    @NotNull
    private final AtomicLong tokenExpiration;
    @NotNull
    private final AtomicReference<String> token;
    public static final int $stable = 8;

    public TokenProvider(@NotNull SecuredPreferences preferences2, @NotNull String tokenKey) {
        Intrinsics.checkNotNullParameter((Object)preferences2, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)tokenKey, (String)"tokenKey");
        this.preferences = preferences2;
        this.tokenKey = tokenKey;
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.errorCounter = new AtomicInteger(0);
        this.tokenExpiration = new AtomicLong(Long.MIN_VALUE);
        this.token = new AtomicReference<String>("");
    }

    @NotNull
    public final SecuredPreferences getPreferences$core_release() {
        return this.preferences;
    }

    @NotNull
    public final Mutex getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - void declaration
     */
    private final OkHttpClient getClient() {
        void $this$_get_client__u24lambda_u240;
        HttpLoggingInterceptor httpLoggingInterceptor;
        HttpLoggingInterceptor httpLoggingInterceptor2 = httpLoggingInterceptor = new HttpLoggingInterceptor(null, 1, null);
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        boolean bl = false;
        $this$_get_client__u24lambda_u240.level(HttpLoggingInterceptor.Level.NONE);
        return builder.addInterceptor((Interceptor)httpLoggingInterceptor).build();
    }

    @Override
    public void dropCache() {
        this.errorCounter.set(0);
        this.tokenExpiration.set(Long.MIN_VALUE);
        this.token.set("");
    }

    @Override
    public long getTokenExpiration() {
        return this.tokenExpiration.updateAndGet(arg_0 -> TokenProvider.getTokenExpiration$lambda$1(this, arg_0));
    }

    @Override
    @NotNull
    public String getToken() {
        String string2 = this.token.updateAndGet(arg_0 -> TokenProvider.getToken$lambda$3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"updateAndGet(...)");
        return string2;
    }

    @Override
    public void saveToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.token.set(token);
        this.preferences.edit().putString(this.tokenKey, token).apply();
    }

    @Override
    @NotNull
    public String getRefreshToken(@NotNull HeadersBundle headersBundle2) {
        String string2;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)headersBundle2, (String)"headersBundle");
        HttpUrl url = new HttpUrl.Builder().scheme("https").host(RestRepository.Companion.getHost()).addPathSegment("tokens").build();
        String verifier = this.preferences.getStringSynchronously("verifier");
        String newVerifier = PikSeeProvider.Companion.getCodeVerifier();
        String challenge = PikSeeProvider.Companion.getCodeChallenge(newVerifier);
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$getRefreshToken_u24lambda_u244 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$getRefreshToken_u24lambda_u244, (String)"challenge", (String)challenge);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$getRefreshToken_u24lambda_u244, (String)"verifier", (String)verifier);
        JsonObject $this$getRefreshToken_u24lambda_u245 = builder$iv.build();
        boolean $i$a$-run-TokenProvider$getRefreshToken$body$32 = false;
        RequestBody body = RequestBody.Companion.create($this$getRefreshToken_u24lambda_u245.toString(), RestRepository.Companion.getMediaType());
        String oldToken = this.getToken();
        String $i$a$-run-TokenProvider$getRefreshToken$body$32 = ':' + oldToken;
        byte[] byArray = $i$a$-run-TokenProvider$getRefreshToken$body$32.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String tokenBase64 = Base64.encodeToString((byte[])byArray, (int)2);
        Request.Builder builder = new Request.Builder().url(url).header("Accept", "application/vnd.flexa+json").header("Flexa-App", headersBundle2.getAppName()).header("Flexa-Version", headersBundle2.getVersion()).header("User-Agent", headersBundle2.getUserAgent()).header("Authorization", "Basic " + tokenBase64);
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        Request request = builder.header("client-trace-id", string3).post(body).build();
        try {
            Object this_$iv;
            Response response = this.getClient().newCall(request).execute();
            ResponseBody responseBody = response.body();
            String raw = String.valueOf(responseBody != null ? responseBody.string() : null);
            try {
                this_$iv = RestRepository.Companion.getJson();
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                this_$iv = (TokenPatch)this_$iv.decodeFromString((DeserializationStrategy)TokenPatch.Companion.serializer(), raw);
            }
            catch (Exception e) {
                this_$iv = new TokenPatch("", "", "", 0L);
            }
            Object tokenResponse = this_$iv;
            String token = ((TokenPatch)tokenResponse).getValue();
            if (!StringsKt.isBlank((CharSequence)token)) {
                this.saveToken(token);
                this.setTokenExpiration(((TokenPatch)tokenResponse).getExpiration());
                this.errorCounter.set(0);
                this.preferences.saveStringSynchronous("verifier", newVerifier);
                Context context = Flexa.INSTANCE.getContext();
                if (context != null) {
                    Context it = context;
                    boolean bl2 = false;
                    Intent intent = new Intent(this.preferences.getPublishableKey$core_release());
                    intent.putExtra("token", true);
                    it.sendBroadcast(intent);
                }
            } else if (this.errorCounter.incrementAndGet() >= 3) {
                Context context = Flexa.INSTANCE.getContext();
                if (context != null) {
                    Context it = context;
                    boolean bl3 = false;
                    Intent intent = new Intent(this.preferences.getPublishableKey$core_release());
                    intent.putExtra("token", false);
                    it.sendBroadcast(intent);
                }
            }
            string2 = token;
        }
        catch (Exception e) {
            Log.e((String)"TAG", (String)"getRefreshToken: ", (Throwable)e);
            string2 = "";
        }
        String token = string2;
        Log.d((String)TokenProvider.class.getSimpleName(), (String)("refreshed token: \ud83c\udfc1: " + token + " thread: " + Thread.currentThread().getId() + " hash:" + this.hashCode()));
        return token;
    }

    private final void setTokenExpiration(long timestamp) {
        this.tokenExpiration.set(timestamp);
        this.preferences.edit().putLong("token.expiration", timestamp).apply();
    }

    private static final long getTokenExpiration$lambda$1(TokenProvider this$0, long time) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return time == Long.MIN_VALUE ? this$0.preferences.getLongSynchronously("token.expiration") : time;
    }

    private static final String getToken$lambda$3(TokenProvider this$0, String it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CharSequence charSequence2 = it;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = this$0.preferences.getStringSynchronously(this$0.tokenKey);
            if (charSequence == null) {
                charSequence = "";
            }
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }
}

