/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flexa.core.data.db.Brand;
import com.flexa.core.data.db.BrandDao;
import com.flexa.core.data.db.ObjectListsConverter;
import com.flexa.core.shared.LegacyFlexcode;
import com.flexa.core.shared.Promotion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BrandDao_Impl
implements BrandDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Brand> __insertionAdapterOfBrand;
    private final ObjectListsConverter __objectListsConverter = new ObjectListsConverter();
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public BrandDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfBrand = new EntityInsertionAdapter<Brand>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `brand` (`id`,`category_name`,`color`,`legacy_flexcodes`,`promotions`,`logo_url`,`name`,`slug`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Brand entity) {
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindString(1, entity.getId());
                }
                if (entity.getCategoryName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getCategoryName());
                }
                if (entity.getColor() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getColor());
                }
                String _tmp = BrandDao_Impl.this.__objectListsConverter.fromLegacyFlexcode(entity.getLegacyFlexcodes());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, _tmp);
                }
                String _tmp_1 = BrandDao_Impl.this.__objectListsConverter.fromPromotion(entity.getPromotions());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, _tmp_1);
                }
                if (entity.getLogoUrl() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getLogoUrl());
                }
                if (entity.getName() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getName());
                }
                if (entity.getSlug() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getSlug());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getStatus());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM brand";
                return "DELETE FROM brand";
            }
        };
    }

    @Override
    public void insertAll(List<Brand> items) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBrand.insert(items);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Brand> getAll() {
        String _sql = "SELECT * FROM brand";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM brand", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfCategoryName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"category_name");
            int _cursorIndexOfColor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"color");
            int _cursorIndexOfLegacyFlexcodes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"legacy_flexcodes");
            int _cursorIndexOfPromotions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"promotions");
            int _cursorIndexOfLogoUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logo_url");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfSlug = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"slug");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            ArrayList<Brand> _result = new ArrayList<Brand>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmpCategoryName = _cursor.isNull(_cursorIndexOfCategoryName) ? null : _cursor.getString(_cursorIndexOfCategoryName);
                String _tmpColor = _cursor.isNull(_cursorIndexOfColor) ? null : _cursor.getString(_cursorIndexOfColor);
                String _tmp = _cursor.isNull(_cursorIndexOfLegacyFlexcodes) ? null : _cursor.getString(_cursorIndexOfLegacyFlexcodes);
                List<LegacyFlexcode> _tmpLegacyFlexcodes = this.__objectListsConverter.toLegacyFlexcode(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfPromotions) ? null : _cursor.getString(_cursorIndexOfPromotions);
                List<Promotion> _tmpPromotions = this.__objectListsConverter.toPromotion(_tmp_1);
                String _tmpLogoUrl = _cursor.isNull(_cursorIndexOfLogoUrl) ? null : _cursor.getString(_cursorIndexOfLogoUrl);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpSlug = _cursor.isNull(_cursorIndexOfSlug) ? null : _cursor.getString(_cursorIndexOfSlug);
                String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                Brand _item = new Brand(_tmpId, _tmpCategoryName, _tmpColor, _tmpLegacyFlexcodes, _tmpPromotions, _tmpLogoUrl, _tmpName, _tmpSlug, _tmpStatus);
                _result.add(_item);
            }
            ArrayList<Brand> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

