/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.rest;

import android.util.Base64;
import androidx.compose.runtime.internal.StabilityInferred;
import com.flexa.core.data.data.TokenProvider;
import com.flexa.core.data.rest.FlexaInterceptor;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/flexa/core/data/rest/LoginInterceptor;", "Lcom/flexa/core/data/rest/FlexaInterceptor;", "tokenProvider", "Lcom/flexa/core/data/data/TokenProvider;", "(Lcom/flexa/core/data/data/TokenProvider;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "newRequestWithAccessToken", "Lokhttp3/Request;", "request", "token", "", "core_release"})
@StabilityInferred(parameters=0)
public final class LoginInterceptor
extends FlexaInterceptor {
    @NotNull
    private final TokenProvider tokenProvider;
    public static final int $stable = 8;

    public LoginInterceptor(@NotNull TokenProvider tokenProvider2) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider2, (String)"tokenProvider");
        this.tokenProvider = tokenProvider2;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        String token = this.tokenProvider.getToken();
        Request request = this.newRequestWithAccessToken(chain.request(), token);
        Response response = chain.proceed(request);
        this.checkResponse(response);
        return response;
    }

    private final Request newRequestWithAccessToken(Request request, String token) {
        String string2 = ':' + token;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String tokenBase64 = Base64.encodeToString((byte[])byArray, (int)2);
        Request.Builder builder = request.newBuilder().header("Accept", "application/vnd.flexa+json").header("Flexa-App", this.getHeadersBundle().getAppName()).header("Flexa-Version", this.getHeadersBundle().getVersion()).header("User-Agent", this.getHeadersBundle().getUserAgent()).header("Content-Type", "application/json").header("Authorization", "Basic " + tokenBase64);
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return builder.header("client-trace-id", string3).build();
    }
}

