package com.flexa.core.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flexa.core.entity.TransactionFeePrice;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SuppressWarnings({"unchecked", "deprecation"})
public final class TransactionFeeDao_Impl implements TransactionFeeDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<TransactionFee> __insertionAdapterOfTransactionFee;

  private final ObjectConverters __objectConverters = new ObjectConverters();

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public TransactionFeeDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfTransactionFee = new EntityInsertionAdapter<TransactionFee>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `transaction_fee` (`amount`,`asset`,`expires_at`,`label`,`price`,`transaction_asset`,`zone`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final TransactionFee entity) {
        if (entity.getAmount() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getAmount());
        }
        if (entity.getAsset() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getAsset());
        }
        if (entity.getExpiresAt() == null) {
          statement.bindNull(3);
        } else {
          statement.bindLong(3, entity.getExpiresAt());
        }
        if (entity.getLabel() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getLabel());
        }
        final String _tmp = __objectConverters.fromTransactionFeePrice(entity.getPrice());
        if (_tmp == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp);
        }
        if (entity.getTransactionAsset() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getTransactionAsset());
        }
        if (entity.getZone() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getZone());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM transaction_fee";
        return _query;
      }
    };
  }

  @Override
  public void insertAll(final List<TransactionFee> items) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfTransactionFee.insert(items);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public List<TransactionFee> getAll() {
    final String _sql = "SELECT * FROM transaction_fee";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfAmount = CursorUtil.getColumnIndexOrThrow(_cursor, "amount");
      final int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "asset");
      final int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow(_cursor, "expires_at");
      final int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow(_cursor, "label");
      final int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow(_cursor, "price");
      final int _cursorIndexOfTransactionAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "transaction_asset");
      final int _cursorIndexOfZone = CursorUtil.getColumnIndexOrThrow(_cursor, "zone");
      final List<TransactionFee> _result = new ArrayList<TransactionFee>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final TransactionFee _item;
        final String _tmpAmount;
        if (_cursor.isNull(_cursorIndexOfAmount)) {
          _tmpAmount = null;
        } else {
          _tmpAmount = _cursor.getString(_cursorIndexOfAmount);
        }
        final String _tmpAsset;
        if (_cursor.isNull(_cursorIndexOfAsset)) {
          _tmpAsset = null;
        } else {
          _tmpAsset = _cursor.getString(_cursorIndexOfAsset);
        }
        final Long _tmpExpiresAt;
        if (_cursor.isNull(_cursorIndexOfExpiresAt)) {
          _tmpExpiresAt = null;
        } else {
          _tmpExpiresAt = _cursor.getLong(_cursorIndexOfExpiresAt);
        }
        final String _tmpLabel;
        if (_cursor.isNull(_cursorIndexOfLabel)) {
          _tmpLabel = null;
        } else {
          _tmpLabel = _cursor.getString(_cursorIndexOfLabel);
        }
        final TransactionFeePrice _tmpPrice;
        final String _tmp;
        if (_cursor.isNull(_cursorIndexOfPrice)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getString(_cursorIndexOfPrice);
        }
        _tmpPrice = __objectConverters.toTransactionFeePrice(_tmp);
        final String _tmpTransactionAsset;
        if (_cursor.isNull(_cursorIndexOfTransactionAsset)) {
          _tmpTransactionAsset = null;
        } else {
          _tmpTransactionAsset = _cursor.getString(_cursorIndexOfTransactionAsset);
        }
        final String _tmpZone;
        if (_cursor.isNull(_cursorIndexOfZone)) {
          _tmpZone = null;
        } else {
          _tmpZone = _cursor.getString(_cursorIndexOfZone);
        }
        _item = new TransactionFee(_tmpAmount,_tmpAsset,_tmpExpiresAt,_tmpLabel,_tmpPrice,_tmpTransactionAsset,_tmpZone);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public TransactionFee getByTransactionAssetID(final String id) {
    final String _sql = "SELECT * FROM transaction_fee WHERE transaction_asset = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfAmount = CursorUtil.getColumnIndexOrThrow(_cursor, "amount");
      final int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "asset");
      final int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow(_cursor, "expires_at");
      final int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow(_cursor, "label");
      final int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow(_cursor, "price");
      final int _cursorIndexOfTransactionAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "transaction_asset");
      final int _cursorIndexOfZone = CursorUtil.getColumnIndexOrThrow(_cursor, "zone");
      final TransactionFee _result;
      if (_cursor.moveToFirst()) {
        final String _tmpAmount;
        if (_cursor.isNull(_cursorIndexOfAmount)) {
          _tmpAmount = null;
        } else {
          _tmpAmount = _cursor.getString(_cursorIndexOfAmount);
        }
        final String _tmpAsset;
        if (_cursor.isNull(_cursorIndexOfAsset)) {
          _tmpAsset = null;
        } else {
          _tmpAsset = _cursor.getString(_cursorIndexOfAsset);
        }
        final Long _tmpExpiresAt;
        if (_cursor.isNull(_cursorIndexOfExpiresAt)) {
          _tmpExpiresAt = null;
        } else {
          _tmpExpiresAt = _cursor.getLong(_cursorIndexOfExpiresAt);
        }
        final String _tmpLabel;
        if (_cursor.isNull(_cursorIndexOfLabel)) {
          _tmpLabel = null;
        } else {
          _tmpLabel = _cursor.getString(_cursorIndexOfLabel);
        }
        final TransactionFeePrice _tmpPrice;
        final String _tmp;
        if (_cursor.isNull(_cursorIndexOfPrice)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getString(_cursorIndexOfPrice);
        }
        _tmpPrice = __objectConverters.toTransactionFeePrice(_tmp);
        final String _tmpTransactionAsset;
        if (_cursor.isNull(_cursorIndexOfTransactionAsset)) {
          _tmpTransactionAsset = null;
        } else {
          _tmpTransactionAsset = _cursor.getString(_cursorIndexOfTransactionAsset);
        }
        final String _tmpZone;
        if (_cursor.isNull(_cursorIndexOfZone)) {
          _tmpZone = null;
        } else {
          _tmpZone = _cursor.getString(_cursorIndexOfZone);
        }
        _result = new TransactionFee(_tmpAmount,_tmpAsset,_tmpExpiresAt,_tmpLabel,_tmpPrice,_tmpTransactionAsset,_tmpZone);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public TransactionFee getByAssetID(final String id) {
    final String _sql = "SELECT * FROM transaction_fee WHERE asset = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfAmount = CursorUtil.getColumnIndexOrThrow(_cursor, "amount");
      final int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "asset");
      final int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow(_cursor, "expires_at");
      final int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow(_cursor, "label");
      final int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow(_cursor, "price");
      final int _cursorIndexOfTransactionAsset = CursorUtil.getColumnIndexOrThrow(_cursor, "transaction_asset");
      final int _cursorIndexOfZone = CursorUtil.getColumnIndexOrThrow(_cursor, "zone");
      final TransactionFee _result;
      if (_cursor.moveToFirst()) {
        final String _tmpAmount;
        if (_cursor.isNull(_cursorIndexOfAmount)) {
          _tmpAmount = null;
        } else {
          _tmpAmount = _cursor.getString(_cursorIndexOfAmount);
        }
        final String _tmpAsset;
        if (_cursor.isNull(_cursorIndexOfAsset)) {
          _tmpAsset = null;
        } else {
          _tmpAsset = _cursor.getString(_cursorIndexOfAsset);
        }
        final Long _tmpExpiresAt;
        if (_cursor.isNull(_cursorIndexOfExpiresAt)) {
          _tmpExpiresAt = null;
        } else {
          _tmpExpiresAt = _cursor.getLong(_cursorIndexOfExpiresAt);
        }
        final String _tmpLabel;
        if (_cursor.isNull(_cursorIndexOfLabel)) {
          _tmpLabel = null;
        } else {
          _tmpLabel = _cursor.getString(_cursorIndexOfLabel);
        }
        final TransactionFeePrice _tmpPrice;
        final String _tmp;
        if (_cursor.isNull(_cursorIndexOfPrice)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getString(_cursorIndexOfPrice);
        }
        _tmpPrice = __objectConverters.toTransactionFeePrice(_tmp);
        final String _tmpTransactionAsset;
        if (_cursor.isNull(_cursorIndexOfTransactionAsset)) {
          _tmpTransactionAsset = null;
        } else {
          _tmpTransactionAsset = _cursor.getString(_cursorIndexOfTransactionAsset);
        }
        final String _tmpZone;
        if (_cursor.isNull(_cursorIndexOfZone)) {
          _tmpZone = null;
        } else {
          _tmpZone = _cursor.getString(_cursorIndexOfZone);
        }
        _result = new TransactionFee(_tmpAmount,_tmpAsset,_tmpExpiresAt,_tmpLabel,_tmpPrice,_tmpTransactionAsset,_tmpZone);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
