/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.db;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.room.Room;
import com.flexa.core.data.db.Asset;
import com.flexa.core.data.db.AssetDao;
import com.flexa.core.data.db.AssetDaoKt;
import com.flexa.core.data.db.Brand;
import com.flexa.core.data.db.BrandDao;
import com.flexa.core.data.db.BrandDaoKt;
import com.flexa.core.data.db.BrandSession;
import com.flexa.core.data.db.Database;
import com.flexa.core.data.db.ExchangeRate;
import com.flexa.core.data.db.ExchangeRateDao;
import com.flexa.core.data.db.ExchangeRateDaoKt;
import com.flexa.core.data.db.OneTimeKey;
import com.flexa.core.data.db.OneTimeKeyDao;
import com.flexa.core.data.db.OneTimeKeyDaoKt;
import com.flexa.core.data.db.TransactionFee;
import com.flexa.core.data.db.TransactionFeeDao;
import com.flexa.core.data.db.TransactionFeeDaoKt;
import com.flexa.core.domain.db.IDbRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0011\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0014\"\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0017\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0018\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0019\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001a\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\rH\u0096@\u00a2\u0006\u0002\u0010\tJ(\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0014\"\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\rH\u0096@\u00a2\u0006\u0002\u0010\tJ\u0018\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010!J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\rH\u0096@\u00a2\u0006\u0002\u0010\tJ\u0018\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010!J\u0018\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010+\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010,J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020)0\rH\u0096@\u00a2\u0006\u0002\u0010\tJ\u0018\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010&\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010!J\u0018\u00100\u001a\u0004\u0018\u00010/2\u0006\u0010&\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010!J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020/0\rH\u0096@\u00a2\u0006\u0002\u0010\tJ\u000e\u00102\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u000e\u00103\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u001c\u00104\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u00106\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020#0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u00107\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020%0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u00108\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020)0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020\u001fH\u0096@\u00a2\u0006\u0002\u0010;J\u001c\u0010<\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020/0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/flexa/core/data/db/DbRepository;", "Lcom/flexa/core/domain/db/IDbRepository;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "db", "Lcom/flexa/core/data/db/Database;", "clearAllTables", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "containsAllExchangeRates", "", "ids", "", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "containsAllOneTimeKeys", "deleteAssets", "deleteBrandSession", "sessionIds", "", "([Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteBrands", "deleteExchangeRates", "deleteOneTimeKeys", "deleteOutdatedSessions", "deleteTransactionFees", "getAssets", "Lcom/flexa/core/shared/Asset;", "getAssetsById", "getBrandSession", "Lcom/flexa/core/data/db/BrandSession;", "sessionId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBrands", "Lcom/flexa/core/shared/Brand;", "getExchangeRateById", "Lcom/flexa/core/entity/ExchangeRate;", "id", "getExchangeRates", "getOneTimeKeyByAssetId", "Lcom/flexa/core/entity/OneTimeKey;", "getOneTimeKeyByLiveMode", "livemode", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOneTimeKeys", "getTransactionFeeByAssetId", "Lcom/flexa/core/entity/TransactionFee;", "getTransactionFeeByTransactionAssetId", "getTransactionFees", "hasOutdatedExchangeRates", "hasOutdatedOneTimeKeys", "saveAssets", "items", "saveBrands", "saveExchangeRates", "saveOneTimeKeys", "saveTransaction", "brandSession", "(Lcom/flexa/core/data/db/BrandSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveTransactionFees", "core_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nDbRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbRepository.kt\ncom/flexa/core/data/db/DbRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1557#2:126\n1628#2,3:127\n1557#2:130\n1628#2,3:131\n1557#2:134\n1628#2,3:135\n1557#2:138\n1628#2,3:139\n1557#2:142\n1628#2,3:143\n1557#2:146\n1628#2,3:147\n1557#2:151\n1628#2,3:152\n1557#2:155\n1628#2,3:156\n1557#2:159\n1628#2,3:160\n1557#2:163\n1628#2,3:164\n1557#2:167\n1628#2,3:168\n1#3:150\n*S KotlinDebug\n*F\n+ 1 DbRepository.kt\ncom/flexa/core/data/db/DbRepository\n*L\n28#1:126\n28#1:127,3\n31#1:130\n31#1:131,3\n34#1:134\n34#1:135,3\n39#1:138\n39#1:139,3\n42#1:142\n42#1:143,3\n56#1:146\n56#1:147,3\n62#1:151\n62#1:152,3\n76#1:155\n76#1:156,3\n85#1:159\n85#1:160,3\n91#1:163\n91#1:164,3\n100#1:167\n100#1:168,3\n*E\n"})
public final class DbRepository
implements IDbRepository {
    @NotNull
    private final Database db;
    public static final int $stable;

    public DbRepository(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.db = (Database)Room.databaseBuilder((Context)context, Database.class, (String)"com.flexa").fallbackToDestructiveMigrationOnDowngrade().fallbackToDestructiveMigration().build();
    }

    @Override
    @Nullable
    public Object clearAllTables(@NotNull Continuation<? super Unit> $completion) {
        this.db.clearAllTables();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getAssets(@NotNull Continuation<? super List<com.flexa.core.shared.Asset>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.db.assetsDao().getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Asset asset = (Asset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AssetDaoKt.toObject((Asset)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getAssetsById(@NotNull String[] ids, @NotNull Continuation<? super List<com.flexa.core.shared.Asset>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.db.assetsDao().getByIds(Arrays.copyOf(ids, ids.length));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Asset asset = (Asset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AssetDaoKt.toObject((Asset)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object saveAssets(@NotNull List<com.flexa.core.shared.Asset> items, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = items;
        AssetDao assetDao = this.db.assetsDao();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.flexa.core.shared.Asset asset = (com.flexa.core.shared.Asset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AssetDaoKt.toDao((com.flexa.core.shared.Asset)it));
        }
        assetDao.insertAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deleteAssets(@NotNull Continuation<? super Unit> $completion) {
        this.db.assetsDao().deleteAll();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getBrands(@NotNull Continuation<? super List<com.flexa.core.shared.Brand>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.db.brandsDao().getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Brand brand = (Brand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BrandDaoKt.toObject((Brand)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object saveBrands(@NotNull List<com.flexa.core.shared.Brand> items, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = items;
        BrandDao brandDao = this.db.brandsDao();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.flexa.core.shared.Brand brand = (com.flexa.core.shared.Brand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BrandDaoKt.toDao((com.flexa.core.shared.Brand)it));
        }
        brandDao.insertAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object hasOutdatedExchangeRates(@NotNull Continuation<? super Boolean> $completion) {
        boolean empty = this.db.exchangeRateDao().getAll().isEmpty();
        boolean outdated = this.db.exchangeRateDao().hasOutdatedItems();
        return Boxing.boxBoolean((empty || outdated ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public Object containsAllExchangeRates(@NotNull List<String> ids, @NotNull Continuation<? super Boolean> $completion) {
        int count = this.db.exchangeRateDao().countIds(ids);
        return Boxing.boxBoolean((count == ids.size() ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getExchangeRates(@NotNull Continuation<? super List<com.flexa.core.entity.ExchangeRate>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.db.exchangeRateDao().getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExchangeRate exchangeRate = (ExchangeRate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ExchangeRateDaoKt.toObject((ExchangeRate)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object getExchangeRateById(@NotNull String id, @NotNull Continuation<? super com.flexa.core.entity.ExchangeRate> $completion) {
        com.flexa.core.entity.ExchangeRate exchangeRate;
        ExchangeRate exchangeRate2 = this.db.exchangeRateDao().getByIdl(id);
        if (exchangeRate2 != null) {
            ExchangeRate $this$getExchangeRateById_u24lambda_u246 = exchangeRate2;
            boolean bl = false;
            exchangeRate = ExchangeRateDaoKt.toObject($this$getExchangeRateById_u24lambda_u246);
        } else {
            exchangeRate = null;
        }
        return exchangeRate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object saveExchangeRates(@NotNull List<com.flexa.core.entity.ExchangeRate> items, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = items;
        ExchangeRateDao exchangeRateDao = this.db.exchangeRateDao();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.flexa.core.entity.ExchangeRate exchangeRate = (com.flexa.core.entity.ExchangeRate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ExchangeRateDaoKt.toDao((com.flexa.core.entity.ExchangeRate)it));
        }
        exchangeRateDao.insertAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object hasOutdatedOneTimeKeys(@NotNull Continuation<? super Boolean> $completion) {
        boolean empty = this.db.oneTimeKeyDao().getAll().isEmpty();
        boolean outdated = this.db.oneTimeKeyDao().hasOutdatedItems();
        return Boxing.boxBoolean((empty || outdated ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public Object containsAllOneTimeKeys(@NotNull List<String> ids, @NotNull Continuation<? super Boolean> $completion) {
        int count = this.db.oneTimeKeyDao().countIds(ids);
        return Boxing.boxBoolean((count == ids.size() ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getOneTimeKeys(@NotNull Continuation<? super List<com.flexa.core.entity.OneTimeKey>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.db.oneTimeKeyDao().getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OneTimeKey oneTimeKey = (OneTimeKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OneTimeKeyDaoKt.toObject((OneTimeKey)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object getOneTimeKeyByAssetId(@NotNull String id, @NotNull Continuation<? super com.flexa.core.entity.OneTimeKey> $completion) {
        com.flexa.core.entity.OneTimeKey oneTimeKey;
        OneTimeKey oneTimeKey2 = this.db.oneTimeKeyDao().getByAssetId(id);
        if (oneTimeKey2 != null) {
            OneTimeKey $this$getOneTimeKeyByAssetId_u24lambda_u249 = oneTimeKey2;
            boolean bl = false;
            oneTimeKey = OneTimeKeyDaoKt.toObject($this$getOneTimeKeyByAssetId_u24lambda_u249);
        } else {
            oneTimeKey = null;
        }
        return oneTimeKey;
    }

    @Override
    @Nullable
    public Object getOneTimeKeyByLiveMode(boolean livemode, @NotNull Continuation<? super com.flexa.core.entity.OneTimeKey> $completion) {
        com.flexa.core.entity.OneTimeKey oneTimeKey;
        OneTimeKey oneTimeKey2 = this.db.oneTimeKeyDao().getByLiveMode(livemode);
        if (oneTimeKey2 != null) {
            OneTimeKey $this$getOneTimeKeyByLiveMode_u24lambda_u2410 = oneTimeKey2;
            boolean bl = false;
            oneTimeKey = OneTimeKeyDaoKt.toObject($this$getOneTimeKeyByLiveMode_u24lambda_u2410);
        } else {
            oneTimeKey = null;
        }
        return oneTimeKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object saveOneTimeKeys(@NotNull List<com.flexa.core.entity.OneTimeKey> items, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = items;
        OneTimeKeyDao oneTimeKeyDao = this.db.oneTimeKeyDao();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.flexa.core.entity.OneTimeKey oneTimeKey = (com.flexa.core.entity.OneTimeKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OneTimeKeyDaoKt.toDao((com.flexa.core.entity.OneTimeKey)it));
        }
        oneTimeKeyDao.insertAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deleteOneTimeKeys(@NotNull Continuation<? super Unit> $completion) {
        this.db.oneTimeKeyDao().deleteAll();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getTransactionFees(@NotNull Continuation<? super List<com.flexa.core.entity.TransactionFee>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.db.transactionFeeDao().getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TransactionFee transactionFee = (TransactionFee)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TransactionFeeDaoKt.toObject((TransactionFee)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object getTransactionFeeByTransactionAssetId(@NotNull String id, @NotNull Continuation<? super com.flexa.core.entity.TransactionFee> $completion) {
        com.flexa.core.entity.TransactionFee transactionFee;
        TransactionFee transactionFee2 = this.db.transactionFeeDao().getByTransactionAssetID(id);
        if (transactionFee2 != null) {
            TransactionFee $this$getTransactionFeeByTransactionAssetId_u24lambda_u2413 = transactionFee2;
            boolean bl = false;
            transactionFee = TransactionFeeDaoKt.toObject($this$getTransactionFeeByTransactionAssetId_u24lambda_u2413);
        } else {
            transactionFee = null;
        }
        return transactionFee;
    }

    @Override
    @Nullable
    public Object getTransactionFeeByAssetId(@NotNull String id, @NotNull Continuation<? super com.flexa.core.entity.TransactionFee> $completion) {
        com.flexa.core.entity.TransactionFee transactionFee;
        TransactionFee transactionFee2 = this.db.transactionFeeDao().getByAssetID(id);
        if (transactionFee2 != null) {
            TransactionFee $this$getTransactionFeeByAssetId_u24lambda_u2414 = transactionFee2;
            boolean bl = false;
            transactionFee = TransactionFeeDaoKt.toObject($this$getTransactionFeeByAssetId_u24lambda_u2414);
        } else {
            transactionFee = null;
        }
        return transactionFee;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object saveTransactionFees(@NotNull List<com.flexa.core.entity.TransactionFee> items, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = items;
        TransactionFeeDao transactionFeeDao = this.db.transactionFeeDao();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.flexa.core.entity.TransactionFee transactionFee = (com.flexa.core.entity.TransactionFee)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TransactionFeeDaoKt.toDao((com.flexa.core.entity.TransactionFee)it));
        }
        transactionFeeDao.insertAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deleteTransactionFees(@NotNull Continuation<? super Unit> $completion) {
        this.db.transactionFeeDao().deleteAll();
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deleteExchangeRates(@NotNull Continuation<? super Unit> $completion) {
        this.db.exchangeRateDao().deleteAll();
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getBrandSession(@NotNull String sessionId, @NotNull Continuation<? super BrandSession> $completion) {
        return CollectionsKt.firstOrNull(this.db.brandSessionDao().getBySessionId(sessionId));
    }

    @Override
    @Nullable
    public Object deleteBrandSession(@NotNull String[] sessionIds, @NotNull Continuation<? super Unit> $completion) {
        this.db.brandSessionDao().deleteById(Arrays.copyOf(sessionIds, sessionIds.length));
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deleteOutdatedSessions(@NotNull Continuation<? super Unit> $completion) {
        this.db.brandSessionDao().deleteOutdated();
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object saveTransaction(@NotNull BrandSession brandSession, @NotNull Continuation<? super Unit> $completion) {
        this.db.brandSessionDao().insert(brandSession);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deleteBrands(@NotNull Continuation<? super Unit> $completion) {
        this.db.brandsDao().deleteAll();
        return Unit.INSTANCE;
    }
}

