/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.db;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.flexa.core.data.db.OneTimeKey;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\ba\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H'J\b\u0010\u0007\u001a\u00020\bH'J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H'J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0006H'J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH'J\b\u0010\u0010\u001a\u00020\u000fH'J\u0016\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H'\u00a8\u0006\u0013"}, d2={"Lcom/flexa/core/data/db/OneTimeKeyDao;", "", "countIds", "", "ids", "", "", "deleteAll", "", "getAll", "Lcom/flexa/core/data/db/OneTimeKey;", "getByAssetId", "id", "getByLiveMode", "livemode", "", "hasOutdatedItems", "insertAll", "items", "core_release"})
@Dao
public interface OneTimeKeyDao {
    @Query(value="SELECT * FROM one_time_key")
    @NotNull
    public List<OneTimeKey> getAll();

    @Query(value="SELECT COUNT(asset) FROM one_time_key WHERE asset IN (:ids)")
    public int countIds(@NotNull List<String> var1);

    @Query(value="SELECT * FROM one_time_key WHERE asset = :id LIMIT 1")
    @Nullable
    public OneTimeKey getByAssetId(@NotNull String var1);

    @Query(value="SELECT * FROM one_time_key WHERE livemode = :livemode LIMIT 1")
    @Nullable
    public OneTimeKey getByLiveMode(boolean var1);

    @Insert(onConflict=1)
    public void insertAll(@NotNull List<OneTimeKey> var1);

    @Query(value="DELETE FROM one_time_key")
    public void deleteAll();

    @Query(value="SELECT EXISTS(SELECT 1 FROM one_time_key WHERE expires_at < strftime('%s', 'now'))")
    public boolean hasOutdatedItems();
}

