/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.core.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flexa.core.data.db.ObjectConverters;
import com.flexa.core.data.db.TransactionFee;
import com.flexa.core.data.db.TransactionFeeDao;
import com.flexa.core.entity.TransactionFeePrice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TransactionFeeDao_Impl
implements TransactionFeeDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<TransactionFee> __insertionAdapterOfTransactionFee;
    private final ObjectConverters __objectConverters = new ObjectConverters();
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public TransactionFeeDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTransactionFee = new EntityInsertionAdapter<TransactionFee>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `transaction_fee` (`amount`,`asset`,`expires_at`,`label`,`price`,`transaction_asset`,`zone`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull TransactionFee entity) {
                if (entity.getAmount() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindString(1, entity.getAmount());
                }
                if (entity.getAsset() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getAsset());
                }
                if (entity.getExpiresAt() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindLong(3, entity.getExpiresAt().longValue());
                }
                if (entity.getLabel() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getLabel());
                }
                String _tmp = TransactionFeeDao_Impl.this.__objectConverters.fromTransactionFeePrice(entity.getPrice());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, _tmp);
                }
                if (entity.getTransactionAsset() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getTransactionAsset());
                }
                if (entity.getZone() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getZone());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM transaction_fee";
                return "DELETE FROM transaction_fee";
            }
        };
    }

    @Override
    public void insertAll(List<TransactionFee> items) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTransactionFee.insert(items);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TransactionFee> getAll() {
        String _sql = "SELECT * FROM transaction_fee";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM transaction_fee", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfAmount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amount");
            int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"asset");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expires_at");
            int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"label");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfTransactionAsset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transaction_asset");
            int _cursorIndexOfZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"zone");
            ArrayList<TransactionFee> _result = new ArrayList<TransactionFee>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpAmount = _cursor.isNull(_cursorIndexOfAmount) ? null : _cursor.getString(_cursorIndexOfAmount);
                String _tmpAsset = _cursor.isNull(_cursorIndexOfAsset) ? null : _cursor.getString(_cursorIndexOfAsset);
                Long _tmpExpiresAt = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpiresAt));
                String _tmpLabel = _cursor.isNull(_cursorIndexOfLabel) ? null : _cursor.getString(_cursorIndexOfLabel);
                String _tmp = _cursor.isNull(_cursorIndexOfPrice) ? null : _cursor.getString(_cursorIndexOfPrice);
                TransactionFeePrice _tmpPrice = this.__objectConverters.toTransactionFeePrice(_tmp);
                String _tmpTransactionAsset = _cursor.isNull(_cursorIndexOfTransactionAsset) ? null : _cursor.getString(_cursorIndexOfTransactionAsset);
                String _tmpZone = _cursor.isNull(_cursorIndexOfZone) ? null : _cursor.getString(_cursorIndexOfZone);
                TransactionFee _item = new TransactionFee(_tmpAmount, _tmpAsset, _tmpExpiresAt, _tmpLabel, _tmpPrice, _tmpTransactionAsset, _tmpZone);
                _result.add(_item);
            }
            ArrayList<TransactionFee> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionFee getByTransactionAssetID(String id) {
        String _sql = "SELECT * FROM transaction_fee WHERE transaction_asset = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM transaction_fee WHERE transaction_asset = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            TransactionFee _result;
            int _cursorIndexOfAmount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amount");
            int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"asset");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expires_at");
            int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"label");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfTransactionAsset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transaction_asset");
            int _cursorIndexOfZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"zone");
            if (_cursor.moveToFirst()) {
                String _tmpAmount = _cursor.isNull(_cursorIndexOfAmount) ? null : _cursor.getString(_cursorIndexOfAmount);
                String _tmpAsset = _cursor.isNull(_cursorIndexOfAsset) ? null : _cursor.getString(_cursorIndexOfAsset);
                Long _tmpExpiresAt = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpiresAt));
                String _tmpLabel = _cursor.isNull(_cursorIndexOfLabel) ? null : _cursor.getString(_cursorIndexOfLabel);
                String _tmp = _cursor.isNull(_cursorIndexOfPrice) ? null : _cursor.getString(_cursorIndexOfPrice);
                TransactionFeePrice _tmpPrice = this.__objectConverters.toTransactionFeePrice(_tmp);
                String _tmpTransactionAsset = _cursor.isNull(_cursorIndexOfTransactionAsset) ? null : _cursor.getString(_cursorIndexOfTransactionAsset);
                String _tmpZone = _cursor.isNull(_cursorIndexOfZone) ? null : _cursor.getString(_cursorIndexOfZone);
                _result = new TransactionFee(_tmpAmount, _tmpAsset, _tmpExpiresAt, _tmpLabel, _tmpPrice, _tmpTransactionAsset, _tmpZone);
            } else {
                _result = null;
            }
            TransactionFee transactionFee = _result;
            return transactionFee;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionFee getByAssetID(String id) {
        String _sql = "SELECT * FROM transaction_fee WHERE asset = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM transaction_fee WHERE asset = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            TransactionFee _result;
            int _cursorIndexOfAmount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amount");
            int _cursorIndexOfAsset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"asset");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expires_at");
            int _cursorIndexOfLabel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"label");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfTransactionAsset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transaction_asset");
            int _cursorIndexOfZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"zone");
            if (_cursor.moveToFirst()) {
                String _tmpAmount = _cursor.isNull(_cursorIndexOfAmount) ? null : _cursor.getString(_cursorIndexOfAmount);
                String _tmpAsset = _cursor.isNull(_cursorIndexOfAsset) ? null : _cursor.getString(_cursorIndexOfAsset);
                Long _tmpExpiresAt = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfExpiresAt));
                String _tmpLabel = _cursor.isNull(_cursorIndexOfLabel) ? null : _cursor.getString(_cursorIndexOfLabel);
                String _tmp = _cursor.isNull(_cursorIndexOfPrice) ? null : _cursor.getString(_cursorIndexOfPrice);
                TransactionFeePrice _tmpPrice = this.__objectConverters.toTransactionFeePrice(_tmp);
                String _tmpTransactionAsset = _cursor.isNull(_cursorIndexOfTransactionAsset) ? null : _cursor.getString(_cursorIndexOfTransactionAsset);
                String _tmpZone = _cursor.isNull(_cursorIndexOfZone) ? null : _cursor.getString(_cursorIndexOfZone);
                _result = new TransactionFee(_tmpAmount, _tmpAsset, _tmpExpiresAt, _tmpLabel, _tmpPrice, _tmpTransactionAsset, _tmpZone);
            } else {
                _result = null;
            }
            TransactionFee transactionFee = _result;
            return transactionFee;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

