/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.spend.data;

import androidx.compose.runtime.internal.StabilityInferred;
import com.flexa.spend.data.DeepLink;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/flexa/spend/data/DeepLinkParser;", "", "()V", "Companion", "spend_release"})
@StabilityInferred(parameters=1)
public final class DeepLinkParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String PREFIX = "^https?://[^/]+flexa\\.link";

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/flexa/spend/data/DeepLinkParser$Companion;", "", "()V", "PREFIX", "", "getDeepLink", "Lcom/flexa/spend/data/DeepLink;", "deepLink", "spend_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeepLink getDeepLink(@NotNull String deepLink) {
            DeepLink deepLink2;
            Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
            Regex accountRegex = new Regex("^https?://[^/]+flexa\\.link/account$");
            Regex dataAndPrivacyRegex = new Regex("^https?://[^/]+flexa\\.link/account/data$");
            Regex deleteAccountRegex = new Regex("^https?://[^/]+flexa\\.link/account/delete$");
            Regex placesToPayRegex = new Regex("^https?://[^/]+flexa\\.link/explore$");
            Regex brandsWebRegex = new Regex("^https?://[^/]+flexa\\.link/explore/(.+)$");
            Regex howToPayRegex = new Regex("^https?://[^/]+flexa\\.link/guides/how-to-pay$");
            Regex payRegex = new Regex("^https?://[^/]+flexa\\.link/pay$");
            Regex commerceSessionRegex = new Regex("^https?://[^/]+flexa\\.link/pay/(.+)$");
            Regex pinnedBrandsRegex = new Regex("^https?://[^/]+flexa\\.link/pinned$");
            Regex reportIssueRegex = new Regex("^https?://[^/]+flexa\\.link/report-an-issue$");
            Regex reportIssueBrandRegex = new Regex("^https?://[^/]+flexa\\.link/report-an-issue/(.+)$");
            Regex supportArticleRegex = new Regex("^https?://[^/]+flexa\\.link/support/(.+)$");
            Regex loginRegex = new Regex("^https?://[^/]+flexa\\.link/verify/(.+)$");
            if (accountRegex.matches((CharSequence)deepLink)) {
                deepLink2 = DeepLink.Account.INSTANCE;
            } else if (dataAndPrivacyRegex.matches((CharSequence)deepLink)) {
                deepLink2 = DeepLink.DataAndPrivacy.INSTANCE;
            } else if (deleteAccountRegex.matches((CharSequence)deepLink)) {
                deepLink2 = DeepLink.DeleteAccount.INSTANCE;
            } else if (placesToPayRegex.matches((CharSequence)deepLink)) {
                deepLink2 = DeepLink.PlacesToPay.INSTANCE;
            } else if (brandsWebRegex.matches((CharSequence)deepLink)) {
                MatchResult matchResult = Regex.find$default((Regex)brandsWebRegex, (CharSequence)deepLink, (int)0, (int)2, null);
                Object object = matchResult;
                if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                    object = "";
                }
                Object url = object;
                deepLink2 = new DeepLink.Brands((String)url);
            } else if (howToPayRegex.matches((CharSequence)deepLink)) {
                deepLink2 = DeepLink.HowToPay.INSTANCE;
            } else if (payRegex.matches((CharSequence)deepLink)) {
                deepLink2 = DeepLink.Pay.INSTANCE;
            } else if (commerceSessionRegex.matches((CharSequence)deepLink)) {
                MatchResult matchResult = Regex.find$default((Regex)commerceSessionRegex, (CharSequence)deepLink, (int)0, (int)2, null);
                Object object = matchResult;
                if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                    object = "";
                }
                Object url = object;
                deepLink2 = new DeepLink.CommerceSession((String)url);
            } else if (pinnedBrandsRegex.matches((CharSequence)deepLink)) {
                deepLink2 = DeepLink.PinnedBrands.INSTANCE;
            } else if (reportIssueRegex.matches((CharSequence)deepLink)) {
                deepLink2 = new DeepLink.ReportIssue(deepLink);
            } else if (reportIssueBrandRegex.matches((CharSequence)deepLink)) {
                MatchResult matchResult = Regex.find$default((Regex)reportIssueBrandRegex, (CharSequence)deepLink, (int)0, (int)2, null);
                Object object = matchResult;
                if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                    object = "";
                }
                Object url = object;
                deepLink2 = new DeepLink.ReportIssueBrand((String)url);
            } else if (supportArticleRegex.matches((CharSequence)deepLink)) {
                MatchResult matchResult = Regex.find$default((Regex)supportArticleRegex, (CharSequence)deepLink, (int)0, (int)2, null);
                Object object = matchResult;
                if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                    object = "";
                }
                Object url = object;
                deepLink2 = new DeepLink.SupportArticle((String)url);
            } else {
                deepLink2 = loginRegex.matches((CharSequence)deepLink) ? (DeepLink)new DeepLink.Login(deepLink) : (DeepLink)DeepLink.Unknown.INSTANCE;
            }
            return deepLink2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

