/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.spend.main.keypad;

import androidx.compose.runtime.internal.StabilityInferred;
import com.flexa.spend.main.keypad.Backspace;
import com.flexa.spend.main.keypad.InputState;
import com.flexa.spend.main.keypad.KeypadButton;
import com.flexa.spend.main.keypad.Point;
import com.flexa.spend.main.keypad.Symbol;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u0005J\u0006\u0010\u001f\u001a\u00020\u0005J\u0006\u0010 \u001a\u00020\u0005J\b\u0010!\u001a\u00020\u0016H\u0002R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/flexa/spend/main/keypad/Formatter;", "", "maxFraction", "", "prefix", "", "(BLjava/lang/String;)V", "data", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "dataAsFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "getDataAsFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "fractionRegex", "Lkotlin/text/Regex;", "oneDecimalRegex", "append", "", "button", "Lcom/flexa/spend/main/keypad/KeypadButton;", "containsFractions", "", "getInputData", "getInputState", "Lcom/flexa/spend/main/keypad/InputState;", "maxAmount", "", "minAmount", "amount", "getPrefix", "getSuffix", "getText", "hasOneDecimalDigit", "spend_release"})
@StabilityInferred(parameters=0)
public final class Formatter {
    @NotNull
    private final String prefix;
    @NotNull
    private final MutableStateFlow<String> dataAsFlow;
    @NotNull
    private final StringBuilder data;
    @NotNull
    private final Regex fractionRegex;
    @NotNull
    private final Regex oneDecimalRegex;
    public static final int $stable = 8;

    public Formatter(byte maxFraction, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        this.dataAsFlow = StateFlowKt.MutableStateFlow(null);
        this.data = new StringBuilder();
        this.fractionRegex = new Regex("\\.\\d{" + maxFraction + '}');
        this.oneDecimalRegex = new Regex("\\.\\d$");
    }

    public /* synthetic */ Formatter(byte by, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            by = (byte)2;
        }
        if ((n & 2) != 0) {
            string2 = "$";
        }
        this(by, string2);
    }

    @NotNull
    public final MutableStateFlow<String> getDataAsFlow() {
        return this.dataAsFlow;
    }

    @NotNull
    public final String getInputData(@NotNull KeypadButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        StringBuilder dataString = new StringBuilder(this.data.toString());
        KeypadButton keypadButton = button;
        if (keypadButton instanceof Backspace) {
            if (((CharSequence)dataString).length() > 0) {
                dataString.deleteCharAt(dataString.length() - 1);
            }
        } else if (keypadButton instanceof Point) {
            if (((CharSequence)dataString).length() == 0) {
                dataString.append('0' + ((Point)button).getSymbol());
            } else if (!StringsKt.contains$default((CharSequence)dataString, (CharSequence)((Point)button).getSymbol(), (boolean)false, (int)2, null)) {
                dataString.append(((Point)button).getSymbol());
            }
        } else if (keypadButton instanceof Symbol && !this.containsFractions()) {
            dataString.append(((Symbol)button).getSymbol());
        }
        String string2 = dataString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final InputState getInputState(double maxAmount, double minAmount, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Double d = StringsKt.toDoubleOrNull((String)data);
        double amount = d != null ? d : Double.MIN_VALUE;
        return this.getInputState(maxAmount, minAmount, amount);
    }

    @NotNull
    public final InputState getInputState(double maxAmount, double minAmount, double amount) {
        return maxAmount == 0.0 ? (amount == Double.MIN_VALUE ? (InputState)InputState.Unspecified.INSTANCE : (InputState)InputState.Fine.INSTANCE) : (amount == Double.MIN_VALUE ? (InputState)InputState.Unspecified.INSTANCE : (amount < minAmount ? (InputState)new InputState.Min(System.currentTimeMillis()) : (amount > maxAmount ? (InputState)new InputState.Max(System.currentTimeMillis()) : (amount == Double.MIN_VALUE ? (InputState)InputState.Unspecified.INSTANCE : (InputState)InputState.Fine.INSTANCE))));
    }

    public final void append(@NotNull KeypadButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        KeypadButton keypadButton = button;
        if (keypadButton instanceof Backspace) {
            if (((CharSequence)this.data).length() > 0) {
                this.data.deleteCharAt(this.data.length() - 1);
            }
        } else if (keypadButton instanceof Point) {
            if (((CharSequence)this.data).length() == 0) {
                this.data.append('0' + ((Point)button).getSymbol());
            } else if (!StringsKt.contains$default((CharSequence)this.data, (CharSequence)((Point)button).getSymbol(), (boolean)false, (int)2, null)) {
                this.data.append(((Point)button).getSymbol());
            }
        } else if (keypadButton instanceof Symbol && !this.containsFractions()) {
            this.data.append(((Symbol)button).getSymbol());
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ Formatter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getDataAsFlow().emit((Object)Formatter.access$getData$p(this.this$0).toString(), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final String getText() {
        String string2 = this.data.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getSuffix() {
        return ((CharSequence)this.data).length() == 0 ? "0" : (StringsKt.endsWith$default((CharSequence)this.data, (CharSequence)".", (boolean)false, (int)2, null) ? "00" : (this.hasOneDecimalDigit() ? "0" : ""));
    }

    private final boolean containsFractions() {
        return Regex.find$default((Regex)this.fractionRegex, (CharSequence)this.data, (int)0, (int)2, null) != null;
    }

    private final boolean hasOneDecimalDigit() {
        return this.oneDecimalRegex.containsMatchIn((CharSequence)this.data);
    }

    public Formatter() {
        this(0, null, 3, null);
    }

    public static final /* synthetic */ StringBuilder access$getData$p(Formatter $this) {
        return $this.data;
    }
}

