/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.spend.data.totp;

import androidx.compose.runtime.internal.StabilityInferred;
import com.flexa.spend.data.totp.HmacOneTimePasswordConfig;
import com.flexa.spend.data.totp.OtpAuthUriBuilder;
import java.nio.ByteBuffer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/flexa/spend/data/totp/HmacOneTimePasswordGenerator;", "", "secret", "", "config", "Lcom/flexa/spend/data/totp/HmacOneTimePasswordConfig;", "([BLcom/flexa/spend/data/totp/HmacOneTimePasswordConfig;)V", "generate", "", "counter", "", "isValid", "", "code", "otpAuthUriBuilder", "Lcom/flexa/spend/data/totp/OtpAuthUriBuilder$Hotp;", "initialCounter", "spend_release"})
@StabilityInferred(parameters=0)
public class HmacOneTimePasswordGenerator {
    @NotNull
    private final byte[] secret;
    @NotNull
    private final HmacOneTimePasswordConfig config;
    public static final int $stable = 8;

    public HmacOneTimePasswordGenerator(@NotNull byte[] secret, @NotNull HmacOneTimePasswordConfig config) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.secret = secret;
        this.config = config;
    }

    @NotNull
    public final String generate(long counter) {
        if (this.config.getCodeDigits() <= 0) {
            return "";
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).putLong(0, counter);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"putLong(...)");
        ByteBuffer message = byteBuffer;
        Mac $this$generate_u24lambda_u240 = Mac.getInstance(this.config.getHmacAlgorithm().getMacAlgorithmName());
        boolean bl = false;
        $this$generate_u24lambda_u240.init(new SecretKeySpec(this.secret, "RAW"));
        byte[] hash = $this$generate_u24lambda_u240.doFinal(message.array());
        Intrinsics.checkNotNull((Object)hash);
        byte offset2 = (byte)(ArraysKt.last((byte[])hash) & 0xF);
        ByteBuffer $this$generate_u24lambda_u241 = bl = ByteBuffer.allocate(4);
        boolean bl2 = false;
        for (int i = 0; i < 4; ++i) {
            $this$generate_u24lambda_u241.put(i, hash[i + offset2]);
        }
        ByteBuffer binary = bl;
        binary.put(0, (byte)(binary.get(0) & 0x7F));
        int codeInt = binary.getInt() % (int)Math.pow(10.0, this.config.getCodeDigits());
        return StringsKt.padStart((String)String.valueOf(codeInt), (int)this.config.getCodeDigits(), (char)'0');
    }

    public final boolean isValid(@NotNull String code2, long counter) {
        Intrinsics.checkNotNullParameter((Object)code2, (String)"code");
        return Intrinsics.areEqual((Object)code2, (Object)this.generate(counter));
    }

    @NotNull
    public final OtpAuthUriBuilder.Hotp otpAuthUriBuilder(long initialCounter) {
        byte[] byArray = new Base32().encode(this.secret);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        return (OtpAuthUriBuilder.Hotp)((OtpAuthUriBuilder.Hotp)OtpAuthUriBuilder.Companion.forHotp(initialCounter, byArray).algorithm(this.config.getHmacAlgorithm())).digits(this.config.getCodeDigits());
    }
}

