/*
 * Decompiled with CFR 0.152.
 */
package com.flexa.spend.main.flexcode;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.encoder.Compaction;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.pdf417.encoder.PDF417;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0014\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/flexa/spend/main/flexcode/FlexaPDF417Writer;", "Lcom/google/zxing/Writer;", "aspectRatio", "", "(F)V", "encode", "Lcom/google/zxing/common/BitMatrix;", "contents", "", "format", "Lcom/google/zxing/BarcodeFormat;", "width", "", "height", "hints", "", "Lcom/google/zxing/EncodeHintType;", "Companion", "spend_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nFlexaPDF417Writer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlexaPDF417Writer.kt\ncom/flexa/spend/main/flexcode/FlexaPDF417Writer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class FlexaPDF417Writer
implements Writer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float aspectRatio;
    public static final int $stable;
    private static final int WHITE_SPACE = 30;
    private static final int DEFAULT_ERROR_CORRECTION_LEVEL = 2;

    public FlexaPDF417Writer(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @NotNull
    public BitMatrix encode(@NotNull String contents, @NotNull BarcodeFormat format, int width2, int height2, @Nullable Map<EncodeHintType, ?> hints) throws WriterException {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (!(format == BarcodeFormat.PDF_417)) {
            boolean $i$a$-require-FlexaPDF417Writer$encode$22 = false;
            String $i$a$-require-FlexaPDF417Writer$encode$22 = "Can only encode PDF_417, but got " + format;
            throw new IllegalArgumentException($i$a$-require-FlexaPDF417Writer$encode$22.toString());
        }
        PDF417 encoder = new PDF417();
        int margin = 30;
        int errorCorrectionLevel = 2;
        boolean autoECI = false;
        if (hints != null) {
            if (hints.containsKey(EncodeHintType.PDF417_COMPACT)) {
                encoder.setCompact(Boolean.parseBoolean(String.valueOf(hints.get(EncodeHintType.PDF417_COMPACT))));
            }
            if (hints.containsKey(EncodeHintType.PDF417_COMPACTION)) {
                encoder.setCompaction(Compaction.valueOf((String)String.valueOf(hints.get(EncodeHintType.PDF417_COMPACTION))));
            }
            if (hints.containsKey(EncodeHintType.PDF417_DIMENSIONS)) {
                Dimensions dimensions;
                Dimensions dimensions2 = dimensions = (Dimensions)hints.get(EncodeHintType.PDF417_DIMENSIONS);
                Intrinsics.checkNotNull((Object)dimensions2);
                encoder.setDimensions(dimensions2.getMaxCols(), dimensions.getMinCols(), dimensions.getMaxRows(), dimensions.getMinRows());
            }
            if (hints.containsKey(EncodeHintType.MARGIN)) {
                margin = Integer.parseInt(String.valueOf(hints.get(EncodeHintType.MARGIN)));
            }
            if (hints.containsKey(EncodeHintType.ERROR_CORRECTION)) {
                errorCorrectionLevel = Integer.parseInt(String.valueOf(hints.get(EncodeHintType.ERROR_CORRECTION)));
            }
            if (hints.containsKey(EncodeHintType.CHARACTER_SET)) {
                Charset encoding = Charset.forName(String.valueOf(hints.get(EncodeHintType.CHARACTER_SET)));
                encoder.setEncoding(encoding);
            }
            autoECI = hints.containsKey(EncodeHintType.PDF417_AUTO_ECI) && Boolean.parseBoolean(String.valueOf(hints.get(EncodeHintType.PDF417_AUTO_ECI)));
        }
        return FlexaPDF417Writer.Companion.bitMatrixFromEncoder(encoder, contents, errorCorrectionLevel, width2, height2, margin, autoECI, this.aspectRatio);
    }

    @NotNull
    public BitMatrix encode(@NotNull String contents, @NotNull BarcodeFormat format, int width2, int height2) throws WriterException {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return this.encode(contents, format, width2, height2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\fJH\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/flexa/spend/main/flexcode/FlexaPDF417Writer$Companion;", "", "()V", "DEFAULT_ERROR_CORRECTION_LEVEL", "", "WHITE_SPACE", "bitMatrixFromBitArray", "Lcom/google/zxing/common/BitMatrix;", "input", "", "", "margin", "([[BI)Lcom/google/zxing/common/BitMatrix;", "bitMatrixFromEncoder", "encoder", "Lcom/google/zxing/pdf417/encoder/PDF417;", "contents", "", "errorCorrectionLevel", "width", "height", "autoECI", "", "ratio", "", "rotateArray", "bitarray", "([[B)[[B", "spend_release"})
    public static final class Companion {
        private Companion() {
        }

        private final BitMatrix bitMatrixFromEncoder(PDF417 encoder, String contents, int errorCorrectionLevel, int width2, int height2, int margin, boolean autoECI, float ratio) throws WriterException {
            int scaleY;
            int scaleX;
            int scale;
            encoder.generateBarcodeLogic(contents, errorCorrectionLevel, autoECI);
            int aspectRatio = (int)ratio;
            byte[][] originalScale = encoder.getBarcodeMatrix().getScaledMatrix(1, aspectRatio);
            boolean rotated = false;
            if (height2 > width2 != originalScale[0].length < ((Object[])originalScale).length) {
                byte[][] byArray = originalScale;
                Intrinsics.checkNotNull((Object)byArray);
                originalScale = this.rotateArray(byArray);
                rotated = true;
            }
            if ((scale = RangesKt.coerceAtMost((int)(scaleX = width2 / originalScale[0].length), (int)(scaleY = height2 / ((Object[])originalScale).length))) > 1) {
                byte[][] byArray;
                byte[][] scaledMatrix = encoder.getBarcodeMatrix().getScaledMatrix(scale, scale * aspectRatio);
                if (rotated) {
                    byArray = scaledMatrix;
                    Intrinsics.checkNotNull((Object)byArray);
                    scaledMatrix = this.rotateArray(byArray);
                }
                byArray = scaledMatrix;
                Intrinsics.checkNotNull((Object)byArray);
                return this.bitMatrixFromBitArray(byArray, margin);
            }
            byte[][] byArray = originalScale;
            Intrinsics.checkNotNull((Object)byArray);
            return this.bitMatrixFromBitArray(byArray, margin);
        }

        private final BitMatrix bitMatrixFromBitArray(byte[][] input, int margin) {
            BitMatrix output = new BitMatrix(input[0].length + 2 * margin, ((Object[])input).length + 2 * margin);
            output.clear();
            int y = 0;
            int yOutput = output.getHeight() - margin - 1;
            while (y < ((Object[])input).length) {
                byte[] inputY = input[y];
                int n = input[0].length;
                for (int x = 0; x < n; ++x) {
                    if (inputY[x] != 1) continue;
                    output.set(x + margin, yOutput);
                }
                ++y;
                --yOutput;
            }
            return output;
        }

        private final byte[][] rotateArray(byte[][] bitarray) {
            int n = 0;
            int n2 = bitarray[0].length;
            byte[][] byArrayArray = new byte[n2][];
            while (n < n2) {
                int n3 = n++;
                byArrayArray[n3] = new byte[((Object[])bitarray).length];
            }
            byte[][] temp = byArrayArray;
            n2 = ((Object[])bitarray).length;
            for (int ii = 0; ii < n2; ++ii) {
                int inverseii = ((Object[])bitarray).length - ii - 1;
                int n4 = bitarray[0].length;
                for (int jj = 0; jj < n4; ++jj) {
                    temp[jj][inverseii] = bitarray[ii][jj];
                }
            }
            return temp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

