/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tcp;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Effect;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.async.Ref;
import fs2.async.mutable.Semaphore;
import fs2.async.package$;
import fs2.internal.FreeC;
import fs2.io.tcp.Socket;
import fs2.io.tcp.Socket$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.TimeUnit;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Socket$ {
    public static Socket$ MODULE$;

    static {
        new Socket$();
    }

    public <F> FreeC<?, BoxedUnit> client(InetSocketAddress to, boolean reuseAddress, int sendBufferSize, int receiveBufferSize, boolean keepAlive, boolean noDelay, AsynchronousChannelGroup AG, Effect<F> F, ExecutionContext ec) {
        return Stream$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> new Stream(Stream.InvariantOps$.MODULE$.flatMap$extension(Stream$.MODULE$.InvariantOps(Socket$.setup$1(reuseAddress, sendBufferSize, receiveBufferSize, keepAlive, noDelay, AG)), (Function1 & Serializable & scala.Serializable)ch -> new Stream(Stream$.MODULE$.bracket(Socket$.connect$1(ch, to$1, F$1, ec$1), (Function1 & Serializable & scala.Serializable)x$3 -> new Stream(Stream$.MODULE$.eval(Socket$.MODULE$.mkSocket(ch2, F$1, ec$1))), (Function1 & Serializable & scala.Serializable)ch -> Socket$.cleanup$1(ch, F$1))))));
    }

    public <F> FreeC<?, BoxedUnit> server(InetSocketAddress address, int maxQueued, boolean reuseAddress, int receiveBufferSize, AsynchronousChannelGroup AG, Effect<F> F, ExecutionContext ec) {
        return Stream$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> new Stream(Stream$.MODULE$.bracket(Socket$.setup$2(address, reuseAddress, receiveBufferSize, AG, F), (Function1 & Serializable & scala.Serializable)sch -> new Stream(Stream.PureOps$.MODULE$.$plus$plus$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Left().apply((Object)((InetSocketAddress)sch.getLocalAddress())))), (Function0 & Serializable & scala.Serializable)() -> new Stream(Stream$.MODULE$.map$extension(Socket$.acceptIncoming$1(sch, F$3, ec$3), (Function1 & Serializable & scala.Serializable)x$6 -> Socket$.$anonfun$server$11(((Stream)x$6).fs2$Stream$$free()))))), (Function1 & Serializable & scala.Serializable)sch -> Socket$.cleanup$2(sch, F$3))));
    }

    public <F> F mkSocket(AsynchronousSocketChannel ch, Effect<F> F, ExecutionContext ec) {
        return (F)implicits$.MODULE$.toFlatMapOps(package$.MODULE$.semaphore(1L, F, ec), F).flatMap((Function1 & Serializable & scala.Serializable)readSemaphore -> implicits$.MODULE$.toFunctorOps(package$.MODULE$.refOf((Object)ByteBuffer.allocate(0), (Sync)F), (Functor)F).map((Function1 & Serializable & scala.Serializable)bufferRef -> new Socket<F>(ch, F, ec, (Semaphore)readSemaphore, (Ref)bufferRef){
            private final AsynchronousSocketChannel ch$3;
            private final Effect F$2;
            private final ExecutionContext ec$2;
            private final Semaphore readSemaphore$1;
            private final Ref bufferRef$1;

            public Option<FiniteDuration> read$default$2() {
                return Socket.read$default$2$(this);
            }

            public Option<FiniteDuration> reads$default$2() {
                return Socket.reads$default$2$(this);
            }

            public Option<FiniteDuration> readN$default$2() {
                return Socket.readN$default$2$(this);
            }

            public Option<FiniteDuration> write$default$2() {
                return Socket.write$default$2$(this);
            }

            public Option<FiniteDuration> writes$default$1() {
                return Socket.writes$default$1$(this);
            }

            public F readN(int numBytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$readN0$1(numBytes, timeout, this.ch$3, this.F$2, this.ec$2, this.readSemaphore$1, this.bufferRef$1);
            }

            public F read(int maxBytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$read0$1(maxBytes, timeout, this.ch$3, this.F$2, this.ec$2, this.readSemaphore$1, this.bufferRef$1);
            }

            public FreeC<?, BoxedUnit> reads(int maxBytes, Option<FiniteDuration> timeout) {
                return Stream.InvariantOps$.MODULE$.flatMap$extension(Stream$.MODULE$.InvariantOps(Stream$.MODULE$.eval(this.read(maxBytes, timeout))), (Function1 & Serializable & scala.Serializable)x0$6 -> new Stream(anon.5.$anonfun$reads$1(this, maxBytes, timeout, x0$6)));
            }

            public F write(Chunk<Object> bytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$write0$1(bytes, timeout, this.ch$3, this.F$2, this.ec$2);
            }

            public Function1<FreeC<?, BoxedUnit>, FreeC<?, BoxedUnit>> writes(Option<FiniteDuration> timeout) {
                return (Function1 & Serializable & scala.Serializable)x$16 -> new Stream(anon.5.$anonfun$writes$1(this, timeout, ((Stream)x$16).fs2$Stream$$free()));
            }

            public F localAddress() {
                return (F)this.F$2.delay((Function0 & Serializable & scala.Serializable)() -> $this.ch$3.getLocalAddress());
            }

            public F remoteAddress() {
                return (F)this.F$2.delay((Function0 & Serializable & scala.Serializable)() -> $this.ch$3.getRemoteAddress());
            }

            public F close() {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.ch$3.close());
            }

            public F endOfOutput() {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.ch$3.shutdownOutput());
            }

            public F endOfInput() {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.ch$3.shutdownInput());
            }

            public static final /* synthetic */ FreeC $anonfun$reads$2(anon.5 $this, int maxBytes$1, Option timeout$3) {
                return $this.reads(maxBytes$1, (Option<FiniteDuration>)timeout$3);
            }

            public static final /* synthetic */ FreeC $anonfun$reads$1(anon.5 $this, int maxBytes$1, Option timeout$3, Option x0$6) {
                FreeC freeC;
                Option option = x0$6;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Chunk bytes = (Chunk)some.value();
                    freeC = Stream.PureOps$.MODULE$.$plus$plus$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.chunk(bytes)), (Function0 & Serializable & scala.Serializable)() -> new Stream(anon.5.$anonfun$reads$2($this, maxBytes$1, timeout$3)));
                } else if (None$.MODULE$.equals(option)) {
                    freeC = Stream$.MODULE$.covaryPure(Stream$.MODULE$.empty());
                } else {
                    throw new MatchError((Object)option);
                }
                return freeC;
            }

            public static final /* synthetic */ FreeC $anonfun$writes$2(anon.5 $this, Option timeout$4, Chunk bs) {
                return Stream$.MODULE$.eval($this.write((Chunk<Object>)bs, (Option<FiniteDuration>)timeout$4));
            }

            public static final /* synthetic */ FreeC $anonfun$writes$1(anon.5 $this, Option timeout$4, FreeC x$16) {
                return Stream.InvariantOps$.MODULE$.flatMap$extension(Stream$.MODULE$.InvariantOps(Stream$.MODULE$.chunks$extension(x$16)), (Function1 & Serializable & scala.Serializable)bs -> new Stream(anon.5.$anonfun$writes$2($this, timeout$4, bs)));
            }
            {
                this.ch$3 = ch$3;
                this.F$2 = F$2;
                this.ec$2 = ec$2;
                this.readSemaphore$1 = readSemaphore$1;
                this.bufferRef$1 = bufferRef$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$reads$1$adapted(fs2.io.tcp.Socket$$anon$5 int scala.Option scala.Option ), $anonfun$writes$1$adapted(fs2.io.tcp.Socket$$anon$5 scala.Option java.lang.Object ), $anonfun$localAddress$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$remoteAddress$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$close$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$endOfOutput$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$endOfInput$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$reads$2$adapted(fs2.io.tcp.Socket$$anon$5 int scala.Option ), $anonfun$writes$2$adapted(fs2.io.tcp.Socket$$anon$5 scala.Option fs2.Chunk )}, serializedLambda);
            }
        }));
    }

    public static final /* synthetic */ FreeC $anonfun$client$2(boolean reuseAddress$1, int sendBufferSize$1, int receiveBufferSize$1, boolean keepAlive$1, boolean noDelay$1, AsynchronousChannelGroup AG$1) {
        AsynchronousSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousSocketChannel(AG$1);
        ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(reuseAddress$1));
        ch.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, Predef$.MODULE$.int2Integer(sendBufferSize$1));
        ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(receiveBufferSize$1));
        ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, Predef$.MODULE$.boolean2Boolean(keepAlive$1));
        ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Predef$.MODULE$.boolean2Boolean(noDelay$1));
        return Stream$.MODULE$.covaryPure(Stream$.MODULE$.emit((Object)ch));
    }

    private static final FreeC setup$1(boolean reuseAddress$1, int sendBufferSize$1, int receiveBufferSize$1, boolean keepAlive$1, boolean noDelay$1, AsynchronousChannelGroup AG$1) {
        return Stream$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> new Stream(Socket$.$anonfun$client$2(reuseAddress$1, sendBufferSize$1, receiveBufferSize$1, keepAlive$1, noDelay$1, AG$1)));
    }

    private static final Object connect$1(AsynchronousSocketChannel ch, InetSocketAddress to$1, Effect F$1, ExecutionContext ec$1) {
        return F$1.async((Function1 & Serializable & scala.Serializable)cb -> {
            ch.connect(to$1, null, new CompletionHandler<Void, Void>(F$1, ec$1, ch, cb){
                private final Effect F$1;
                private final ExecutionContext ec$1;
                private final AsynchronousSocketChannel ch$1;
                private final Function1 cb$1;

                public void completed(Void result, Void attachment) {
                    package$.MODULE$.unsafeRunAsync(this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.cb$1.apply((Object)scala.package$.MODULE$.Right().apply((Object)$this.ch$1))), (Function1 & Serializable & scala.Serializable)x$1 -> IO$.MODULE$.pure((Object)BoxedUnit.UNIT), this.F$1, this.ec$1);
                }

                public void failed(Throwable rsn, Void attachment) {
                    package$.MODULE$.unsafeRunAsync(this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.cb$1.apply((Object)scala.package$.MODULE$.Left().apply((Object)rsn))), (Function1 & Serializable & scala.Serializable)x$2 -> IO$.MODULE$.pure((Object)BoxedUnit.UNIT), this.F$1, this.ec$1);
                }
                {
                    this.F$1 = F$1;
                    this.ec$1 = ec$1;
                    this.ch$1 = ch$1;
                    this.cb$1 = cb$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$completed$1(fs2.io.tcp.Socket$$anon$1 ), $anonfun$completed$2(scala.util.Either ), $anonfun$failed$1(fs2.io.tcp.Socket$$anon$1 java.lang.Throwable ), $anonfun$failed$2(scala.util.Either )}, serializedLambda);
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Object cleanup$1(AsynchronousSocketChannel ch, Effect F$1) {
        return F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ch.close());
    }

    private static final Object setup$2(InetSocketAddress address$1, boolean reuseAddress$2, int receiveBufferSize$2, AsynchronousChannelGroup AG$2, Effect F$3) {
        return F$3.delay((Function0 & Serializable & scala.Serializable)() -> {
            AsynchronousServerSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousServerSocketChannel(AG$2);
            ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(reuseAddress$2));
            ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(receiveBufferSize$2));
            ch.bind(address$1);
            return ch;
        });
    }

    private static final Object cleanup$2(AsynchronousServerSocketChannel sch, Effect F$3) {
        return F$3.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!sch.isOpen()) break block0;
                sch.close();
            }
        });
    }

    private static final Object acceptChannel$1(Effect F$3, ExecutionContext ec$3, AsynchronousServerSocketChannel sch$2) {
        return F$3.async((Function1 & Serializable & scala.Serializable)cb -> {
            sch$2.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(F$3, ec$3, cb){
                private final Effect F$3;
                private final ExecutionContext ec$3;
                private final Function1 cb$2;

                public void completed(AsynchronousSocketChannel ch, Void attachment) {
                    package$.MODULE$.unsafeRunAsync(this.F$3.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.cb$2.apply((Object)scala.package$.MODULE$.Right().apply((Object)ch))), (Function1 & Serializable & scala.Serializable)x$4 -> IO$.MODULE$.pure((Object)BoxedUnit.UNIT), this.F$3, this.ec$3);
                }

                public void failed(Throwable rsn, Void attachment) {
                    package$.MODULE$.unsafeRunAsync(this.F$3.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.cb$2.apply((Object)scala.package$.MODULE$.Left().apply((Object)rsn))), (Function1 & Serializable & scala.Serializable)x$5 -> IO$.MODULE$.pure((Object)BoxedUnit.UNIT), this.F$3, this.ec$3);
                }
                {
                    this.F$3 = F$3;
                    this.ec$3 = ec$3;
                    this.cb$2 = cb$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$completed$3(fs2.io.tcp.Socket$$anon$2 java.nio.channels.AsynchronousSocketChannel ), $anonfun$completed$4(scala.util.Either ), $anonfun$failed$3(fs2.io.tcp.Socket$$anon$2 java.lang.Throwable ), $anonfun$failed$4(scala.util.Either )}, serializedLambda);
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Object close$1(AsynchronousSocketChannel ch, Effect F$3) {
        return implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(F$3.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!ch.isOpen()) break block0;
                ch.close();
            }
        }), (ApplicativeError)F$3), (ApplicativeError)F$3), (Functor)F$3).as((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ FreeC $anonfun$server$6(Effect F$3, ExecutionContext ec$3, Either x0$1) {
        FreeC freeC;
        Either either = x0$1;
        if (either instanceof Left) {
            freeC = Stream.EmptyOps$.MODULE$.covary$extension(Stream$.MODULE$.EmptyOps(Stream$.MODULE$.empty()));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            AsynchronousSocketChannel accepted = (AsynchronousSocketChannel)right.value();
            freeC = Stream.InvariantOps$.MODULE$.onFinalize$extension(Stream$.MODULE$.InvariantOps(Stream$.MODULE$.eval(MODULE$.mkSocket(accepted, F$3, ec$3))), Socket$.close$1(accepted, F$3), (Applicative)F$3);
        } else {
            throw new MatchError((Object)either);
        }
        return freeC;
    }

    private static final FreeC go$1(Effect F$3, ExecutionContext ec$3, AsynchronousServerSocketChannel sch$2) {
        return Stream.InvariantOps$.MODULE$.$plus$plus$extension(Stream$.MODULE$.InvariantOps(Stream$.MODULE$.map$extension(Stream$.MODULE$.eval(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(Socket$.acceptChannel$1(F$3, ec$3, sch$2), (ApplicativeError)F$3), (ApplicativeError)F$3)), (Function1 & Serializable & scala.Serializable)x0$1 -> new Stream(Socket$.$anonfun$server$6(F$3, ec$3, x0$1)))), (Function0 & Serializable & scala.Serializable)() -> new Stream(Socket$.go$1(F$3, ec$3, sch$2)));
    }

    public static final /* synthetic */ FreeC $anonfun$server$8(AsynchronousServerSocketChannel sch$2, Throwable x0$2) {
        FreeC freeC;
        Throwable throwable = x0$2;
        if (throwable instanceof AsynchronousCloseException) {
            AsynchronousCloseException asynchronousCloseException = (AsynchronousCloseException)throwable;
            freeC = sch$2.isOpen() ? Stream$.MODULE$.covaryPure(Stream$.MODULE$.raiseError((Throwable)asynchronousCloseException)) : Stream$.MODULE$.covaryPure(Stream$.MODULE$.empty());
        } else {
            freeC = Stream$.MODULE$.covaryPure(Stream$.MODULE$.raiseError(throwable));
        }
        return freeC;
    }

    private static final FreeC acceptIncoming$1(AsynchronousServerSocketChannel sch, Effect F$3, ExecutionContext ec$3) {
        return Stream.InvariantOps$.MODULE$.handleErrorWith$extension(Stream$.MODULE$.InvariantOps(Socket$.go$1(F$3, ec$3, sch)), (Function1 & Serializable & scala.Serializable)x0$2 -> new Stream(Socket$.$anonfun$server$8(sch, x0$2)));
    }

    public static final /* synthetic */ Right $anonfun$server$11(FreeC x$6) {
        return scala.package$.MODULE$.Right().apply((Object)new Stream(x$6));
    }

    public static final /* synthetic */ void $anonfun$mkSocket$3(AsynchronousSocketChannel ch$3, Effect F$2, ExecutionContext ec$2, ByteBuffer buff$1, long timeoutMs$1, Function1 cb) {
        long started = System.currentTimeMillis();
        ch$3.read(buff$1, timeoutMs$1, TimeUnit.MILLISECONDS, BoxedUnit.UNIT, new CompletionHandler<Integer, BoxedUnit>(F$2, ec$2, started, cb){
            private final Effect F$2;
            private final ExecutionContext ec$2;
            private final long started$1;
            private final Function1 cb$3;

            public void completed(Integer result, BoxedUnit attachment) {
                long took = System.currentTimeMillis() - this.started$1;
                package$.MODULE$.unsafeRunAsync(this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.cb$3.apply((Object)scala.package$.MODULE$.Right().apply((Object)new Tuple2.mcIJ.sp(Predef$.MODULE$.Integer2int(result), took)))), (Function1 & Serializable & scala.Serializable)x$7 -> IO$.MODULE$.unit(), this.F$2, this.ec$2);
            }

            public void failed(Throwable err, BoxedUnit attachment) {
                package$.MODULE$.unsafeRunAsync(this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.cb$3.apply((Object)scala.package$.MODULE$.Left().apply((Object)err))), (Function1 & Serializable & scala.Serializable)x$8 -> IO$.MODULE$.unit(), this.F$2, this.ec$2);
            }
            {
                this.F$2 = F$2;
                this.ec$2 = ec$2;
                this.started$1 = started$1;
                this.cb$3 = cb$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$completed$5(fs2.io.tcp.Socket$$anon$3 java.lang.Integer long ), $anonfun$completed$6(scala.util.Either ), $anonfun$failed$5(fs2.io.tcp.Socket$$anon$3 java.lang.Throwable ), $anonfun$failed$6(scala.util.Either )}, serializedLambda);
            }
        });
    }

    private static final Object readChunk$1(ByteBuffer buff, long timeoutMs, AsynchronousSocketChannel ch$3, Effect F$2, ExecutionContext ec$2) {
        return F$2.async((Function1 & Serializable & scala.Serializable)cb -> {
            Socket$.$anonfun$mkSocket$3(ch$3, F$2, ec$2, buff, timeoutMs, cb);
            return BoxedUnit.UNIT;
        });
    }

    private static final Object getBufferOf$1(int sz, Effect F$2, Ref bufferRef$1) {
        return implicits$.MODULE$.toFlatMapOps(bufferRef$1.get(), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)buff -> buff.capacity() < sz ? implicits$.MODULE$.toFlatMapOps(F$2.delay((Function0 & Serializable & scala.Serializable)() -> ByteBuffer.allocate(sz)), (FlatMap)F$2).flatTap((Function1 & Serializable & scala.Serializable)a -> bufferRef$1.setSync(a)) : F$2.delay((Function0 & Serializable & scala.Serializable)() -> {
            buff.clear();
            buff.limit(sz);
            return buff;
        }));
    }

    private static final Object releaseBuffer$1(ByteBuffer buff, Effect F$2) {
        return F$2.delay((Function0 & Serializable & scala.Serializable)() -> {
            void var2_3;
            Chunk chunk;
            int read = buff.position();
            if (read == 0) {
                chunk = Chunk$.MODULE$.bytes((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            } else {
                byte[] dest = new byte[read];
                buff.flip();
                buff.get(dest);
                chunk = Chunk$.MODULE$.bytes(dest);
            }
            Chunk result = chunk;
            buff.clear();
            return var2_3;
        });
    }

    public static final Object fs2$io$tcp$Socket$$read0$1(int max, Option timeout, AsynchronousSocketChannel ch$3, Effect F$2, ExecutionContext ec$2, Semaphore readSemaphore$1, Ref bufferRef$1) {
        return implicits$.MODULE$.catsSyntaxApply(readSemaphore$1.decrement(), (Apply)F$2).$times$greater(implicits$.MODULE$.toFlatMapOps(F$2.attempt(implicits$.MODULE$.toFlatMapOps(Socket$.getBufferOf$1(max, F$2, bufferRef$1), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)buff -> implicits$.MODULE$.toFlatMapOps(Socket$.readChunk$1(buff, BoxesRunTime.unboxToLong((Object)timeout.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.toMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), ch$3, F$2, ec$2), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int read = tuple2._1$mcI$sp();
            Object object = read < 0 ? F$2.pure((Object)None$.MODULE$) : implicits$.MODULE$.toFunctorOps(Socket$.releaseBuffer$1(buff, F$2), (Functor)F$2).map((Function1 & Serializable & scala.Serializable)x$10 -> new Some(x$10));
            return object;
        }))), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)r -> {
            Object object;
            Apply.Ops ops = implicits$.MODULE$.catsSyntaxApply(readSemaphore$1.increment(), (Apply)F$2);
            Either either = r;
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                object = F$2.raiseError((Object)err);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Option maybeChunk = (Option)right.value();
                object = F$2.pure((Object)maybeChunk);
            } else {
                throw new MatchError((Object)either);
            }
            return ops.$times$greater(object);
        }));
    }

    private static final Object go$2(long timeoutMs, AsynchronousSocketChannel ch$3, Effect F$2, ExecutionContext ec$2, int max$1, ByteBuffer buff$6) {
        return implicits$.MODULE$.toFlatMapOps(Socket$.readChunk$1(buff$6, timeoutMs, ch$3, F$2, ec$2), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int readBytes = tuple2._1$mcI$sp();
            long took = tuple2._2$mcJ$sp();
            Object object = readBytes < 0 || buff$6.position() >= max$1 ? implicits$.MODULE$.toFunctorOps(Socket$.releaseBuffer$1(buff$6, F$2), (Functor)F$2).map((Function1 & Serializable & scala.Serializable)x$11 -> new Some(x$11)) : Socket$.go$2(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(timeoutMs - took), 0L), ch$3, F$2, ec$2, max$1, buff$6);
            return object;
        });
    }

    public static final Object fs2$io$tcp$Socket$$readN0$1(int max, Option timeout, AsynchronousSocketChannel ch$3, Effect F$2, ExecutionContext ec$2, Semaphore readSemaphore$1, Ref bufferRef$1) {
        return implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.catsSyntaxApply(readSemaphore$1.decrement(), (Apply)F$2).$times$greater(F$2.attempt(implicits$.MODULE$.toFlatMapOps(Socket$.getBufferOf$1(max, F$2, bufferRef$1), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)buff -> Socket$.go$2(BoxesRunTime.unboxToLong((Object)timeout.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.toMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), ch$3, F$2, ec$2, max, buff)))), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)r -> {
            Object object;
            Apply.Ops ops = implicits$.MODULE$.catsSyntaxApply(readSemaphore$1.increment(), (Apply)F$2);
            Either either = r;
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                object = F$2.raiseError((Object)err);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Option maybeChunk = (Option)right.value();
                object = F$2.pure((Object)maybeChunk);
            } else {
                throw new MatchError((Object)either);
            }
            return ops.$times$greater(object);
        });
    }

    public static final /* synthetic */ void $anonfun$mkSocket$21(AsynchronousSocketChannel ch$3, Effect F$2, ExecutionContext ec$2, ByteBuffer buff$3, long remains$1, Function1 cb) {
        long start = System.currentTimeMillis();
        ch$3.write(buff$3, remains$1, TimeUnit.MILLISECONDS, BoxedUnit.UNIT, new CompletionHandler<Integer, BoxedUnit>(F$2, ec$2, buff$3, start, cb){
            private final Effect F$2;
            private final ExecutionContext ec$2;
            private final ByteBuffer buff$3;
            private final long start$1;
            private final Function1 cb$4;

            public void completed(Integer result, BoxedUnit attachment) {
                package$.MODULE$.unsafeRunAsync(this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.cb$4.apply((Object)scala.package$.MODULE$.Right().apply($this.buff$3.remaining() <= 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - $this.start$1)))))), (Function1 & Serializable & scala.Serializable)x$13 -> IO$.MODULE$.pure((Object)BoxedUnit.UNIT), this.F$2, this.ec$2);
            }

            public void failed(Throwable err, BoxedUnit attachment) {
                package$.MODULE$.unsafeRunAsync(this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.cb$4.apply((Object)scala.package$.MODULE$.Left().apply((Object)err))), (Function1 & Serializable & scala.Serializable)x$14 -> IO$.MODULE$.pure((Object)BoxedUnit.UNIT), this.F$2, this.ec$2);
            }
            {
                this.F$2 = F$2;
                this.ec$2 = ec$2;
                this.buff$3 = buff$3;
                this.start$1 = start$1;
                this.cb$4 = cb$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$completed$7(fs2.io.tcp.Socket$$anon$4 ), $anonfun$completed$8(scala.util.Either ), $anonfun$failed$7(fs2.io.tcp.Socket$$anon$4 java.lang.Throwable ), $anonfun$failed$8(scala.util.Either )}, serializedLambda);
            }
        });
    }

    private static final Object go$3(ByteBuffer buff, long remains, AsynchronousSocketChannel ch$3, Effect F$2, ExecutionContext ec$2) {
        return implicits$.MODULE$.toFlatMapOps(F$2.async((Function1 & Serializable & scala.Serializable)cb -> {
            Socket$.$anonfun$mkSocket$21(ch$3, F$2, ec$2, buff, remains, cb);
            return BoxedUnit.UNIT;
        }), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Object object;
            Option option = x0$5;
            if (None$.MODULE$.equals(option)) {
                object = F$2.pure((Object)BoxedUnit.UNIT);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                long took = BoxesRunTime.unboxToLong((Object)some.value());
                object = Socket$.go$3(buff, RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(remains - took), 0L), ch$3, F$2, ec$2);
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public static final Object fs2$io$tcp$Socket$$write0$1(Chunk bytes, Option timeout, AsynchronousSocketChannel ch$3, Effect F$2, ExecutionContext ec$2) {
        return Socket$.go$3(bytes.toBytes(Predef.$eq$colon$eq$.MODULE$.tpEquals()).toByteBuffer(Predef.$eq$colon$eq$.MODULE$.tpEquals()), BoxesRunTime.unboxToLong((Object)timeout.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.toMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), ch$3, F$2, ec$2);
    }

    private Socket$() {
        MODULE$ = this;
    }
}

