/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tcp;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.effect.concurrent.Semaphore;
import cats.effect.concurrent.Semaphore$;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.io.AsyncYield;
import fs2.io.AsyncYield$;
import fs2.io.tcp.Socket;
import fs2.io.tcp.Socket$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.TimeUnit;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Socket$ {
    public static Socket$ MODULE$;

    static {
        new Socket$();
    }

    public <F> Resource<F, Socket<F>> client(InetSocketAddress to, boolean reuseAddress, int sendBufferSize, int receiveBufferSize, boolean keepAlive, boolean noDelay, AsynchronousChannelGroup AG, Concurrent<F> F, ContextShift<F> CS) {
        return this.mkClient(to, reuseAddress, sendBufferSize, receiveBufferSize, keepAlive, noDelay, AG, F, AsyncYield$.MODULE$.fromAsyncAndContextShift(F, CS));
    }

    public <F> boolean client$default$2() {
        return true;
    }

    public <F> int client$default$3() {
        return 262144;
    }

    public <F> int client$default$4() {
        return 262144;
    }

    public <F> boolean client$default$5() {
        return false;
    }

    public <F> boolean client$default$6() {
        return false;
    }

    public <F> Resource<F, Socket<F>> mkClient(InetSocketAddress to, boolean reuseAddress, int sendBufferSize, int receiveBufferSize, boolean keepAlive, boolean noDelay, AsynchronousChannelGroup AG, Concurrent<F> F, AsyncYield<F> Y) {
        return Resource$.MODULE$.liftF(implicits$.MODULE$.toFlatMapOps(Socket$.setup$1(reuseAddress, sendBufferSize, receiveBufferSize, keepAlive, noDelay, AG, F), F).flatMap((Function1 & Serializable & scala.Serializable)ch -> Socket$.connect$1(ch, to, Y)), F).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.apply((AsynchronousSocketChannel)x$1, F, Y));
    }

    public <F> boolean mkClient$default$2() {
        return true;
    }

    public <F> int mkClient$default$3() {
        return 262144;
    }

    public <F> int mkClient$default$4() {
        return 262144;
    }

    public <F> boolean mkClient$default$5() {
        return false;
    }

    public <F> boolean mkClient$default$6() {
        return false;
    }

    public <F> FreeC<?, BoxedUnit> server(InetSocketAddress address, int maxQueued, boolean reuseAddress, int receiveBufferSize, AsynchronousChannelGroup AG, Concurrent<F> F, ContextShift<F> CS) {
        return Stream$.MODULE$.collect$extension(this.serverWithLocalAddress(address, maxQueued, reuseAddress, receiveBufferSize, AG, F, CS), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Either<InetSocketAddress, Resource<F, Socket<F>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Right) {
                    Right right = (Right)A1;
                    Resource s = (Resource)right.value();
                    object = s;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Either<InetSocketAddress, Resource<F, Socket<F>>> x1) {
                Either<InetSocketAddress, Resource<F, Socket<F>>> either = x1;
                boolean bl = either instanceof Right;
                return bl;
            }
        });
    }

    public <F> int server$default$2() {
        return 0;
    }

    public <F> boolean server$default$3() {
        return true;
    }

    public <F> int server$default$4() {
        return 262144;
    }

    public <F> FreeC<?, BoxedUnit> serverWithLocalAddress(InetSocketAddress address, int maxQueued, boolean reuseAddress, int receiveBufferSize, AsynchronousChannelGroup AG, Concurrent<F> F, ContextShift<F> CS) {
        return this.mkServerWithLocalAddress(address, maxQueued, reuseAddress, receiveBufferSize, AG, F, AsyncYield$.MODULE$.fromAsyncAndContextShift(F, CS));
    }

    public <F> int serverWithLocalAddress$default$2() {
        return 0;
    }

    public <F> boolean serverWithLocalAddress$default$3() {
        return true;
    }

    public <F> int serverWithLocalAddress$default$4() {
        return 262144;
    }

    public <F> FreeC<?, BoxedUnit> mkServerWithLocalAddress(InetSocketAddress address, int maxQueued, boolean reuseAddress, int receiveBufferSize, AsynchronousChannelGroup AG, Concurrent<F> F, AsyncYield<F> Y) {
        Object setup = F.delay((Function0 & Serializable & scala.Serializable)() -> {
            AsynchronousServerSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousServerSocketChannel(AG);
            ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(reuseAddress));
            ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(receiveBufferSize));
            ch.bind(address);
            return ch;
        });
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.bracket(setup, (Function1 & Serializable & scala.Serializable)sch -> Socket$.cleanup$1(sch, F)), (Function1 & Serializable & scala.Serializable)sch -> new Stream(Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.emit((Object)package$.MODULE$.Left().apply((Object)((InetSocketAddress)sch.getLocalAddress()))), (Function0 & Serializable & scala.Serializable)() -> new Stream(Stream$.MODULE$.map$extension(Socket$.acceptIncoming$1(sch, F$3, Y$3), (Function1 & Serializable & scala.Serializable)x$2 -> package$.MODULE$.Right().apply(x$2))))));
    }

    public <F> int mkServerWithLocalAddress$default$2() {
        return 0;
    }

    public <F> boolean mkServerWithLocalAddress$default$3() {
        return true;
    }

    public <F> int mkServerWithLocalAddress$default$4() {
        return 262144;
    }

    private <F> Resource<F, Socket<F>> apply(AsynchronousSocketChannel ch, Concurrent<F> F, AsyncYield<F> Y) {
        Object socket = implicits$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, F), F).flatMap((Function1 & Serializable & scala.Serializable)readSemaphore -> implicits$.MODULE$.toFunctorOps(Ref$.MODULE$.of((Object)ByteBuffer.allocate(0), (Sync)F), (Functor)F).map((Function1 & Serializable & scala.Serializable)bufferRef -> new Socket<F>(ch, F, Y, (Semaphore)readSemaphore, (Ref)bufferRef){
            private final AsynchronousSocketChannel ch$2;
            private final Concurrent F$2;
            private final AsyncYield Y$2;
            private final Semaphore readSemaphore$1;
            private final Ref bufferRef$1;

            public Option<FiniteDuration> read$default$2() {
                return Socket.read$default$2$(this);
            }

            public Option<FiniteDuration> reads$default$2() {
                return Socket.reads$default$2$(this);
            }

            public Option<FiniteDuration> readN$default$2() {
                return Socket.readN$default$2$(this);
            }

            public Option<FiniteDuration> write$default$2() {
                return Socket.write$default$2$(this);
            }

            public Option<FiniteDuration> writes$default$1() {
                return Socket.writes$default$1$(this);
            }

            public F readN(int numBytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$readN0$1(numBytes, timeout, this.ch$2, this.F$2, this.Y$2, this.readSemaphore$1, this.bufferRef$1);
            }

            public F read(int maxBytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$read0$1(maxBytes, timeout, this.ch$2, this.F$2, this.Y$2, this.readSemaphore$1, this.bufferRef$1);
            }

            public FreeC<?, BoxedUnit> reads(int maxBytes, Option<FiniteDuration> timeout) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(this.read(maxBytes, timeout)), (Function1 & Serializable & scala.Serializable)x0$8 -> new Stream(anon.5.$anonfun$reads$1(this, maxBytes, timeout, x0$8)));
            }

            public F write(Chunk<Object> bytes, Option<FiniteDuration> timeout) {
                return (F)Socket$.fs2$io$tcp$Socket$$write0$1(bytes, timeout, this.ch$2, this.F$2, this.Y$2);
            }

            public Function1<FreeC<?, BoxedUnit>, FreeC<?, BoxedUnit>> writes(Option<FiniteDuration> timeout) {
                return (Function1 & Serializable & scala.Serializable)x$8 -> new Stream(anon.5.$anonfun$writes$1(this, timeout, ((Stream)x$8).fs2$Stream$$free()));
            }

            public F localAddress() {
                return (F)this.F$2.delay((Function0 & Serializable & scala.Serializable)() -> $this.ch$2.getLocalAddress());
            }

            public F remoteAddress() {
                return (F)this.F$2.delay((Function0 & Serializable & scala.Serializable)() -> $this.ch$2.getRemoteAddress());
            }

            public F close() {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.ch$2.close());
            }

            public F endOfOutput() {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.ch$2.shutdownOutput());
            }

            public F endOfInput() {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.ch$2.shutdownInput());
            }

            public static final /* synthetic */ FreeC $anonfun$reads$2(anon.5 $this, int maxBytes$1, Option timeout$3) {
                return $this.reads(maxBytes$1, (Option<FiniteDuration>)timeout$3);
            }

            public static final /* synthetic */ FreeC $anonfun$reads$1(anon.5 $this, int maxBytes$1, Option timeout$3, Option x0$8) {
                FreeC freeC;
                Option option = x0$8;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Chunk bytes = (Chunk)some.value();
                    freeC = Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.chunk(bytes), (Function0 & Serializable & scala.Serializable)() -> new Stream(anon.5.$anonfun$reads$2($this, maxBytes$1, timeout$3)));
                } else if (None$.MODULE$.equals(option)) {
                    freeC = Stream$.MODULE$.empty();
                } else {
                    throw new MatchError((Object)option);
                }
                return freeC;
            }

            public static final /* synthetic */ FreeC $anonfun$writes$2(anon.5 $this, Option timeout$4, Chunk bs) {
                return Stream$.MODULE$.eval($this.write((Chunk<Object>)bs, (Option<FiniteDuration>)timeout$4));
            }

            public static final /* synthetic */ FreeC $anonfun$writes$1(anon.5 $this, Option timeout$4, FreeC x$8) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.chunks$extension(x$8), (Function1 & Serializable & scala.Serializable)bs -> new Stream(anon.5.$anonfun$writes$2($this, timeout$4, bs)));
            }
            {
                this.ch$2 = ch$2;
                this.F$2 = F$2;
                this.Y$2 = Y$2;
                this.readSemaphore$1 = readSemaphore$1;
                this.bufferRef$1 = bufferRef$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$reads$1$adapted(fs2.io.tcp.Socket$$anon$5 int scala.Option scala.Option ), $anonfun$writes$1$adapted(fs2.io.tcp.Socket$$anon$5 scala.Option java.lang.Object ), $anonfun$localAddress$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$remoteAddress$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$close$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$endOfOutput$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$endOfInput$1(fs2.io.tcp.Socket$$anon$5 ), $anonfun$reads$2$adapted(fs2.io.tcp.Socket$$anon$5 int scala.Option ), $anonfun$writes$2$adapted(fs2.io.tcp.Socket$$anon$5 scala.Option fs2.Chunk )}, serializedLambda);
            }
        }));
        return Resource$.MODULE$.make(socket, (Function1 & Serializable & scala.Serializable)x$9 -> implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!ch.isOpen()) break block0;
                ch.close();
            }
        }), (ApplicativeError)F), (ApplicativeError)F), (Functor)F).void(), F);
    }

    private static final Object setup$1(boolean reuseAddress$1, int sendBufferSize$1, int receiveBufferSize$1, boolean keepAlive$1, boolean noDelay$1, AsynchronousChannelGroup AG$1, Concurrent F$1) {
        return F$1.delay((Function0 & Serializable & scala.Serializable)() -> {
            AsynchronousSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousSocketChannel(AG$1);
            ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(reuseAddress$1));
            ch.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, Predef$.MODULE$.int2Integer(sendBufferSize$1));
            ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(receiveBufferSize$1));
            ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, Predef$.MODULE$.boolean2Boolean(keepAlive$1));
            ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Predef$.MODULE$.boolean2Boolean(noDelay$1));
            return ch;
        });
    }

    private static final Object connect$1(AsynchronousSocketChannel ch, InetSocketAddress to$1, AsyncYield Y$1) {
        return Y$1.asyncYield((Function1 & Serializable & scala.Serializable)cb -> {
            ch.connect(to$1, null, new CompletionHandler<Void, Void>(ch, cb){
                private final AsynchronousSocketChannel ch$1;
                private final Function1 cb$1;

                public void completed(Void result, Void attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)this.ch$1));
                }

                public void failed(Throwable rsn, Void attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)rsn));
                }
                {
                    this.ch$1 = ch$1;
                    this.cb$1 = cb$1;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Object cleanup$1(AsynchronousServerSocketChannel sch, Concurrent F$3) {
        return F$3.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!sch.isOpen()) break block0;
                sch.close();
            }
        });
    }

    private static final Object acceptChannel$1(AsyncYield Y$3, AsynchronousServerSocketChannel sch$2) {
        return Y$3.asyncYield((Function1 & Serializable & scala.Serializable)cb -> {
            sch$2.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(cb){
                private final Function1 cb$2;

                public void completed(AsynchronousSocketChannel ch, Void attachment) {
                    this.cb$2.apply((Object)package$.MODULE$.Right().apply((Object)ch));
                }

                public void failed(Throwable rsn, Void attachment) {
                    this.cb$2.apply((Object)package$.MODULE$.Left().apply((Object)rsn));
                }
                {
                    this.cb$2 = cb$2;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ FreeC $anonfun$mkServerWithLocalAddress$4(Concurrent F$3, AsyncYield Y$3, Either x0$1) {
        FreeC freeC;
        Either either = x0$1;
        if (either instanceof Left) {
            freeC = Stream.PureOps$.MODULE$.apply$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.empty()));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            AsynchronousSocketChannel accepted = (AsynchronousSocketChannel)right.value();
            freeC = Stream$.MODULE$.emit(MODULE$.apply(accepted, F$3, Y$3));
        } else {
            throw new MatchError((Object)either);
        }
        return freeC;
    }

    private static final FreeC go$1(Concurrent F$3, AsyncYield Y$3, AsynchronousServerSocketChannel sch$2) {
        return Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(Socket$.acceptChannel$1(Y$3, sch$2), (ApplicativeError)F$3), (ApplicativeError)F$3)), (Function1 & Serializable & scala.Serializable)x0$1 -> new Stream(Socket$.$anonfun$mkServerWithLocalAddress$4(F$3, Y$3, x0$1))), (Function0 & Serializable & scala.Serializable)() -> new Stream(Socket$.go$1(F$3, Y$3, sch$2)));
    }

    public static final /* synthetic */ FreeC $anonfun$mkServerWithLocalAddress$6(Concurrent F$3, AsynchronousServerSocketChannel sch$2, Throwable x0$2) {
        FreeC freeC;
        Throwable throwable = x0$2;
        if (throwable instanceof AsynchronousCloseException) {
            AsynchronousCloseException asynchronousCloseException = (AsynchronousCloseException)throwable;
            freeC = sch$2.isOpen() ? Stream$.MODULE$.raiseError((Throwable)asynchronousCloseException, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F$3)) : Stream$.MODULE$.empty();
        } else {
            freeC = Stream$.MODULE$.raiseError(throwable, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F$3));
        }
        return freeC;
    }

    private static final FreeC acceptIncoming$1(AsynchronousServerSocketChannel sch, Concurrent F$3, AsyncYield Y$3) {
        return Stream$.MODULE$.handleErrorWith$extension(Socket$.go$1(F$3, Y$3, sch), (Function1 & Serializable & scala.Serializable)x0$2 -> new Stream(Socket$.$anonfun$mkServerWithLocalAddress$6(F$3, sch, x0$2)));
    }

    public static final /* synthetic */ void $anonfun$apply$3(AsynchronousSocketChannel ch$2, ByteBuffer buff$1, long timeoutMs$1, Function1 cb) {
        long started = System.currentTimeMillis();
        ch$2.read(buff$1, timeoutMs$1, TimeUnit.MILLISECONDS, BoxedUnit.UNIT, new CompletionHandler<Integer, BoxedUnit>(started, cb){
            private final long started$1;
            private final Function1 cb$3;

            public void completed(Integer result, BoxedUnit attachment) {
                long took = System.currentTimeMillis() - this.started$1;
                this.cb$3.apply((Object)package$.MODULE$.Right().apply((Object)new Tuple2.mcIJ.sp(Predef$.MODULE$.Integer2int(result), took)));
            }

            public void failed(Throwable err, BoxedUnit attachment) {
                this.cb$3.apply((Object)package$.MODULE$.Left().apply((Object)err));
            }
            {
                this.started$1 = started$1;
                this.cb$3 = cb$3;
            }
        });
    }

    private static final Object readChunk$1(ByteBuffer buff, long timeoutMs, AsynchronousSocketChannel ch$2, AsyncYield Y$2) {
        return Y$2.asyncYield((Function1 & Serializable & scala.Serializable)cb -> {
            Socket$.$anonfun$apply$3(ch$2, buff, timeoutMs, cb);
            return BoxedUnit.UNIT;
        });
    }

    private static final Object getBufferOf$1(int sz, Concurrent F$2, Ref bufferRef$1) {
        return implicits$.MODULE$.toFlatMapOps(bufferRef$1.get(), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)buff -> buff.capacity() < sz ? implicits$.MODULE$.toFlatMapOps(F$2.delay((Function0 & Serializable & scala.Serializable)() -> ByteBuffer.allocate(sz)), (FlatMap)F$2).flatTap((Function1 & Serializable & scala.Serializable)a -> bufferRef$1.set(a)) : F$2.delay((Function0 & Serializable & scala.Serializable)() -> {
            ((Buffer)buff).clear();
            ((Buffer)buff).limit(sz);
            return buff;
        }));
    }

    private static final Object releaseBuffer$1(ByteBuffer buff, Concurrent F$2) {
        return F$2.delay((Function0 & Serializable & scala.Serializable)() -> {
            void var2_3;
            Chunk chunk;
            int read = buff.position();
            if (read == 0) {
                chunk = Chunk$.MODULE$.bytes((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            } else {
                byte[] dest = new byte[read];
                ((Buffer)buff).flip();
                buff.get(dest);
                chunk = Chunk$.MODULE$.bytes(dest);
            }
            Chunk result = chunk;
            ((Buffer)buff).clear();
            return var2_3;
        });
    }

    public static final Object fs2$io$tcp$Socket$$read0$1(int max, Option timeout, AsynchronousSocketChannel ch$2, Concurrent F$2, AsyncYield Y$2, Semaphore readSemaphore$1, Ref bufferRef$1) {
        return readSemaphore$1.withPermit(implicits$.MODULE$.toFlatMapOps(F$2.attempt(implicits$.MODULE$.toFlatMapOps(Socket$.getBufferOf$1(max, F$2, bufferRef$1), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)buff -> implicits$.MODULE$.toFlatMapOps(Socket$.readChunk$1(buff, BoxesRunTime.unboxToLong((Object)timeout.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.toMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), ch$2, Y$2), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int read = tuple2._1$mcI$sp();
            Object object = read < 0 ? F$2.pure((Object)None$.MODULE$) : implicits$.MODULE$.toFunctorOps(Socket$.releaseBuffer$1(buff, F$2), (Functor)F$2).map((Function1 & Serializable & scala.Serializable)x$4 -> new Some(x$4));
            return object;
        }))), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Object object;
            Either either = x0$4;
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                object = F$2.raiseError((Object)err);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Option maybeChunk = (Option)right.value();
                object = F$2.pure((Object)maybeChunk);
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        }));
    }

    private static final Object go$2(long timeoutMs, AsynchronousSocketChannel ch$2, Concurrent F$2, AsyncYield Y$2, int max$1, ByteBuffer buff$6) {
        return implicits$.MODULE$.toFlatMapOps(Socket$.readChunk$1(buff$6, timeoutMs, ch$2, Y$2), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int readBytes = tuple2._1$mcI$sp();
            long took = tuple2._2$mcJ$sp();
            Object object = readBytes < 0 || buff$6.position() >= max$1 ? implicits$.MODULE$.toFunctorOps(Socket$.releaseBuffer$1(buff$6, F$2), (Functor)F$2).map((Function1 & Serializable & scala.Serializable)x$5 -> new Some(x$5)) : Socket$.go$2(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(timeoutMs - took), 0L), ch$2, F$2, Y$2, max$1, buff$6);
            return object;
        });
    }

    public static final Object fs2$io$tcp$Socket$$readN0$1(int max, Option timeout, AsynchronousSocketChannel ch$2, Concurrent F$2, AsyncYield Y$2, Semaphore readSemaphore$1, Ref bufferRef$1) {
        return readSemaphore$1.withPermit(implicits$.MODULE$.toFlatMapOps(F$2.attempt(implicits$.MODULE$.toFlatMapOps(Socket$.getBufferOf$1(max, F$2, bufferRef$1), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)buff -> Socket$.go$2(BoxesRunTime.unboxToLong((Object)timeout.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.toMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), ch$2, F$2, Y$2, max, buff))), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Object object;
            Either either = x0$6;
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                object = F$2.raiseError((Object)err);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Option maybeChunk = (Option)right.value();
                object = F$2.pure((Object)maybeChunk);
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        }));
    }

    public static final /* synthetic */ void $anonfun$apply$21(AsynchronousSocketChannel ch$2, ByteBuffer buff$3, long remains$1, Function1 cb) {
        long start = System.currentTimeMillis();
        ch$2.write(buff$3, remains$1, TimeUnit.MILLISECONDS, BoxedUnit.UNIT, new CompletionHandler<Integer, BoxedUnit>(buff$3, start, cb){
            private final ByteBuffer buff$3;
            private final long start$1;
            private final Function1 cb$4;

            public void completed(Integer result, BoxedUnit attachment) {
                this.cb$4.apply((Object)package$.MODULE$.Right().apply(this.buff$3.remaining() <= 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.start$1)))));
            }

            public void failed(Throwable err, BoxedUnit attachment) {
                this.cb$4.apply((Object)package$.MODULE$.Left().apply((Object)err));
            }
            {
                this.buff$3 = buff$3;
                this.start$1 = start$1;
                this.cb$4 = cb$4;
            }
        });
    }

    private static final Object go$3(ByteBuffer buff, long remains, AsynchronousSocketChannel ch$2, Concurrent F$2, AsyncYield Y$2) {
        return implicits$.MODULE$.toFlatMapOps(Y$2.asyncYield((Function1 & Serializable & scala.Serializable)cb -> {
            Socket$.$anonfun$apply$21(ch$2, buff, remains, cb);
            return BoxedUnit.UNIT;
        }), (FlatMap)F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Object object;
            Option option = x0$7;
            if (None$.MODULE$.equals(option)) {
                object = F$2.pure((Object)BoxedUnit.UNIT);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                long took = BoxesRunTime.unboxToLong((Object)some.value());
                object = Socket$.go$3(buff, RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(remains - took), 0L), ch$2, F$2, Y$2);
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public static final Object fs2$io$tcp$Socket$$write0$1(Chunk bytes, Option timeout, AsynchronousSocketChannel ch$2, Concurrent F$2, AsyncYield Y$2) {
        return Socket$.go$3(bytes.toBytes(Predef.$eq$colon$eq$.MODULE$.tpEquals()).toByteBuffer(Predef.$eq$colon$eq$.MODULE$.tpEquals()), BoxesRunTime.unboxToLong((Object)timeout.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.toMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), ch$2, F$2, Y$2);
    }

    private Socket$() {
        MODULE$ = this;
    }
}

