/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.io.tls.InputOutputBuffer;
import fs2.io.tls.InputOutputBuffer$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class InputOutputBuffer$ {
    public static final InputOutputBuffer$ MODULE$ = new InputOutputBuffer$();

    public <F> F apply(int inputSize, int outputSize, Sync<F> evidence$1) {
        return (F)package.all$.MODULE$.toFlatMapOps(Ref$.MODULE$.of((Object)ByteBuffer.allocate(inputSize), evidence$1), evidence$1).flatMap((Function1 & Serializable)inBuff -> package.all$.MODULE$.toFunctorOps(Ref$.MODULE$.of((Object)ByteBuffer.allocate(outputSize), evidence$1), (Functor)evidence$1).map((Function1 & Serializable)outBuff -> new InputOutputBuffer<F>((Ref)inBuff, evidence$1, (Ref)outBuff){
            private final Ref inBuff$1;
            private final Sync evidence$1$1;
            private final Ref outBuff$1;

            public F input(Chunk<Object> data) {
                return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.inBuff$1.get(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)in -> {
                    if (in.remaining() >= data.size()) {
                        return Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure(in);
                    }
                    ByteBuffer expanded = this.expandBuffer((ByteBuffer)in, (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable)capacity -> RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(capacity + data.size()), capacity * 2));
                    return package.all$.MODULE$.toFunctorOps($this.inBuff$1.set((Object)expanded), (Functor)$this.evidence$1$1).as((Object)expanded);
                }), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)in -> Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Chunk.Bytes bs = data.toBytes($less$colon$less$.MODULE$.refl());
                    in.put(bs.values(), bs.offset(), bs.size());
                }));
            }

            public <A> F perform(Function2<ByteBuffer, ByteBuffer, A> f) {
                return (F)package.all$.MODULE$.toFlatMapOps(this.inBuff$1.get(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)in -> package.all$.MODULE$.toFlatMapOps($this.outBuff$1.get(), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)out -> Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> {
                    ((Buffer)in).flip();
                    Object result = f.apply(in, out);
                    in.compact();
                    return result;
                })));
            }

            public F output(int maxBytes) {
                return (F)package.all$.MODULE$.toFlatMapOps(this.outBuff$1.get(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)out -> {
                    if (out.position() == 0) {
                        return Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure((Object)Chunk$.MODULE$.empty());
                    }
                    return Sync$.MODULE$.apply($this.evidence$1$1).delay((Function0 & Serializable)() -> {
                        ((Buffer)out).flip();
                        int cap = out.limit();
                        int sz = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(cap), maxBytes);
                        byte[] dest = new byte[sz];
                        out.get(dest);
                        out.compact();
                        return Chunk$.MODULE$.bytes(dest);
                    });
                });
            }

            private ByteBuffer expandBuffer(ByteBuffer buffer, Function1<Object, Object> resizeTo) {
                byte[] copy = new byte[buffer.position()];
                ByteBuffer next = ByteBuffer.allocate(resizeTo.apply$mcII$sp(buffer.capacity()));
                ((Buffer)buffer).flip();
                buffer.get(copy);
                return next.put(copy);
            }

            public F expandOutput() {
                return (F)this.outBuff$1.update((Function1 & Serializable)old -> this.expandBuffer((ByteBuffer)old, (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable)x$1 -> x$1 * 2));
            }

            public F inputRemains() {
                return (F)package.all$.MODULE$.toFunctorOps(this.inBuff$1.get(), (Functor)this.evidence$1$1).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)anon.1.$anonfun$inputRemains$1(x$2)));
            }

            public static final /* synthetic */ int $anonfun$inputRemains$1(ByteBuffer x$2) {
                return x$2.position();
            }
            {
                this.inBuff$1 = inBuff$1;
                this.evidence$1$1 = evidence$1$1;
                this.outBuff$1 = outBuff$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$expandOutput$1(fs2.io.tls.InputOutputBuffer$$anon$1 java.nio.ByteBuffer ), $anonfun$expandOutput$2(int ), $anonfun$input$1(fs2.io.tls.InputOutputBuffer$$anon$1 fs2.Chunk java.nio.ByteBuffer ), $anonfun$input$2(fs2.Chunk int ), $anonfun$input$3(fs2.io.tls.InputOutputBuffer$$anon$1 fs2.Chunk java.nio.ByteBuffer ), $anonfun$input$4(fs2.Chunk java.nio.ByteBuffer ), $anonfun$inputRemains$1$adapted(java.nio.ByteBuffer ), $anonfun$output$1(fs2.io.tls.InputOutputBuffer$$anon$1 int java.nio.ByteBuffer ), $anonfun$output$2(java.nio.ByteBuffer int ), $anonfun$perform$1(fs2.io.tls.InputOutputBuffer$$anon$1 scala.Function2 java.nio.ByteBuffer ), $anonfun$perform$2(fs2.io.tls.InputOutputBuffer$$anon$1 java.nio.ByteBuffer scala.Function2 java.nio.ByteBuffer ), $anonfun$perform$3(java.nio.ByteBuffer scala.Function2 java.nio.ByteBuffer )}, serializedLambda);
            }
        }));
    }

    private InputOutputBuffer$() {
    }
}

