/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.net.tls;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.std.Semaphore;
import cats.effect.std.Semaphore$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.io.net.tls.InputOutputBuffer;
import fs2.io.net.tls.InputOutputBuffer$;
import fs2.io.net.tls.SSLEngineTaskRunner;
import fs2.io.net.tls.SSLEngineTaskRunner$;
import fs2.io.net.tls.TLSEngine;
import fs2.io.net.tls.TLSEngine$;
import fs2.io.net.tls.TLSLogger;
import fs2.io.net.tls.TLSLogger$Disabled$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class TLSEngine$ {
    public static final TLSEngine$ MODULE$ = new TLSEngine$();

    public <F> F apply(SSLEngine engine, TLSEngine.Binding<F> binding, TLSLogger<F> logger, Async<F> evidence$1) {
        return (F)package.all$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getApplicationBufferSize(), engine.getSession().getPacketBufferSize(), evidence$1), evidence$1).flatMap((Function1 & Serializable)wrapBuffer -> package.all$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getPacketBufferSize(), engine.getSession().getApplicationBufferSize(), evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)unwrapBuffer -> package.all$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, (GenConcurrent)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)readSemaphore -> package.all$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, (GenConcurrent)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)writeSemaphore -> package.all$.MODULE$.toFunctorOps(Semaphore$.MODULE$.apply(1L, (GenConcurrent)evidence$1), (Functor)evidence$1).map((Function1 & Serializable)handshakeSemaphore -> {
            SSLEngineTaskRunner sslEngineTaskRunner = SSLEngineTaskRunner$.MODULE$.apply(engine, evidence$1);
            return new TLSEngine<F>(logger, evidence$1, engine, (Semaphore)writeSemaphore, (InputOutputBuffer)wrapBuffer, (Semaphore)handshakeSemaphore, binding, (Semaphore)readSemaphore, (InputOutputBuffer)unwrapBuffer, sslEngineTaskRunner){
                private final Function1<Function0<String>, F> doLog;
                private final Async evidence$1$1;
                private final SSLEngine engine$1;
                private final Semaphore writeSemaphore$1;
                private final InputOutputBuffer wrapBuffer$1;
                private final Semaphore handshakeSemaphore$1;
                private final TLSEngine.Binding binding$1;
                private final Semaphore readSemaphore$1;
                private final InputOutputBuffer unwrapBuffer$1;
                private final SSLEngineTaskRunner sslEngineTaskRunner$1;

                private Function1<Function0<String>, F> doLog() {
                    return this.doLog;
                }

                private F log(Function0<String> msg) {
                    return (F)this.doLog().apply(msg);
                }

                public F beginHandshake() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.beginHandshake());
                }

                public F session() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0 & Serializable)() -> $this.engine$1.getSession());
                }

                public F applicationProtocol() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0 & Serializable)() -> $this.engine$1.getApplicationProtocol());
                }

                public F stopWrap() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.closeOutbound());
                }

                public F stopUnwrap() {
                    return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.closeInbound()), (ApplicativeError)this.evidence$1$1), (ApplicativeError)this.evidence$1$1), (Functor)this.evidence$1$1).void();
                }

                public F write(Chunk<Object> data) {
                    return (F)this.writeSemaphore$1.permit().use((Function1 & Serializable)x$2 -> this.write0(data), (MonadCancel)this.evidence$1$1);
                }

                private F write0(Chunk<Object> data) {
                    return (F)FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.wrapBuffer$1.input(data), (FlatMap)this.evidence$1$1), (Function0 & Serializable)() -> this.wrap(), (FlatMap)this.evidence$1$1);
                }

                private F wrap() {
                    return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2 & Serializable)(x$3, x$4) -> $this.engine$1.wrap((ByteBuffer)x$3, (ByteBuffer)x$4)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("wrap result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> {
                                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                                Object object = ((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus)) ? package.all$.MODULE$.toFlatMapOps($this.wrapBuffer$1.inputRemains(), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x -> anon.1.$anonfun$wrap$6(this, result, BoxesRunTime.unboxToInt((Object)x))) : FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.handshakeSemaphore$1.permit().use((Function1 & Serializable)x$5 -> this.stepHandshake((SSLEngineResult)result, true), (MonadCancel)$this.evidence$1$1), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.wrap(), (FlatMap)$this.evidence$1$1);
                                return object;
                            }, (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.doWrite();
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.wrap(), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = this.stopWrap();
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F doWrite() {
                    return (F)package.all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.output(Integer.MAX_VALUE), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)out -> out.isEmpty() ? Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit() : $this.binding$1.write((Chunk<Object>)out));
                }

                public F read(int maxBytes) {
                    return (F)this.readSemaphore$1.permit().use((Function1 & Serializable)x$6 -> this.read0(maxBytes), (MonadCancel)this.evidence$1$1);
                }

                private F initialHandshakeDone() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                        String string = $this.engine$1.getSession().getCipherSuite();
                        String string2 = "SSL_NULL_WITH_NULL_NULL";
                        return string == null ? string2 != null : !string.equals(string2);
                    });
                }

                private F read0(int maxBytes) {
                    return (F)package.all$.MODULE$.toFlatMapOps(this.unwrapThenTakeUnwrapped(maxBytes), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)out -> out.isEmpty() ? IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM(this.initialHandshakeDone(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.read1(maxBytes), (Function0 & Serializable)() -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.write((Chunk<Object>)Chunk$.MODULE$.empty()), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> package.all$.MODULE$.toFlatMapOps(this.unwrapThenTakeUnwrapped(maxBytes), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)out -> out.isEmpty() ? this.read1(maxBytes) : Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure(out)), (FlatMap)$this.evidence$1$1), (FlatMap)$this.evidence$1$1) : Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure(out));
                }

                private F read1(int maxBytes) {
                    return (F)package.all$.MODULE$.toFlatMapOps(this.binding$1.read(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(maxBytes), this.engine$1.getSession().getPacketBufferSize())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)x0$1 -> {
                        Object object;
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input((Chunk<Object>)c), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> package.all$.MODULE$.toFlatMapOps(this.unwrap(maxBytes), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x0$2 -> {
                                Object object;
                                Option option = x0$2;
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    object = Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure((Object)some);
                                } else if (None$.MODULE$.equals(option)) {
                                    object = this.read1(maxBytes);
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                return object;
                            }), (FlatMap)$this.evidence$1$1);
                        } else if (None$.MODULE$.equals(option)) {
                            object = Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure((Object)None$.MODULE$);
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return object;
                    });
                }

                private F unwrap(int maxBytes) {
                    return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2 & Serializable)(x$7, x$8) -> $this.engine$1.unwrap((ByteBuffer)x$7, (ByteBuffer)x$8)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("unwrap result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                            Object object2 = ((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus)) ? IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM(package.all$.MODULE$.toFunctorOps($this.unwrapBuffer$1.inputRemains(), (Functor)$this.evidence$1$1).map((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> x$9 > 0 && result.bytesConsumed() > 0), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.unwrap(maxBytes), (Function0 & Serializable)() -> this.takeUnwrapped(maxBytes), (FlatMap)$this.evidence$1$1) : (((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED))).equals((Object)((Object)handshakeStatus)) ? this.unwrap(maxBytes) : FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.handshakeSemaphore$1.permit().use((Function1 & Serializable)x$10 -> this.stepHandshake((SSLEngineResult)result, false), (MonadCancel)$this.evidence$1$1), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.unwrap(maxBytes), (FlatMap)$this.evidence$1$1));
                            object = object2;
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.takeUnwrapped(maxBytes);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.unwrap(maxBytes), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.takeUnwrapped(maxBytes), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F takeUnwrapped(int maxBytes) {
                    return (F)package.all$.MODULE$.toFunctorOps(this.unwrapBuffer$1.output(maxBytes), (Functor)this.evidence$1$1).map((Function1 & Serializable)out -> out.isEmpty() ? None$.MODULE$ : new Some(out));
                }

                private F unwrapThenTakeUnwrapped(int maxBytes) {
                    return (F)IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM(package.all$.MODULE$.toFunctorOps(this.unwrapBuffer$1.inputRemains(), (Functor)this.evidence$1$1).map((Function1)(JFunction1.mcZI.sp & Serializable)x$11 -> x$11 > 0), (FlatMap)this.evidence$1$1), (Function0 & Serializable)() -> this.unwrap(maxBytes), (Function0 & Serializable)() -> this.takeUnwrapped(maxBytes), (FlatMap)this.evidence$1$1);
                }

                private F stepHandshake(SSLEngineResult result, boolean lastOperationWrap) {
                    Object object;
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)).equals((Object)((Object)handshakeStatus))) {
                        object = Applicative$.MODULE$.apply((Applicative)this.evidence$1$1).unit();
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED)).equals((Object)((Object)handshakeStatus))) {
                        object = package.all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)remaining -> anon.1.$anonfun$stepHandshake$1(this, BoxesRunTime.unboxToInt((Object)remaining)));
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_TASK)).equals((Object)((Object)handshakeStatus))) {
                        object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.sslEngineTaskRunner$1.runDelegatedTasks(), (FlatMap)this.evidence$1$1), (Function0 & Serializable)() -> lastOperationWrap ? this.wrapHandshake() : this.unwrapHandshake(), (FlatMap)this.evidence$1$1);
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)).equals((Object)((Object)handshakeStatus))) {
                        object = this.wrapHandshake();
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP)).equals((Object)((Object)handshakeStatus))) {
                        object = package.all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)remaining -> anon.1.$anonfun$stepHandshake$3(this, result, BoxesRunTime.unboxToInt((Object)remaining)));
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN)).equals((Object)((Object)handshakeStatus))) {
                        object = this.unwrapHandshake();
                    } else {
                        throw new MatchError((Object)((Object)handshakeStatus));
                    }
                    return (F)object;
                }

                private F wrapHandshake() {
                    return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2 & Serializable)(x$12, x$13) -> $this.engine$1.wrap((ByteBuffer)x$12, (ByteBuffer)x$13)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("wrapHandshake result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        boolean bl = ((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status)) ? true : ((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status));
                        if (bl) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stepHandshake((SSLEngineResult)result, true), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.wrapHandshake(), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F unwrapHandshake() {
                    return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2 & Serializable)(x$14, x$15) -> $this.engine$1.unwrap((ByteBuffer)x$14, (ByteBuffer)x$15)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("unwrapHandshake result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            object = this.stepHandshake((SSLEngineResult)result, false);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.stepHandshake((SSLEngineResult)result, false);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.unwrapHandshake(), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                public static final /* synthetic */ Object $anonfun$wrap$6(anon.1 $this, SSLEngineResult result$2, int x) {
                    return ApplicativeOps$.MODULE$.whenA$extension(package.all$.MODULE$.catsSyntaxApplicative($this.wrap()), x > 0 && result$2.bytesConsumed() > 0, (Applicative)$this.evidence$1$1);
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$1(anon.1 $this, int remaining) {
                    return remaining > 0 ? $this.unwrapHandshake() : Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit();
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$6(anon.1 $this, int x) {
                    return x > 0 ? Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit() : $this.stopUnwrap();
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public static final /* synthetic */ Object $anonfun$stepHandshake$3(anon.1 $this, SSLEngineResult result$5, int remaining) {
                    Object object;
                    if (remaining > 0) {
                        SSLEngineResult.Status status = result$5.getStatus();
                        SSLEngineResult.Status status2 = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                        if (status == null ? status2 != null : !((Object)((Object)status)).equals((Object)((Object)status2))) {
                            object = $this.unwrapHandshake();
                            return object;
                        }
                    }
                    object = package.all$.MODULE$.toFlatMapOps($this.binding$1.read($this.engine$1.getSession().getPacketBufferSize()), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x0$1 -> {
                        Object object;
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input((Chunk<Object>)c), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> $this.unwrapHandshake(), (FlatMap)$this.evidence$1$1);
                        } else if (None$.MODULE$.equals(option)) {
                            object = package.all$.MODULE$.toFlatMapOps($this.unwrapBuffer$1.inputRemains(), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x -> anon.1.$anonfun$stepHandshake$6($this, BoxesRunTime.unboxToInt((Object)x)));
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return object;
                    });
                    return object;
                }
                {
                    Function1 & Serializable intersect;
                    this.evidence$1$1 = evidence$1$1;
                    this.engine$1 = engine$1;
                    this.writeSemaphore$1 = writeSemaphore$1;
                    this.wrapBuffer$1 = wrapBuffer$1;
                    this.handshakeSemaphore$1 = handshakeSemaphore$1;
                    this.binding$1 = binding$1;
                    this.readSemaphore$1 = readSemaphore$1;
                    this.unwrapBuffer$1 = unwrapBuffer$1;
                    this.sslEngineTaskRunner$1 = sslEngineTaskRunner$1;
                    TLSLogger tLSLogger = logger$1;
                    if (tLSLogger instanceof TLSLogger.Enabled) {
                        TLSLogger.Enabled enabled = (TLSLogger.Enabled)tLSLogger;
                        intersect = (Function1 & Serializable)msg -> enabled.log().apply(msg);
                    } else if (TLSLogger$Disabled$.MODULE$.equals(tLSLogger)) {
                        intersect = (Function1 & Serializable)x$1 -> Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit();
                    } else {
                        throw new MatchError((Object)tLSLogger);
                    }
                    this.doLog = intersect;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applicationProtocol$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$beginHandshake$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$doLog$1(fs2.io.net.tls.TLSLogger$Enabled scala.Function0 ), $anonfun$doLog$2(fs2.io.net.tls.TLSEngine$$anon$1 scala.Function0 ), $anonfun$doWrite$1(fs2.io.net.tls.TLSEngine$$anon$1 fs2.Chunk ), $anonfun$initialHandshakeDone$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$read$1(fs2.io.net.tls.TLSEngine$$anon$1 int scala.runtime.BoxedUnit ), $anonfun$read0$1(fs2.io.net.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read0$2(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$read0$3(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$read0$4(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$read0$5(fs2.io.net.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read1$1(fs2.io.net.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read1$2(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$read1$3(fs2.io.net.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$session$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$stepHandshake$1$adapted(fs2.io.net.tls.TLSEngine$$anon$1 java.lang.Object ), $anonfun$stepHandshake$2(fs2.io.net.tls.TLSEngine$$anon$1 boolean ), $anonfun$stepHandshake$3$adapted(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult java.lang.Object ), $anonfun$stepHandshake$4(fs2.io.net.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$stepHandshake$5(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$stepHandshake$6$adapted(fs2.io.net.tls.TLSEngine$$anon$1 java.lang.Object ), $anonfun$stopUnwrap$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$stopWrap$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$takeUnwrapped$1(fs2.Chunk ), $anonfun$unwrap$1(fs2.io.net.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$unwrap$10(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$11(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$unwrap$12(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$2(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$3(javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$4(fs2.io.net.tls.TLSEngine$$anon$1 int javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$5(javax.net.ssl.SSLEngineResult int ), $anonfun$unwrap$6(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$7(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$8(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult scala.runtime.BoxedUnit ), $anonfun$unwrap$9(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrapHandshake$1(fs2.io.net.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$unwrapHandshake$2(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$3(javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$4(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$5(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$unwrapHandshake$6(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$unwrapThenTakeUnwrapped$1(int ), $anonfun$unwrapThenTakeUnwrapped$2(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrapThenTakeUnwrapped$3(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$wrap$1(fs2.io.net.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$wrap$2(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrap$3(javax.net.ssl.SSLEngineResult ), $anonfun$wrap$4(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrap$5(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrap$6$adapted(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult java.lang.Object ), $anonfun$wrap$7(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult scala.runtime.BoxedUnit ), $anonfun$wrap$8(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$wrap$9(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$wrapHandshake$1(fs2.io.net.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$wrapHandshake$2(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$3(javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$4(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$5(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$6(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$wrapHandshake$7(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$write$1(fs2.io.net.tls.TLSEngine$$anon$1 fs2.Chunk scala.runtime.BoxedUnit ), $anonfun$write0$1(fs2.io.net.tls.TLSEngine$$anon$1 )}, serializedLambda);
                }
            };
        })))));
    }

    private TLSEngine$() {
    }
}

